/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.server.hibernate.id.CDOIDHibernate;
import org.eclipse.emf.cdo.server.hibernate.internal.id.CDOIDHibernateFactoryImpl;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateThreadContext;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDORevisionTuplizer;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.property.Getter;

public class CDOVirtualPropertyGetter
implements Getter {
    private static final long serialVersionUID = 1L;
    private final boolean isResourceIdProperty;
    private final boolean isContainerIdProperty;
    private final boolean isContainingFeatureIdProperty;
    private final String propertyName;

    public CDOVirtualPropertyGetter(CDORevisionTuplizer tuplizer, String propertyName) {
        this.isResourceIdProperty = propertyName.compareTo("resourceID") == 0;
        this.isContainerIdProperty = propertyName.compareTo("containerID") == 0;
        this.isContainingFeatureIdProperty = propertyName.compareTo("containingFeatureID") == 0;
        this.propertyName = propertyName;
        if (!(this.isResourceIdProperty || this.isContainerIdProperty || this.isContainingFeatureIdProperty)) {
            throw new IllegalArgumentException("Propertyname " + propertyName + " not supported must be one of resourceID, containerID, containingFeatureID");
        }
    }

    public Object get(Object target) throws HibernateException {
        InternalCDORevision revision = (InternalCDORevision)target;
        if (this.isResourceIdProperty) {
            CDOID cdoID = revision.getResourceID();
            if (cdoID instanceof CDOIDTemp) {
                CDOIDHibernate hibernateID = CDOIDHibernateFactoryImpl.getInstance().createCDOID((Serializable)Integer.valueOf(((CDOIDTemp)cdoID).getIntValue()), "CDOResource");
                revision.setResourceID((CDOID)hibernateID);
                if (HibernateThreadContext.isHibernateCommitContextSet()) {
                    HibernateThreadContext.getHibernateCommitContext().setNewID(cdoID, (CDOID)hibernateID);
                }
            }
            return revision.getResourceID();
        }
        if (this.isContainerIdProperty) {
            return revision.getContainerID();
        }
        if (this.isContainingFeatureIdProperty) {
            return revision.getContainingFeatureID();
        }
        throw new IllegalArgumentException("Propertyname " + this.propertyName + " not supported must be one of resourceID, containerID, containingFeatureID");
    }

    public Object getForInsert(Object target, Map mergeMap, SessionImplementor session) throws HibernateException {
        return this.get(target);
    }

    public Method getMethod() {
        return null;
    }

    public String getMethodName() {
        return null;
    }

    public Class getReturnType() {
        return Object.class;
    }
}

