/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import org.eclipse.emf.cdo.common.CDOQueryInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.server.IQueryContext;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.server.QueryHandlerFactory;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.ProductCreationException;

public class ResourcesQueryHandler
implements IQueryHandler {
    public void executeQuery(final CDOQueryInfo info, final IQueryContext context) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        accessor.queryResources(new IStoreAccessor.QueryResourcesContext(){

            public long getTimeStamp() {
                return context.getTimeStamp();
            }

            public CDOID getFolderID() {
                return (CDOID)info.getParameters().get("folder");
            }

            public String getName() {
                return info.getQueryString();
            }

            public boolean exactMatch() {
                return (Boolean)info.getParameters().get("exactMatch");
            }

            public int getMaxResults() {
                return info.getMaxResults();
            }

            public boolean addResource(CDOID resourceID) {
                return context.addResult(resourceID);
            }
        });
    }

    public static class Factory
    extends QueryHandlerFactory {
        public Factory() {
            super("resources");
        }

        public IQueryHandler create(String description) throws ProductCreationException {
            return new ResourcesQueryHandler();
        }

        public static IQueryHandler get(IManagedContainer container, String queryLanguage) {
            return (IQueryHandler)container.getElement("org.eclipse.emf.cdo.server.queryHandlerFactories", "resources", null);
        }
    }
}

