/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDObjectFactory;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.internal.common.revision.CDORevisionResolverImpl;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IRevisionManager;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IStoreChunkReader;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.collection.MoveableList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionManager
extends CDORevisionResolverImpl
implements IRevisionManager {
    private IRepository repository;
    private IStoreAccessor.AdditionalRevisionCache additionalRevisionCache;

    @Override
    public IRepository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(IRepository repository) {
        this.repository = repository;
    }

    public CDOIDObjectFactory getCDOIDObjectFactory() {
        return this.repository.getStore().getCDOIDObjectFactory();
    }

    protected InternalCDORevision verifyRevision(InternalCDORevision revision, int referenceChunk) {
        IStoreAccessor accessor = null;
        revision = super.verifyRevision(revision, referenceChunk);
        if (this.repository.isVerifyingRevisions()) {
            accessor = StoreThreadLocal.getAccessor();
            revision = accessor.verifyRevision(revision);
        }
        this.ensureChunks(revision, referenceChunk, accessor);
        return revision;
    }

    protected void ensureChunks(InternalCDORevision revision, int referenceChunk, IStoreAccessor accessor) {
        EClass eClass = revision.getEClass();
        EStructuralFeature[] features = CDOModelUtil.getAllPersistentFeatures((EClass)eClass);
        int i = 0;
        while (i < features.length) {
            EStructuralFeature feature = features[i];
            if (feature.isMany()) {
                CDOList list = revision.getList(feature);
                int chunkEnd = Math.min(referenceChunk, list.size());
                accessor = this.ensureChunk(revision, feature, accessor, (MoveableList<Object>)list, 0, chunkEnd);
            }
            ++i;
        }
    }

    public IStoreAccessor ensureChunk(InternalCDORevision revision, EStructuralFeature feature, int chunkStart, int chunkEnd) {
        CDOList list = revision.getList(feature);
        chunkEnd = Math.min(chunkEnd, list.size());
        return this.ensureChunk(revision, feature, StoreThreadLocal.getAccessor(), (MoveableList<Object>)list, chunkStart, chunkEnd);
    }

    protected IStoreAccessor ensureChunk(InternalCDORevision revision, EStructuralFeature feature, IStoreAccessor accessor, MoveableList<Object> list, int chunkStart, int chunkEnd) {
        IStoreChunkReader chunkReader = null;
        int fromIndex = -1;
        int j = chunkStart;
        while (j < chunkEnd) {
            if (list.get(j) == InternalCDOList.UNINITIALIZED) {
                if (fromIndex == -1) {
                    fromIndex = j;
                }
            } else if (fromIndex != -1) {
                int toIndex;
                if (chunkReader == null) {
                    if (accessor == null) {
                        accessor = StoreThreadLocal.getAccessor();
                    }
                    chunkReader = accessor.createChunkReader(revision, feature);
                }
                if (fromIndex == (toIndex = j) - 1) {
                    chunkReader.addSimpleChunk(fromIndex);
                } else {
                    chunkReader.addRangedChunk(fromIndex, toIndex);
                }
                fromIndex = -1;
            }
            ++j;
        }
        if (fromIndex != -1) {
            int toIndex;
            if (chunkReader == null) {
                if (accessor == null) {
                    accessor = StoreThreadLocal.getAccessor();
                }
                chunkReader = accessor.createChunkReader(revision, feature);
            }
            if (fromIndex == (toIndex = chunkEnd) - 1) {
                chunkReader.addSimpleChunk(fromIndex);
            } else {
                chunkReader.addRangedChunk(fromIndex, toIndex);
            }
        }
        if (chunkReader != null) {
            List<IStoreChunkReader.Chunk> chunks = chunkReader.executeRead();
            for (IStoreChunkReader.Chunk chunk : chunks) {
                int startIndex = chunk.getStartIndex();
                int indexInChunk = 0;
                while (indexInChunk < chunk.size()) {
                    Object id = chunk.get(indexInChunk);
                    list.set(startIndex + indexInChunk, id);
                    ++indexInChunk;
                }
            }
        }
        return accessor;
    }

    protected InternalCDORevision loadRevision(CDOID id, int referenceChunk) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.readRevision(id, referenceChunk, this.additionalRevisionCache);
    }

    protected InternalCDORevision loadRevisionByTime(CDOID id, int referenceChunk, long timeStamp) {
        if (this.getRepository().isSupportingAudits()) {
            IStoreAccessor accessor = StoreThreadLocal.getAccessor();
            return accessor.readRevisionByTime(id, referenceChunk, this.additionalRevisionCache, timeStamp);
        }
        throw new UnsupportedOperationException("No support for auditing mode");
    }

    protected InternalCDORevision loadRevisionByVersion(CDOID id, int referenceChunk, int version) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        if (this.getRepository().isSupportingAudits()) {
            return accessor.readRevisionByVersion(id, referenceChunk, this.additionalRevisionCache, version);
        }
        InternalCDORevision revision = this.loadRevision(id, referenceChunk);
        if (revision.getVersion() == version) {
            return revision;
        }
        throw new IllegalStateException("Cannot access object with id " + id + " and version " + version);
    }

    protected List<InternalCDORevision> loadRevisions(Collection<CDOID> ids, int referenceChunk) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        ArrayList<InternalCDORevision> revisions = new ArrayList<InternalCDORevision>();
        for (CDOID id : ids) {
            InternalCDORevision revision = accessor.readRevision(id, referenceChunk, this.additionalRevisionCache);
            revisions.add(revision);
        }
        return revisions;
    }

    protected List<InternalCDORevision> loadRevisionsByTime(Collection<CDOID> ids, int referenceChunk, long timeStamp) {
        ArrayList<InternalCDORevision> revisions = new ArrayList<InternalCDORevision>();
        for (CDOID id : ids) {
            InternalCDORevision revision = this.loadRevisionByTime(id, referenceChunk, timeStamp);
            revisions.add(revision);
        }
        return revisions;
    }

    protected int getLRUCapacity(String prop) {
        String capacity = this.repository.getProperties().get(prop);
        return capacity == null ? 0 : Integer.valueOf(capacity);
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.additionalRevisionCache = new IStoreAccessor.AdditionalRevisionCache(){

            public void cacheRevision(InternalCDORevision revision) {
                RevisionManager.this.addCachedRevision(revision);
            }
        };
    }
}

