/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.internal.ui.actions.ChangePassiveUpdateAction;
import org.eclipse.emf.cdo.internal.ui.actions.ImportRootsAction;
import org.eclipse.emf.cdo.internal.ui.actions.ReadLockObjectsAction;
import org.eclipse.emf.cdo.internal.ui.actions.ReloadObjectsAction;
import org.eclipse.emf.cdo.internal.ui.actions.WriteLockObjectsAction;
import org.eclipse.emf.cdo.internal.ui.editor.CDOEditor;
import org.eclipse.emf.cdo.internal.ui.editor.PluginDelegator;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    public static final String copyright = "Copyright (c) 2004 - 2009 Eike Stepper (Berlin, Germany) and others.\r\nAll rights reserved. This program and the accompanying materials\r\nare made available under the terms of the Eclipse Public License v1.0\r\nwhich accompanies this distribution, and is available at\r\nhttp://www.eclipse.org/legal/epl-v10.html\r\n\r\nContributors:\r\n   Eike Stepper - initial API and implementation";
    public static final String LOAD_RESOURCE_ID = "load-resource";
    public static final String REFRESH_VIEWER_ID = "refresh-viewer";
    protected ImportRootsAction importRootsAction;
    protected ReloadObjectsAction reloadObjectsAction;
    protected ReadLockObjectsAction readLockObjectsAction;
    protected WriteLockObjectsAction writeLockObjectsAction;
    protected ChangePassiveUpdateAction changePassiveUpdateAction;
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected IAction showPropertiesViewAction = new Action(PluginDelegator.INSTANCE.getString("_UI_ShowPropertiesView_menu_item")){

        public void run() {
            try {
                CDOActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException exception) {
                PluginDelegator.INSTANCE.log((Object)exception);
            }
        }
    };
    protected IAction refreshViewerAction = new Action(PluginDelegator.INSTANCE.getString("_UI_RefreshViewer_menu_item")){

        public boolean isEnabled() {
            return CDOActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (CDOActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)CDOActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                viewer.refresh();
            }
        }
    };
    protected Collection<IAction> createChildActions;
    protected IMenuManager createChildMenuManager;
    protected Collection<IAction> createSiblingActions;
    protected IMenuManager createSiblingMenuManager;

    public CDOActionBarContributor() {
        super(1);
        this.loadResourceAction = new LoadResourceAction();
        this.loadResourceAction.setId(LOAD_RESOURCE_ID);
        this.importRootsAction = new ImportRootsAction();
        this.importRootsAction.setId("import-roots");
        this.reloadObjectsAction = new ReloadObjectsAction();
        this.changePassiveUpdateAction = new ChangePassiveUpdateAction();
        this.readLockObjectsAction = new ReadLockObjectsAction();
        this.writeLockObjectsAction = new WriteLockObjectsAction();
        this.validateAction = new ValidateAction();
        this.controlAction = new ControlAction();
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("cdo-settings"));
        toolBarManager.add((IContributionItem)new Separator("cdo-additions"));
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        MenuManager submenuManager = new MenuManager(PluginDelegator.INSTANCE.getString("_UI_CDOEditor_menu"), "org.eclipse.emf.cdo.internal.ui.editorMenuID");
        menuManager.insertAfter("additions", (IContributionItem)submenuManager);
        submenuManager.add((IContributionItem)new Separator("settings"));
        submenuManager.add((IContributionItem)new Separator("actions"));
        submenuManager.add((IContributionItem)new Separator("additions"));
        submenuManager.add((IContributionItem)new Separator("additions-end"));
        this.createChildMenuManager = new MenuManager(PluginDelegator.INSTANCE.getString("_UI_CreateChild_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
        this.createSiblingMenuManager = new MenuManager(PluginDelegator.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createSiblingMenuManager);
        submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.updateAll(true);
            }
        });
        this.addGlobalActions((IMenuManager)submenuManager);
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.activeEditorPart = part;
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void selectionChangedGen(SelectionChangedEvent event) {
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        if (this.createSiblingMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
        }
        Collection newChildDescriptors = null;
        Collection newSiblingDescriptors = null;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            newChildDescriptors = domain.getNewChildDescriptors(object, null);
            newSiblingDescriptors = domain.getNewChildDescriptors(null, object);
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        this.createSiblingActions = this.generateCreateSiblingActions(newSiblingDescriptors, selection);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
        if (this.createSiblingMenuManager != null) {
            this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
            this.createSiblingMenuManager.update(true);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        if (this.createSiblingMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
        }
        Collection newChildDescriptors = null;
        Collection newSiblingDescriptors = null;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            if (this.reloadObjectsAction != null) {
                this.reloadObjectsAction.selectionChanged((IStructuredSelection)selection);
            }
            if (this.readLockObjectsAction != null) {
                this.readLockObjectsAction.selectionChanged((IStructuredSelection)selection);
            }
            if (this.writeLockObjectsAction != null) {
                this.writeLockObjectsAction.selectionChanged((IStructuredSelection)selection);
            }
            if (((IStructuredSelection)selection).size() == 1) {
                Object object = ((IStructuredSelection)selection).getFirstElement();
                EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
                newChildDescriptors = domain.getNewChildDescriptors(object, null);
                newSiblingDescriptors = domain.getNewChildDescriptors(null, object);
                if (this.importRootsAction != null) {
                    if (object instanceof CDOResource) {
                        this.importRootsAction.setTargetResource((CDOResource)object);
                    } else {
                        this.importRootsAction.setTargetResource(null);
                    }
                }
            }
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        this.createSiblingActions = this.generateCreateSiblingActions(newSiblingDescriptors, selection);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
        if (this.createSiblingMenuManager != null) {
            this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
            this.createSiblingMenuManager.update(true);
        }
    }

    protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateChildAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateSiblingAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        if (actions != null) {
            for (IAction iAction : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    protected void depopulateManager(IContributionManager manager, Collection<? extends IAction> actions) {
        if (actions != null) {
            IContributionItem[] items = manager.getItems();
            int i = 0;
            while (i < items.length) {
                IAction action;
                IContributionItem contributionItem = items[i];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++i;
            }
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
        MenuManager submenuManager = null;
        submenuManager = new MenuManager(PluginDelegator.INSTANCE.getString("_UI_CreateChild_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        submenuManager = new MenuManager(PluginDelegator.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createSiblingActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
    }

    protected void addGlobalActionsGen(IMenuManager menuManager) {
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        menuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.refreshViewerAction);
        super.addGlobalActions(menuManager);
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        menuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        this.refreshViewerAction.setId(REFRESH_VIEWER_ID);
        menuManager.insertAfter("ui-actions", this.refreshViewerAction);
        menuManager.insertBefore(this.refreshViewerAction.getId(), (IAction)this.reloadObjectsAction);
        MenuManager lockingSubMenu = new MenuManager(Messages.getString("CDOActionBarContributor_0"));
        lockingSubMenu.add((IContributionItem)new Separator("ui-actions"));
        lockingSubMenu.insertAfter("ui-actions", (IAction)this.writeLockObjectsAction);
        this.writeLockObjectsAction.update();
        lockingSubMenu.insertAfter("ui-actions", (IAction)this.readLockObjectsAction);
        this.readLockObjectsAction.update();
        menuManager.insertAfter("ui-actions", (IContributionItem)lockingSubMenu);
        menuManager.insertAfter("ui-actions", (IAction)this.changePassiveUpdateAction);
        this.changePassiveUpdateAction.update();
        this.changePassiveUpdateAction.setEnabled(true);
        super.addGlobalActions(menuManager);
        if (this.loadResourceAction != null) {
            if (this.importRootsAction != null) {
                menuManager.insertAfter(this.loadResourceAction.getId(), (IAction)this.importRootsAction);
            }
        } else {
            if (this.importRootsAction != null) {
                menuManager.insertBefore("additions-end", (IAction)this.importRootsAction);
            }
            menuManager.insertBefore("additions-end", (IContributionItem)new Separator());
        }
    }

    protected boolean removeAllReferencesOnDelete() {
        return true;
    }

    public void activate() {
        Object input;
        if (this.importRootsAction != null) {
            this.importRootsAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
            input = ((CDOEditor)this.getActiveEditor()).getViewer().getInput();
            if (input instanceof CDOResource) {
                this.importRootsAction.setTargetResource((CDOResource)input);
            } else {
                this.importRootsAction.setTargetResource(null);
            }
        }
        if (this.reloadObjectsAction != null) {
            this.reloadObjectsAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        }
        if (this.changePassiveUpdateAction != null && (input = ((CDOEditor)this.getActiveEditor()).getViewer().getInput()) instanceof CDOResource) {
            CDOView view = ((CDOResource)input).cdoView();
            this.changePassiveUpdateAction.setSession(view.getSession());
        }
        super.activate();
    }

    public void deactivate() {
        if (this.importRootsAction != null) {
            this.importRootsAction.setActiveWorkbenchPart(null);
            this.importRootsAction.setTargetResource(null);
        }
        if (this.reloadObjectsAction != null) {
            this.reloadObjectsAction.setActiveWorkbenchPart(null);
        }
        super.deactivate();
    }

    public void update() {
        super.update();
        if (this.importRootsAction != null) {
            this.importRootsAction.update();
        }
        if (this.reloadObjectsAction != null) {
            this.reloadObjectsAction.update();
        }
    }
}

