/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapper;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.Basic;
import org.eclipse.emf.teneo.annotations.pannotation.Column;
import org.eclipse.emf.teneo.annotations.pannotation.FetchType;
import org.eclipse.emf.teneo.annotations.pannotation.ManyToOne;
import org.eclipse.emf.teneo.annotations.pannotation.PannotationFactory;
import org.eclipse.emf.teneo.annotations.pannotation.TemporalType;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.hbannotation.Index;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEAttribute;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedETypeElement;
import org.eclipse.emf.teneo.hibernate.mapper.AbstractMapper;
import org.eclipse.emf.teneo.simpledom.Element;

public class BasicMapper
extends AbstractMapper
implements ExtensionPoint {
    private static final Log log = LogFactory.getLog(BasicMapper.class);

    public void processBasic(PAnnotatedEAttribute paAttribute) {
        log.debug((Object)("processBasic " + paAttribute.getModelEAttribute().getName()));
        EAttribute eattr = paAttribute.getModelEAttribute();
        String attrName = this.getHbmContext().getPropertyName((EStructuralFeature)eattr);
        Element propElement = this.getHbmContext().getCurrent().addElement("property").addAttribute("name", attrName);
        Basic basic = paAttribute.getBasic();
        if (basic == null) {
            basic = PannotationFactory.eINSTANCE.createBasic();
        }
        propElement.addAttribute("lazy", FetchType.LAZY.equals((Object)basic.getFetch()) ? "true" : "false");
        this.addColumnsAndFormula(propElement, (PAnnotatedEStructuralFeature)paAttribute, this.getColumns((PAnnotatedEStructuralFeature)paAttribute), this.isNullable(basic, paAttribute), true);
        boolean isNullable = this.isNullable(basic, paAttribute);
        propElement.addAttribute("not-null", isNullable ? "false" : "true");
        this.setType(paAttribute, propElement);
        if (((HbAnnotatedEAttribute)paAttribute).getGenerated() != null && ((HbAnnotatedEAttribute)paAttribute).getGenerated().getValue() != null) {
            propElement.addAttribute("generated", ((HbAnnotatedEAttribute)paAttribute).getGenerated().getValue().getName().toLowerCase());
        }
        if (((HbAnnotatedEAttribute)paAttribute).getHbIndex() != null) {
            Index index = ((HbAnnotatedEAttribute)paAttribute).getHbIndex();
            propElement.addAttribute("index", index.getName());
        }
        this.addAccessor(propElement);
        this.addNaturalId((HbAnnotatedEAttribute)paAttribute, propElement);
    }

    public void processExternalEReference(PAnnotatedEReference paReference) {
        log.debug((Object)("processExternal " + paReference.getModelEReference().getName()));
        EReference eref = paReference.getModelEReference();
        String propName = this.getHbmContext().getPropertyName((EStructuralFeature)eref);
        Element propElement = this.getHbmContext().getCurrent().addElement("property").addAttribute("name", propName);
        ManyToOne mto = paReference.getManyToOne();
        if (mto == null) {
            mto = PannotationFactory.eINSTANCE.createManyToOne();
        }
        propElement.addAttribute("lazy", FetchType.LAZY.equals((Object)mto.getFetch()) ? "true" : "false");
        boolean isNullable = this.isNullable(mto, (PAnnotatedEStructuralFeature)paReference);
        this.addColumnsAndFormula(propElement, (PAnnotatedEStructuralFeature)paReference, this.getColumns((PAnnotatedEStructuralFeature)paReference), isNullable, true);
        propElement.addAttribute("not-null", isNullable ? "false" : "true");
        this.setType(paReference, propElement);
        if (((HbAnnotatedETypeElement)paReference).getHbIndex() != null) {
            Index index = ((HbAnnotatedETypeElement)paReference).getHbIndex();
            propElement.addAttribute("index", index.getName());
        }
        this.addAccessor(propElement);
    }

    public void processTemporal(PAnnotatedEAttribute paAttribute) {
        log.debug((Object)("processTemporal " + paAttribute.getModelEAttribute().getName()));
        TemporalType tt = paAttribute.getTemporal().getValue();
        String attrName = this.getHbmContext().getPropertyName((EStructuralFeature)paAttribute.getModelEAttribute());
        log.debug((Object)("addProperty: " + attrName + " temporal " + tt.getName()));
        Element propElement = this.getHbmContext().getCurrent().addElement("property").addAttribute("name", attrName);
        Basic basic = paAttribute.getBasic();
        if (basic == null) {
            basic = PannotationFactory.eINSTANCE.createBasic();
        }
        propElement.addAttribute("lazy", FetchType.LAZY.equals((Object)basic.getFetch()) ? "true" : "false");
        this.addColumnsAndFormula(propElement, (PAnnotatedEStructuralFeature)paAttribute, this.getColumns((PAnnotatedEStructuralFeature)paAttribute), this.isNullable(basic, paAttribute), true);
        propElement.addAttribute("not-null", this.isNullable(basic, paAttribute) ? "false" : "true");
        if (((HbAnnotatedEAttribute)paAttribute).getGenerated() != null && ((HbAnnotatedEAttribute)paAttribute).getGenerated().getValue() != null) {
            propElement.addAttribute("generated", ((HbAnnotatedEAttribute)paAttribute).getGenerated().getValue().getName().toLowerCase());
        }
        this.setType(paAttribute, propElement);
        this.addAccessor(propElement);
        this.addNaturalId((HbAnnotatedEAttribute)paAttribute, propElement);
    }

    public void processLob(PAnnotatedEAttribute paAttribute) {
        EAttribute eAttribute = paAttribute.getModelEAttribute();
        log.debug((Object)("processLob " + eAttribute.getName()));
        Element propElement = this.getHbmContext().getCurrent().addElement("property");
        propElement.addAttribute("name", this.getHbmContext().getPropertyName((EStructuralFeature)eAttribute));
        Basic basic = paAttribute.getBasic();
        if (basic == null) {
            basic = PannotationFactory.eINSTANCE.createBasic();
        }
        propElement.addAttribute("lazy", FetchType.LAZY.equals((Object)basic.getFetch()) ? "true" : "false");
        this.addColumnsAndFormula(propElement, (PAnnotatedEStructuralFeature)paAttribute, this.getColumns((PAnnotatedEStructuralFeature)paAttribute), this.isNullable(basic, paAttribute), true);
        boolean isNullable = this.isNullable(basic, paAttribute);
        this.isNullable(basic, paAttribute);
        propElement.addAttribute("not-null", isNullable ? "false" : "true");
        this.setType(paAttribute, propElement);
        this.addAccessor(propElement);
        this.addNaturalId((HbAnnotatedEAttribute)paAttribute, propElement);
    }

    public void processEnum(PAnnotatedEAttribute paAttribute) {
        log.debug((Object)("processEnum " + paAttribute.getModelEAttribute()));
        Basic basic = paAttribute.getBasic();
        if (basic == null) {
            basic = PannotationFactory.eINSTANCE.createBasic();
        }
        List<Column> columns = this.getColumns((PAnnotatedEStructuralFeature)paAttribute);
        Element propElement = this.getHbmContext().getCurrent().addElement("property").addAttribute("name", this.getHbmContext().getPropertyName((EStructuralFeature)paAttribute.getModelEAttribute()));
        propElement.addAttribute("lazy", FetchType.LAZY.equals((Object)basic.getFetch()) ? "true" : "false");
        propElement.addAttribute("not-null", this.isNullable(basic, paAttribute) ? "false" : "true");
        this.addColumnsAndFormula(propElement, (PAnnotatedEStructuralFeature)paAttribute, columns, this.isNullable(basic, paAttribute) || this.getHbmContext().isCurrentElementFeatureMap(), true);
        this.setType(paAttribute, propElement);
        this.addAccessor(propElement);
        this.addNaturalId((HbAnnotatedEAttribute)paAttribute, propElement);
    }

    public void processVersion(PAnnotatedEAttribute paAttribute) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating version for " + paAttribute.getModelEAttribute().getName()));
        }
        EAttribute eAttribute = paAttribute.getModelEAttribute();
        Element propElement = this.getHbmContext().getCurrent().addElement("version").addAttribute("name", eAttribute.getName());
        List<Column> columns = this.getColumns((PAnnotatedEStructuralFeature)paAttribute);
        if (columns.size() > 1) {
            log.warn((Object)("Version has more than one attribute, only using the first one, eclass: " + paAttribute.getModelEAttribute().getEContainingClass().getName()));
        }
        this.addColumnsAndFormula(propElement, (PAnnotatedEStructuralFeature)paAttribute, columns, this.getHbmContext().isCurrentElementFeatureMap(), false);
        this.setType(paAttribute, propElement);
        this.addAccessor(propElement, this.hbmContext.getVersionPropertyHandlerName());
        this.addNaturalId((HbAnnotatedEAttribute)paAttribute, propElement);
    }

    protected void addNaturalId(HbAnnotatedEAttribute hbAttr, Element element) {
        if (hbAttr.getNaturalId() != null) {
            element.addAttribute("natural-id", Boolean.toString(hbAttr.getNaturalId().isMutable()));
        }
    }

    public void processTransient(PAnnotatedEStructuralFeature paFeature) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Skipping transient feature for " + paFeature.getModelEStructuralFeature().getName()));
        }
    }

    private boolean isNullable(Basic basic, PAnnotatedEAttribute aattr) {
        return this.getHbmContext().isDoForceOptional((PAnnotatedEStructuralFeature)aattr) || (aattr.getColumn() == null || !aattr.getColumn().isSetNullable()) && basic.isOptional() || this.getHbmContext().isCurrentElementFeatureMap() || aattr.getColumn() != null && aattr.getColumn().isNullable();
    }

    private boolean isNullable(ManyToOne mto, PAnnotatedEStructuralFeature paFeature) {
        return this.getHbmContext().isDoForceOptional(paFeature) || (paFeature.getColumn() == null || !paFeature.getColumn().isSetNullable()) && mto.isOptional() || this.getHbmContext().isCurrentElementFeatureMap() || paFeature.getColumn() != null && paFeature.getColumn().isNullable();
    }
}

