/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om.trace;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.om.trace.OMTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerfTracer
extends ContextTracer {
    public static final long NOT_STARTED = 0L;
    private ConcurrentMap<Object, Long> timers = new ConcurrentHashMap<Object, Long>();

    public PerfTracer(OMTracer delegate, Class<?> context) {
        super(delegate, context);
    }

    public void start(Object object) {
        if (this.isEnabled()) {
            this.timers.put(object, System.currentTimeMillis());
        }
    }

    public long stop(Object object) {
        Long timer;
        long duration = 0L;
        if (this.isEnabled() && (timer = (Long)this.timers.remove(object)) != null) {
            duration = System.currentTimeMillis() - timer;
            this.format("{0} = {1} millis", object, duration);
        }
        return duration;
    }

    public long getDuration(Object object) {
        Long timer;
        long duration = 0L;
        if (this.isEnabled() && (timer = (Long)this.timers.get(object)) != null) {
            duration = System.currentTimeMillis() - timer;
        }
        return duration;
    }
}

