/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.buffer.IBufferHandler;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class BufferInputStream
extends InputStream
implements IBufferHandler {
    public static final long NO_TIMEOUT = -1L;
    public static final long DEFAULT_MILLIS_BEFORE_TIMEOUT = -1L;
    public static final long DEFAULT_MILLIS_INTERRUPT_CHECK = 100L;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_BUFFER_STREAM, BufferInputStream.class);
    private BlockingQueue<IBuffer> buffers = new LinkedBlockingQueue<IBuffer>();
    private IBuffer currentBuffer;
    private boolean eos;

    public void handleBuffer(IBuffer buffer) {
        this.buffers.add(buffer);
    }

    public int read() throws IOException {
        if (this.currentBuffer == null) {
            if (this.eos) {
                return -1;
            }
            if (!this.ensureBuffer()) {
                return -1;
            }
        }
        int result = this.currentBuffer.getByteBuffer().get() & 0xFF;
        if (TRACER.isEnabled()) {
            TRACER.trace("<-- " + HexUtil.formatByte((int)result) + (result >= 32 ? " " + Character.toString((char)result) : ""));
        }
        if (!this.currentBuffer.getByteBuffer().hasRemaining()) {
            this.currentBuffer.release();
            this.currentBuffer = null;
        }
        return result;
    }

    public void close() throws IOException {
        this.buffers = null;
        this.currentBuffer = null;
        super.close();
    }

    public String toString() {
        return "BufferInputStream";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected boolean ensureBuffer() throws IOException {
        long check = this.getMillisInterruptCheck();
        long timeout = this.getMillisBeforeTimeout();
        try {
            if (timeout == -1L) {
                while (this.currentBuffer == null) {
                    if (this.buffers == null) {
                        return false;
                    }
                    this.currentBuffer = this.buffers.poll(check, TimeUnit.MILLISECONDS);
                }
            } else {
                long stop = System.currentTimeMillis() + timeout;
                while (this.currentBuffer == null) {
                    if (this.buffers == null) {
                        return false;
                    }
                    long remaining = stop - System.currentTimeMillis();
                    if (remaining <= 0L) {
                        return false;
                    }
                    this.currentBuffer = this.buffers.poll(Math.min(remaining, check), TimeUnit.MILLISECONDS);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted");
        }
        this.eos = this.currentBuffer.isEOS();
        return true;
    }

    public long getMillisBeforeTimeout() {
        return -1L;
    }

    public long getMillisInterruptCheck() {
        return 100L;
    }
}

