/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOClassRef;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageManager;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.revision.CDOReferenceProxy;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.common.revision.CDORevisionResolver;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDeltaUtil;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.revision.CDOReferenceProxyImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORevisionMerger;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.InternalCDORevisionDelta;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.collection.MoveableArrayList;
import org.eclipse.net4j.util.collection.MoveableList;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.om.trace.PerfTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDORevisionImpl
implements InternalCDORevision {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_REVISION, CDORevisionImpl.class);
    private static final PerfTracer READING = new PerfTracer(OM.PERF_REVISION_READING, CDORevisionImpl.class);
    private static final PerfTracer WRITING = new PerfTracer(OM.PERF_REVISION_WRITING, CDORevisionImpl.class);
    private CDORevisionResolver revisionResolver;
    private CDOClass cdoClass;
    private CDOID id;
    private int version;
    private long created;
    private long revised;
    private CDOID resourceID;
    private CDOID containerID;
    private int containingFeatureID;
    private Object[] values;

    public CDORevisionImpl(CDORevisionResolver revisionResolver, CDOClass cdoClass, CDOID id) {
        this.revisionResolver = revisionResolver;
        this.cdoClass = cdoClass;
        this.id = id;
        this.version = 0;
        this.created = 0L;
        this.revised = 0L;
        this.resourceID = CDOID.NULL;
        this.containerID = CDOID.NULL;
        this.containingFeatureID = 0;
        this.values = new Object[cdoClass.getAllFeatures().length];
    }

    public CDORevisionImpl(CDORevisionImpl source) {
        this.revisionResolver = source.revisionResolver;
        this.cdoClass = source.cdoClass;
        this.id = source.id;
        this.version = source.version;
        this.created = source.created;
        this.revised = source.revised;
        this.resourceID = source.resourceID;
        this.containerID = source.containerID;
        this.containingFeatureID = source.containingFeatureID;
        this.copyValues(source.values);
    }

    public CDORevisionImpl(ExtendedDataInput in, CDORevisionResolver revisionResolver, CDOPackageManager packageManager) throws IOException {
        this.revisionResolver = revisionResolver;
        READING.start((Object)this);
        CDOClassRef classRef = CDOModelUtil.readClassRef(in);
        this.cdoClass = classRef.resolve(packageManager);
        if (this.cdoClass == null) {
            throw new IllegalStateException("ClassRef unresolveable: " + classRef);
        }
        this.id = CDOIDUtil.read(in, revisionResolver.getCDOIDObjectFactory());
        this.version = in.readInt();
        this.created = in.readLong();
        this.revised = in.readLong();
        this.resourceID = CDOIDUtil.read(in, revisionResolver.getCDOIDObjectFactory());
        this.containerID = CDOIDUtil.read(in, revisionResolver.getCDOIDObjectFactory());
        this.containingFeatureID = in.readInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Reading revision: ID={0}, classRef={1}, className={2}, version={3}, created={4}, revised={5}, resource={6}, container={7}, feature={8}", new Object[]{this.id, classRef, this.cdoClass.getName(), this.version, this.created, this.revised, this.resourceID, this.containerID, this.containingFeatureID});
        }
        this.readValues(in);
        READING.stop((Object)this);
    }

    @Override
    public void write(ExtendedDataOutput out, CDOIDProvider idProvider, int referenceChunk) throws IOException {
        CDOClassRef classRef = this.cdoClass.createClassRef();
        if (TRACER.isEnabled()) {
            TRACER.format("Writing revision: ID={0}, classRef={1}, className={2}, version={3}, created={4}, revised={5}, resource={6}, container={7}, feature={8}", new Object[]{this.id, classRef, this.cdoClass.getName(), this.getVersion(), this.created, this.revised, this.resourceID, this.containerID, this.containingFeatureID});
        }
        WRITING.start((Object)this);
        CDOModelUtil.writeClassRef(out, classRef);
        CDOIDUtil.write(out, this.id);
        out.writeInt(this.getVersion());
        out.writeLong(this.created);
        out.writeLong(this.revised);
        CDOIDUtil.write(out, this.resourceID);
        CDOIDUtil.write(out, this.containerID);
        out.writeInt(this.containingFeatureID);
        this.writeValues(out, idProvider, referenceChunk);
        WRITING.stop((Object)this);
    }

    @Override
    public CDORevisionResolver getRevisionResolver() {
        return this.revisionResolver;
    }

    @Override
    public CDOClass getCDOClass() {
        return this.cdoClass;
    }

    @Override
    public CDOID getID() {
        return this.id;
    }

    @Override
    public void setID(CDOID id) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting ID: {0}", new Object[]{id});
        }
        this.id = id;
    }

    @Override
    public int getVersion() {
        return this.version < 0 ? -this.version : this.version;
    }

    @Override
    public void setVersion(int version) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting version for {0}: v{1}", new Object[]{this, version});
        }
        this.version = version;
    }

    @Override
    public boolean isTransactional() {
        return this.version < 0;
    }

    @Override
    public int setTransactional() {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting transactional {0}: v{1}", new Object[]{this, -(this.version + 1)});
        }
        this.version = -(this.version + 1);
        return this.version;
    }

    @Override
    public void setUntransactional() {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting untransactional {0}: v{1}", new Object[]{this, Math.abs(this.version)});
        }
        this.version = Math.abs(this.version);
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    @Override
    public void setCreated(long created) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting created {0}: {1,date} {1,time}", new Object[]{this, created});
        }
        this.created = created;
    }

    @Override
    public long getRevised() {
        return this.revised;
    }

    @Override
    public void setRevised(long revised) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting revised {0}: {1,date} {1,time}", new Object[]{this, revised});
        }
        this.revised = revised;
    }

    @Override
    public boolean isCurrent() {
        return this.revised == 0L;
    }

    @Override
    public boolean isValid(long timeStamp) {
        return (this.revised == 0L || this.revised >= timeStamp) && timeStamp >= this.created;
    }

    @Override
    public boolean isResource() {
        return this.cdoClass.isResource();
    }

    @Override
    public CDORevisionData getData() {
        return this;
    }

    @Override
    public CDORevision getRevision() {
        return this;
    }

    @Override
    public InternalCDORevisionDelta compare(CDORevision origin) {
        return (InternalCDORevisionDelta)CDORevisionDeltaUtil.create(origin, this);
    }

    @Override
    public void merge(CDORevisionDelta delta) {
        CDORevisionMerger applier = new CDORevisionMerger();
        applier.merge(this, delta);
    }

    @Override
    public CDOID getResourceID() {
        return this.resourceID;
    }

    @Override
    public void setResourceID(CDOID resourceID) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting resourceID {0}: {1}", new Object[]{this, resourceID});
        }
        this.resourceID = resourceID;
    }

    @Override
    public CDOID getContainerID() {
        return this.containerID;
    }

    @Override
    public void setContainerID(CDOID containerID) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting containerID {0}: {1}", new Object[]{this, containerID});
        }
        this.containerID = containerID;
    }

    @Override
    public int getContainingFeatureID() {
        return this.containingFeatureID;
    }

    @Override
    public void setContainingFeatureID(int containingFeatureID) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting containingFeatureID {0}: {1}", new Object[]{this, containingFeatureID});
        }
        this.containingFeatureID = containingFeatureID;
    }

    @Override
    public int hashCode(CDOFeature feature) {
        return this.getValue(feature).hashCode();
    }

    @Override
    public Object get(CDOFeature feature, int index) {
        if (feature.isMany()) {
            return this.getList(feature).get(index);
        }
        return this.getValue(feature);
    }

    @Override
    public boolean contains(CDOFeature feature, Object value) {
        return this.getList(feature).contains(value);
    }

    @Override
    public int indexOf(CDOFeature feature, Object value) {
        return this.getList(feature).indexOf(value);
    }

    @Override
    public boolean isEmpty(CDOFeature feature) {
        return this.getList(feature).isEmpty();
    }

    @Override
    public boolean isSet(CDOFeature feature) {
        return this.getValue(feature) != null;
    }

    @Override
    public int lastIndexOf(CDOFeature feature, Object value) {
        return this.getList(feature).lastIndexOf(value);
    }

    @Override
    public int size(CDOFeature feature) {
        return this.getList(feature).size();
    }

    @Override
    public Object[] toArray(CDOFeature feature) {
        if (!feature.isMany()) {
            throw new IllegalStateException("!feature.isMany()");
        }
        return this.getList(feature).toArray();
    }

    @Override
    public <T> T[] toArray(CDOFeature feature, T[] array) {
        if (!feature.isMany()) {
            throw new IllegalStateException("!feature.isMany()");
        }
        return this.getList(feature).toArray((Object[])array);
    }

    @Override
    public void add(CDOFeature feature, int index, Object value) {
        this.getList(feature).add(index, value);
    }

    @Override
    public void clear(CDOFeature feature) {
        this.setValue(feature, null);
    }

    @Override
    public Object move(CDOFeature feature, int targetIndex, int sourceIndex) {
        return this.getList(feature).move(targetIndex, sourceIndex);
    }

    @Override
    public Object remove(CDOFeature feature, int index) {
        return this.getList(feature).remove(index);
    }

    @Override
    public Object set(CDOFeature feature, int index, Object value) {
        if (feature.isMany()) {
            return this.getList(feature).set(index, value);
        }
        return this.setValue(feature, value);
    }

    @Override
    public void unset(CDOFeature feature) {
        this.setValue(feature, null);
    }

    @Override
    public void adjustReferences(Map<CDOIDTemp, CDOID> idMappings) {
        if (TRACER.isEnabled()) {
            TRACER.format("Adjusting references for revision {0}", new Object[]{this});
        }
        this.resourceID = (CDOID)CDORevisionImpl.remapID(this.resourceID, idMappings);
        this.containerID = (CDOID)CDORevisionImpl.remapID(this.containerID, idMappings);
        CDOFeature[] features = this.cdoClass.getAllFeatures();
        int i = 0;
        while (i < features.length) {
            CDOFeature feature = features[i];
            if (feature.isReference()) {
                if (feature.isMany()) {
                    List<Object> list = this.getValueAsList(i);
                    int size = list == null ? 0 : list.size();
                    int j = 0;
                    while (j < size) {
                        Object oldID = list.get(j);
                        Object newID = CDORevisionImpl.remapID(oldID, idMappings);
                        if (newID != oldID) {
                            list.set(j, newID);
                        }
                        ++j;
                    }
                } else {
                    this.values[i] = CDORevisionImpl.remapID(this.values[i], idMappings);
                }
            }
            ++i;
        }
    }

    private List<Object> getValueAsList(int i) {
        return (List)this.values[i];
    }

    public String toString() {
        return String.valueOf(this.cdoClass.getName()) + "@" + this.id + "v" + this.version;
    }

    @Override
    public Object getValue(CDOFeature feature) {
        int i = this.cdoClass.getFeatureID(feature);
        return this.values[i];
    }

    @Override
    public Object setValue(CDOFeature feature, Object value) {
        int i = this.cdoClass.getFeatureID(feature);
        Object old = this.values[i];
        this.values[i] = value;
        return old;
    }

    @Override
    public MoveableList<Object> getList(CDOFeature feature) {
        return this.getList(feature, 0);
    }

    @Override
    public MoveableList<Object> getList(CDOFeature feature, int size) {
        int i = this.cdoClass.getFeatureID(feature);
        MoveableList list = (MoveableList)this.values[i];
        if (list == null) {
            list = new MoveableArrayList(size);
            this.values[i] = list;
        }
        return list;
    }

    @Override
    public void setListSize(CDOFeature feature, int size) {
        MoveableList<Object> list = this.getList(feature, size);
        int j = list.size();
        while (j < size) {
            list.add(InternalCDORevision.UNINITIALIZED);
            ++j;
        }
    }

    private void copyValues(Object[] sourceValues) {
        CDOFeature[] features = this.cdoClass.getAllFeatures();
        this.values = new Object[features.length];
        int i = 0;
        while (i < features.length) {
            CDOFeature feature = features[i];
            CDOType type = feature.getType();
            if (feature.isMany()) {
                MoveableList sourceList = (MoveableList)sourceValues[i];
                if (sourceList != null) {
                    int size = sourceList.size();
                    MoveableArrayList list = new MoveableArrayList(size);
                    int j = 0;
                    while (j < size) {
                        Object value = sourceList.get(j);
                        if (value instanceof CDOReferenceProxy) {
                            list.add((Object)new CDOReferenceProxyImpl(this, feature, ((CDOReferenceProxy)value).getIndex()));
                        } else {
                            list.add(type.copyValue(value));
                        }
                        ++j;
                    }
                    this.values[i] = list;
                }
            } else {
                this.values[i] = type.copyValue(sourceValues[i]);
            }
            ++i;
        }
    }

    private void readValues(ExtendedDataInput in) throws IOException {
        CDOFeature[] features = this.cdoClass.getAllFeatures();
        this.values = new Object[features.length];
        int i = 0;
        while (i < features.length) {
            CDOFeature feature = features[i];
            CDOType type = feature.getType();
            if (feature.isMany()) {
                int referenceChunk;
                int size = in.readInt();
                if (size < 0) {
                    size = -size;
                    referenceChunk = in.readInt();
                    if (TRACER.isEnabled()) {
                        TRACER.format("Read feature {0}: size={1}, referenceChunk={2}", new Object[]{feature, size, referenceChunk});
                    }
                } else {
                    referenceChunk = size;
                    if (TRACER.isEnabled()) {
                        TRACER.format("Read feature {0}: size={1}", new Object[]{feature, size});
                    }
                }
                if (size != 0) {
                    Object value;
                    CDORevisionImpl baseRevision = null;
                    MoveableArrayList list = new MoveableArrayList(size);
                    this.values[i] = list;
                    int ranges = in.readInt();
                    if (ranges != 0) {
                        while (ranges-- > 0) {
                            int range = in.readInt();
                            if (range > 0) {
                                while (range-- > 0) {
                                    value = type.readValue(in, this.revisionResolver.getCDOIDObjectFactory());
                                    list.add(value);
                                    if (!TRACER.isEnabled()) continue;
                                    TRACER.trace("    " + value);
                                }
                                continue;
                            }
                            if (baseRevision == null) {
                                baseRevision = (CDORevisionImpl)this.revisionResolver.getRevisionByVersion(this.id, -1, this.getVersion() - 1);
                            }
                            MoveableList<Object> baseList = baseRevision.getList(feature);
                            int index = in.readInt();
                            while (range++ < 0) {
                                Object value2 = baseList.get(index++);
                                list.add(value2);
                                if (!TRACER.isEnabled()) continue;
                                TRACER.trace("    " + value2);
                            }
                        }
                    } else {
                        int j = 0;
                        while (j < referenceChunk) {
                            value = type.readValue(in, this.revisionResolver.getCDOIDObjectFactory());
                            list.add(value);
                            if (TRACER.isEnabled()) {
                                TRACER.trace("    " + value);
                            }
                            ++j;
                        }
                        j = referenceChunk;
                        while (j < size) {
                            list.add((Object)new CDOReferenceProxyImpl(this, feature, j));
                            ++j;
                        }
                    }
                }
            } else {
                this.values[i] = type.readValue(in, this.revisionResolver.getCDOIDObjectFactory());
                if (TRACER.isEnabled()) {
                    TRACER.format("Read feature {0}: {1}", new Object[]{feature, this.values[i]});
                }
            }
            ++i;
        }
    }

    private void writeValues(ExtendedDataOutput out, CDOIDProvider idProvider, int referenceChunk) throws IOException {
        CDOFeature[] features = this.cdoClass.getAllFeatures();
        int i = 0;
        while (i < features.length) {
            CDOFeature feature = features[i];
            if (feature.isMany()) {
                int size;
                List<Object> list = this.getValueAsList(i);
                int n = size = list == null ? 0 : list.size();
                if (referenceChunk != -1 && referenceChunk < size) {
                    if (TRACER.isEnabled()) {
                        TRACER.format("Writing feature {0}: size={1}, referenceChunk={2}", new Object[]{feature, size, referenceChunk});
                    }
                    out.writeInt(-size);
                    out.writeInt(referenceChunk);
                    size = referenceChunk;
                } else {
                    if (TRACER.isEnabled()) {
                        TRACER.format("Writing feature {0}: size={1}", new Object[]{feature, size});
                    }
                    out.writeInt(size);
                }
                if (size != 0) {
                    int j;
                    List<Integer> ranges = this.revisionResolver.analyzeReferenceRanges(list);
                    if (ranges != null) {
                        out.writeInt(ranges.size());
                        j = 0;
                        for (int range : ranges) {
                            out.writeInt(range);
                            if (range > 0) {
                                while (range-- > 0) {
                                    Object value = list.get(j);
                                    if (value != null && feature.isReference()) {
                                        value = idProvider.provideCDOID(value);
                                        list.set(j, value);
                                    }
                                    if (TRACER.isEnabled()) {
                                        TRACER.trace("    " + value);
                                    }
                                    feature.getType().writeValue(out, value);
                                    ++j;
                                }
                                continue;
                            }
                            CDOReferenceProxy proxy = (CDOReferenceProxy)list.get(j);
                            out.writeInt(proxy.getIndex());
                            j -= range;
                        }
                    } else {
                        out.writeInt(0);
                        j = 0;
                        while (j < size) {
                            Object value = list.get(j);
                            if (value != null && feature.isReference()) {
                                value = idProvider.provideCDOID(value);
                                list.set(j, value);
                            }
                            if (TRACER.isEnabled()) {
                                TRACER.trace("    " + value);
                            }
                            feature.getType().writeValue(out, value);
                            ++j;
                        }
                    }
                }
            } else {
                if (this.values[i] != null && feature.isReference()) {
                    this.values[i] = idProvider.provideCDOID(this.values[i]);
                }
                if (TRACER.isEnabled()) {
                    TRACER.format("Writing feature {0}: {1}", new Object[]{feature, this.values[i]});
                }
                feature.getType().writeValue(out, this.values[i]);
            }
            ++i;
        }
    }

    public static Object remapID(Object value, Map<CDOIDTemp, CDOID> idMappings) {
        CDOIDTemp oldID;
        if (value instanceof CDOIDTemp && !(oldID = (CDOIDTemp)value).isNull()) {
            CDOID newID = idMappings.get(oldID);
            if (newID == null) {
                throw new ImplementationError("Missing ID mapping for " + oldID);
            }
            if (TRACER.isEnabled()) {
                TRACER.format("Adjusting ID: {0} --> {1}", new Object[]{oldID, newID});
            }
            return newID;
        }
        return value;
    }
}

