/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOTransaction;
import org.eclipse.emf.cdo.CDOTransactionConflictEvent;
import org.eclipse.emf.cdo.CDOTransactionFinishedEvent;
import org.eclipse.emf.cdo.CDOTransactionHandler;
import org.eclipse.emf.cdo.CDOTransactionStartedEvent;
import org.eclipse.emf.cdo.common.CDOProtocolView;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDeltaUtil;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceImpl;
import org.eclipse.emf.cdo.spi.common.InternalCDOPackage;
import org.eclipse.emf.cdo.spi.common.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.internal.cdo.CDOSessionImpl;
import org.eclipse.emf.internal.cdo.CDOSessionPackageManagerImpl;
import org.eclipse.emf.internal.cdo.CDOStateMachine;
import org.eclipse.emf.internal.cdo.CDOViewImpl;
import org.eclipse.emf.internal.cdo.InternalCDOObject;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.protocol.CommitTransactionRequest;
import org.eclipse.emf.internal.cdo.protocol.CommitTransactionResult;
import org.eclipse.emf.internal.cdo.util.CompletePackageClosure;
import org.eclipse.emf.internal.cdo.util.ModelUtil;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.signal.RequestWithConfirmation;
import org.eclipse.net4j.signal.failover.IFailOverStrategy;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.transaction.TransactionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOTransactionImpl
extends CDOViewImpl
implements CDOTransaction {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_TRANSCTION, CDOTransactionImpl.class);
    private List<CDOTransactionHandler> handlers = new ArrayList<CDOTransactionHandler>(0);
    private List<CDOPackage> newPackages;
    private Map<CDOID, CDOResource> newResources = new HashMap<CDOID, CDOResource>();
    private Map<CDOID, CDOObject> newObjects = new HashMap<CDOID, CDOObject>();
    private Map<CDOID, CDOObject> dirtyObjects = new HashMap<CDOID, CDOObject>();
    private ConcurrentMap<CDOID, CDORevisionDelta> revisionDeltas = new ConcurrentHashMap<CDOID, CDORevisionDelta>();
    private boolean dirty;
    private boolean conflict;
    private long commitTimeout = (Long)OM.PREF_DEFAULT_COMMIT_TIMEOUT.getValue();
    private int lastTemporaryID;

    public CDOTransactionImpl(int id, CDOSessionImpl session) {
        super(id, session);
    }

    @Override
    public CDOProtocolView.Type getViewType() {
        return CDOProtocolView.Type.TRANSACTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHandler(CDOTransactionHandler handler) {
        List<CDOTransactionHandler> list = this.handlers;
        synchronized (list) {
            this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHandler(CDOTransactionHandler handler) {
        List<CDOTransactionHandler> list = this.handlers;
        synchronized (list) {
            this.handlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOTransactionHandler[] getHandlers() {
        List<CDOTransactionHandler> list = this.handlers;
        synchronized (list) {
            return this.handlers.toArray(new CDOTransactionHandler[this.handlers.size()]);
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public boolean hasConflict() {
        return this.conflict;
    }

    public void setConflict(InternalCDOObject object) {
        ConflictEvent event = new ConflictEvent(object, !this.conflict);
        this.conflict = true;
        this.fireEvent(event);
    }

    @Override
    public long getCommitTimeout() {
        return this.commitTimeout;
    }

    @Override
    public void setCommitTimeout(long timeout) {
        this.commitTimeout = timeout;
    }

    @Override
    public List<CDOPackage> getNewPackages() {
        return Collections.unmodifiableList(this.newPackages);
    }

    @Override
    public Map<CDOID, CDOResource> getNewResources() {
        return Collections.unmodifiableMap(this.newResources);
    }

    @Override
    public Map<CDOID, CDOObject> getNewObjects() {
        return Collections.unmodifiableMap(this.newObjects);
    }

    @Override
    public Map<CDOID, CDOObject> getDirtyObjects() {
        return Collections.unmodifiableMap(this.dirtyObjects);
    }

    @Override
    public Map<CDOID, CDORevisionDelta> getRevisionDeltas() {
        return Collections.unmodifiableMap(this.revisionDeltas);
    }

    public CDOIDTemp getNextTemporaryID() {
        return CDOIDUtil.createTempObject((int)(++this.lastTemporaryID));
    }

    @Override
    public CDOResource createResource(String path) {
        URI createURI = CDOUtil.createResourceURI(path);
        return (CDOResource)this.getResourceSet().createResource(createURI);
    }

    @Override
    public CDOResource getOrCreateResource(String path) {
        CDOID id = this.getResourceID(path);
        if (id == null || id.isNull()) {
            return this.createResource(path);
        }
        return this.addResource(id, path);
    }

    @Override
    public void commit() throws TransactionException {
        if (this.dirty) {
            if (TRACER.isEnabled()) {
                TRACER.trace("commit()");
            }
            if (this.hasConflict()) {
                throw new TransactionException("This transaction has conflicts");
            }
            CDOTransactionHandler[] cDOTransactionHandlerArray = this.getHandlers();
            int n = cDOTransactionHandlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOTransactionHandler handler = cDOTransactionHandlerArray[n2];
                handler.committingTransaction(this);
                ++n2;
            }
            try {
                this.newPackages = this.analyzeNewPackages();
                this.preCommit(this.newObjects);
                this.preCommit(this.dirtyObjects);
                CDOSessionImpl session = this.getSession();
                IChannel channel = session.getChannel();
                IFailOverStrategy failOverStrategy = session.getFailOverStrategy();
                CommitTransactionRequest request = new CommitTransactionRequest(channel, this);
                CommitTransactionResult result = (CommitTransactionResult)failOverStrategy.send((RequestWithConfirmation)request, this.commitTimeout);
                String rollbackMessage = result.getRollbackMessage();
                if (rollbackMessage != null) {
                    throw new TransactionException(rollbackMessage);
                }
                this.postCommit(this.newResources, result);
                this.postCommit(this.newObjects, result);
                this.postCommit(this.dirtyObjects, result);
                for (CDOPackage newPackage : this.newPackages) {
                    ((InternalCDOPackage)newPackage).setPersistent(true);
                }
                if (!this.dirtyObjects.isEmpty()) {
                    HashSet<CDOIDAndVersion> dirtyIDs = new HashSet<CDOIDAndVersion>();
                    for (CDOObject dirtyObject : this.dirtyObjects.values()) {
                        CDORevision revision = dirtyObject.cdoRevision();
                        CDOIDAndVersion dirtyID = CDOIDUtil.createIDAndVersion((CDOID)revision.getID(), (int)revision.getVersion());
                        dirtyIDs.add(dirtyID);
                    }
                    session.notifyInvalidation(result.getTimeStamp(), dirtyIDs, this);
                }
                this.cleanUp();
                Map<CDOIDTemp, CDOID> idMappings = result.getIDMappings();
                this.fireEvent(new FinishedEvent(CDOTransactionFinishedEvent.Type.COMMITTED, idMappings));
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new TransactionException((Throwable)ex);
            }
        }
    }

    @Override
    public void rollback(boolean remote) {
        try {
            if (!this.newResources.isEmpty()) {
                for (CDOObject cDOObject : this.newResources.values()) {
                    this.removeObject(cDOObject.cdoID());
                    this.getResourceSet().getResources().remove((Object)cDOObject);
                }
            }
            if (!this.newObjects.isEmpty()) {
                for (CDOObject cDOObject : this.newObjects.values()) {
                    this.removeObject(cDOObject.cdoID());
                }
            }
            if (!this.dirtyObjects.isEmpty()) {
                for (CDOObject cDOObject : this.dirtyObjects.values()) {
                    CDOStateMachine.INSTANCE.rollback((InternalCDOObject)cDOObject, remote);
                }
            }
            this.cleanUp();
            Map map = Collections.emptyMap();
            this.fireEvent(new FinishedEvent(CDOTransactionFinishedEvent.Type.ROLLED_BACK, map));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new TransactionException((Throwable)exception);
        }
    }

    @Override
    public String toString() {
        return MessageFormat.format("CDOTransaction({0})", this.getViewID());
    }

    public void registerNew(InternalCDOObject object) {
        if (TRACER.isEnabled()) {
            TRACER.format("Registering new object {0}", new Object[]{object});
        }
        CDOTransactionHandler[] cDOTransactionHandlerArray = this.getHandlers();
        int n = cDOTransactionHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOTransactionHandler handler = cDOTransactionHandlerArray[n2];
            handler.addingObject(this, object);
            ++n2;
        }
        if (object instanceof CDOResourceImpl) {
            this.register(this.newResources, object);
        } else {
            this.register(this.newObjects, object);
        }
    }

    public void registerFeatureDelta(InternalCDOObject object, CDOFeatureDelta featureDelta) {
        InternalCDORevisionDelta revisionDelta = (InternalCDORevisionDelta)this.revisionDeltas.get(object.cdoID());
        if (revisionDelta == null) {
            revisionDelta = (InternalCDORevisionDelta)CDORevisionDeltaUtil.create((CDORevision)object.cdoRevision());
            this.revisionDeltas.put(object.cdoID(), (CDORevisionDelta)revisionDelta);
        }
        revisionDelta.addFeatureDelta(featureDelta);
        CDOTransactionHandler[] cDOTransactionHandlerArray = this.getHandlers();
        int n = cDOTransactionHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOTransactionHandler handler = cDOTransactionHandlerArray[n2];
            handler.modifyingObject(this, object, featureDelta);
            ++n2;
        }
    }

    public void registerRevisionDelta(CDORevisionDelta revisionDelta) {
        this.revisionDeltas.putIfAbsent(revisionDelta.getID(), revisionDelta);
    }

    public void registerDirty(InternalCDOObject object, CDOFeatureDelta featureDelta) {
        if (TRACER.isEnabled()) {
            TRACER.format("Registering dirty object {0}", new Object[]{object});
        }
        this.registerFeatureDelta(object, featureDelta);
        this.register(this.dirtyObjects, object);
    }

    private void register(Map map, InternalCDOObject object) {
        InternalCDOObject old = map.put(object.cdoID(), object);
        if (old != null) {
            throw new ImplementationError("Duplicate ID: " + object);
        }
        if (!this.dirty) {
            this.dirty = true;
            this.fireEvent(new StartedEvent());
        }
    }

    private List<CDOPackage> analyzeNewPackages() {
        HashSet<EClass> usedClasses = new HashSet<EClass>();
        for (CDOObject object : this.newObjects.values()) {
            CDOTransactionImpl.findAllUsedEClasses(object.eClass(), usedClasses);
        }
        return CDOTransactionImpl.analyzeNewPackages(usedClasses, this.getSession().getPackageManager());
    }

    private static void findAllUsedEClasses(EClass eClass, Set<EClass> foundClasses) {
        if (foundClasses.add(eClass)) {
            for (EClass superType : eClass.getEAllSuperTypes()) {
                CDOTransactionImpl.findAllUsedEClasses(superType, foundClasses);
            }
            for (EReference eReference : eClass.getEAllReferences()) {
                CDOTransactionImpl.findAllUsedEClasses(eReference.getEReferenceType(), foundClasses);
            }
        }
    }

    private static List<CDOPackage> analyzeNewPackages(Collection<EClass> eClasses, CDOSessionPackageManagerImpl packageManager) {
        Set<EPackage> usedPackages = new HashSet<EPackage>();
        for (EClass eClass : eClasses) {
            EPackage topLevelPackage = ModelUtil.getTopLevelPackage(eClass.getEPackage());
            usedPackages.add(topLevelPackage);
        }
        CompletePackageClosure closure = new CompletePackageClosure();
        usedPackages = closure.calculate(usedPackages);
        ArrayList<CDOPackage> newPackages = new ArrayList<CDOPackage>();
        for (EPackage usedPackage : usedPackages) {
            CDOPackage cdoPackage = ModelUtil.getCDOPackage(usedPackage, packageManager);
            if (cdoPackage == null) {
                throw new IllegalStateException("Missing CDO package: " + usedPackage.getNsURI());
            }
            if (cdoPackage.isPersistent() || cdoPackage.isSystem()) continue;
            newPackages.add(cdoPackage);
        }
        return newPackages;
    }

    private void preCommit(Map objects) {
        if (!objects.isEmpty()) {
            for (Object object : objects.values()) {
                ((InternalCDOObject)object).cdoInternalPreCommit();
            }
        }
    }

    private void postCommit(Map objects, CommitTransactionResult result) {
        if (!objects.isEmpty()) {
            for (Object object : objects.values()) {
                CDOStateMachine.INSTANCE.commit((InternalCDOObject)object, result);
            }
        }
    }

    private void cleanUp() {
        this.newPackages = null;
        this.newResources.clear();
        this.newObjects.clear();
        this.dirtyObjects.clear();
        this.revisionDeltas.clear();
        this.dirty = false;
        this.conflict = false;
        this.lastTemporaryID = 0;
    }

    private final class ConflictEvent
    extends CDOViewImpl.Event
    implements CDOTransactionConflictEvent {
        private static final long serialVersionUID = 1L;
        private InternalCDOObject conflictingObject;
        private boolean firstConflict;

        public ConflictEvent(InternalCDOObject conflictingObject, boolean firstConflict) {
            super(CDOTransactionImpl.this);
            this.conflictingObject = conflictingObject;
            this.firstConflict = firstConflict;
        }

        public InternalCDOObject getConflictingObject() {
            return this.conflictingObject;
        }

        public boolean isFirstConflict() {
            return this.firstConflict;
        }

        public String toString() {
            return MessageFormat.format("CDOTransactionConflictEvent[source={0}, conflictingObject={1}, firstConflict={2}]", this.getSource(), this.getConflictingObject(), this.isFirstConflict());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FinishedEvent
    extends CDOViewImpl.Event
    implements CDOTransactionFinishedEvent {
        private static final long serialVersionUID = 1L;
        private CDOTransactionFinishedEvent.Type type;
        private Map<CDOIDTemp, CDOID> idMappings;

        private FinishedEvent(CDOTransactionFinishedEvent.Type type, Map<CDOIDTemp, CDOID> idMappings) {
            super(CDOTransactionImpl.this);
            this.type = type;
            this.idMappings = idMappings;
        }

        @Override
        public CDOTransactionFinishedEvent.Type getType() {
            return this.type;
        }

        @Override
        public Map<CDOIDTemp, CDOID> getIDMappings() {
            return this.idMappings;
        }

        public String toString() {
            return MessageFormat.format("CDOTransactionFinishedEvent[source={0}, type={1}, idMappings={2}]", new Object[]{this.getSource(), this.getType(), this.idMappings == null ? 0 : this.idMappings.size()});
        }
    }

    private final class StartedEvent
    extends CDOViewImpl.Event
    implements CDOTransactionStartedEvent {
        private static final long serialVersionUID = 1L;

        private StartedEvent() {
            super(CDOTransactionImpl.this);
        }

        public String toString() {
            return MessageFormat.format("CDOTransactionStartedEvent[source={0}]", this.getSource());
        }
    }
}

