/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.net4j.util.ui.actions.SafeAction;
import org.eclipse.net4j.util.ui.widgets.SashComposite;

public abstract class SashLayoutAction
extends SafeAction {
    private SashComposite sashComposite;

    public SashLayoutAction(SashComposite sashComposite, String text) {
        super(text, 8);
        this.sashComposite = sashComposite;
    }

    public SashComposite getSashComposite() {
        return this.sashComposite;
    }

    public static class Horizontal
    extends SashLayoutAction {
        public Horizontal(SashComposite sashComposite) {
            super(sashComposite, "Horizontal");
        }

        protected void safeRun() throws Exception {
            this.getSashComposite().setVertical(false);
        }
    }

    public static class LayoutMenu
    extends MenuManager {
        private SafeAction verticalAction;
        private SafeAction horizontalAction;

        public LayoutMenu(SashComposite sashComposite) {
            this(sashComposite, true);
        }

        public LayoutMenu(SashComposite sashComposite, boolean defaultVertical) {
            super("Layout");
            this.verticalAction = new Vertical(sashComposite);
            this.verticalAction.setChecked(defaultVertical);
            this.add((IAction)this.verticalAction);
            this.horizontalAction = new Horizontal(sashComposite);
            this.horizontalAction.setChecked(!defaultVertical);
            this.add((IAction)this.horizontalAction);
        }

        public SafeAction getVerticalAction() {
            return this.verticalAction;
        }

        public SafeAction getHorizontalAction() {
            return this.horizontalAction;
        }
    }

    public static class Vertical
    extends SashLayoutAction {
        public Vertical(SashComposite sashComposite) {
            super(sashComposite, "Vertical");
        }

        protected void safeRun() throws Exception {
            this.getSashComposite().setVertical(true);
        }
    }
}

