/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.widgets;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.net4j.util.om.monitor.OMMonitorHandler;
import org.eclipse.net4j.util.ui.widgets.LogDialog;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MonitorLogDialog
extends LogDialog
implements OMMonitorHandler {
    private String[] emphasizePrefix;
    private TextStyle taskStyle;
    private TextStyle normalStyle;
    private TextStyle emphasizedStyle;
    private TextStyle problemStyle;

    public MonitorLogDialog(Shell parentShell, int shellStyle, String title, String message, IDialogSettings settings) {
        super(parentShell, shellStyle, title, message, settings);
        Display display = Display.getCurrent();
        this.taskStyle = new TextStyle(null, display.getSystemColor(2), null);
        this.normalStyle = new TextStyle(null, display.getSystemColor(16), null);
        this.emphasizedStyle = new TextStyle(null, display.getSystemColor(9), null);
        this.problemStyle = new TextStyle(null, display.getSystemColor(3), null);
    }

    public MonitorLogDialog(Shell parentShell, String title, String message, IDialogSettings settings) {
        this(parentShell, 1264, title, message, settings);
    }

    public String[] getEmphasizePrefix() {
        return this.emphasizePrefix;
    }

    public void setEmphasizePrefix(String ... emphasizePrefix) {
        this.emphasizePrefix = emphasizePrefix;
    }

    public TextStyle getNormalStyle() {
        return this.normalStyle;
    }

    public TextStyle getTaskStyle() {
        return this.taskStyle;
    }

    public TextStyle getProblemStyle() {
        return this.problemStyle;
    }

    public TextStyle getEmphasizedStyle() {
        return this.emphasizedStyle;
    }

    public void handleTask(String task, int level) {
        this.setTextStyle(this.taskStyle);
        this.append(task);
        this.append("\n");
    }

    public void handleMessage(String msg, int level) {
        boolean emphasized = false;
        if (this.emphasizePrefix != null) {
            String[] stringArray = this.emphasizePrefix;
            int n = this.emphasizePrefix.length;
            int n2 = 0;
            while (n2 < n) {
                String prefix = stringArray[n2];
                if (msg.startsWith(prefix)) {
                    this.setTextStyle(this.emphasizedStyle);
                    emphasized = true;
                    break;
                }
                ++n2;
            }
        }
        if (!emphasized) {
            this.setTextStyle(this.normalStyle);
        }
        this.append(msg);
        this.append("\n");
    }

    public void append(Throwable t) {
        this.setTextStyle(this.problemStyle);
        super.append(t);
    }
}

