/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.service.tests;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import ordersystem.Address;
import ordersystem.LineItem;
import ordersystem.Order;
import ordersystem.OrderSystemFactory;
import ordersystem.OrderSystemPackage;
import ordersystem.impl.OrderImpl;
import ordersystem.special.PreferredCustomer;
import ordersystem.special.SpecialFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.internal.EMFModelValidationStatusCodes;
import org.eclipse.emf.validation.internal.service.AbstractValidationContext;
import org.eclipse.emf.validation.internal.service.GetBatchConstraintsOperation;
import org.eclipse.emf.validation.internal.service.IProviderOperation;
import org.eclipse.emf.validation.internal.service.impl.tests.ConstraintDescriptorTest;
import org.eclipse.emf.validation.internal.util.XmlConstraintDescriptor;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.model.ModelConstraint;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IConstraintFilter;
import org.eclipse.emf.validation.service.ILiveValidator;
import org.eclipse.emf.validation.service.ITraversalStrategy;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.validation.tests.CancelConstraint;
import org.eclipse.emf.validation.tests.MultiConstraint;
import org.eclipse.emf.validation.tests.SetTargetConstraint;
import org.eclipse.emf.validation.tests.TestBase;
import org.eclipse.emf.validation.tests.TestNotification;

public class ModelValidationServiceTest
extends TestBase {
    public ModelValidationServiceTest(String name) {
        super(name);
    }

    public void test_getInstance() {
        ModelValidationService instance = ModelValidationService.getInstance();
        ModelValidationServiceTest.assertSame((Object)instance, (Object)ModelValidationService.getInstance());
    }

    public void testFindClass() {
        EClass eClass = OrderSystemPackage.eINSTANCE.getAccount();
        ModelValidationServiceTest.assertSame((Object)eClass, (Object)ModelValidationService.findClass((String)"http:///ordersystem.ecore", (String)"Account"));
    }

    public void test_validateBatchSingle() {
        Order object = OrderSystemFactory.eINSTANCE.createOrder();
        IStatus[] status = this.getStatuses(this.batchValidator.validate((EObject)object));
        this.assertAllConstraintsPresent("batch", status, "org.eclipse.emf.validation.tests.order.hasContents", "org.eclipse.emf.validation.tests.order.notFilledBeforePlacement");
    }

    public void test_validateBatchCollection() {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(OrderSystemFactory.eINSTANCE.createOrder());
        objects.add(OrderSystemFactory.eINSTANCE.createAddress());
        IStatus[] status = this.getStatuses(this.batchValidator.validate(objects));
        this.assertAllTargetsPresent("batch", status, objects);
    }

    public void test_validateSubtreeBatchSingle() {
        Order order = OrderSystemFactory.eINSTANCE.createOrder();
        LineItem item = OrderSystemFactory.eINSTANCE.createLineItem();
        order.getItem().add((Object)item);
        IStatus[] status = this.getStatuses(this.treeValidator.validate((EObject)order));
        this.assertAllTargetsPresent("batch", status, Arrays.asList(order, item));
    }

    public void test_validateSubtreeBatchCollection() {
        ArrayList<Order> orders = new ArrayList<Order>();
        Order order1 = OrderSystemFactory.eINSTANCE.createOrder();
        LineItem item1 = OrderSystemFactory.eINSTANCE.createLineItem();
        order1.getItem().add((Object)item1);
        orders.add(order1);
        Order order2 = OrderSystemFactory.eINSTANCE.createOrder();
        LineItem item2 = OrderSystemFactory.eINSTANCE.createLineItem();
        order2.getItem().add((Object)item2);
        orders.add(order2);
        IStatus[] status = this.getStatuses(this.treeValidator.validate(orders));
        this.assertAllTargetsPresent("batch", status, Arrays.asList(order1, item1, order2, item2));
    }

    public void test_validateLiveSingle() {
        Order object = OrderSystemFactory.eINSTANCE.createOrder();
        new XMIResourceImpl().getContents().add((Object)object);
        TestNotification event = new TestNotification(object, 1);
        IStatus[] status = this.getStatuses(this.liveValidator.validate((Notification)event));
        this.assertAllConstraintsPresent("live", status, "org.eclipse.emf.validation.tests.order.hasName", "org.eclipse.emf.validation.tests.order.hasOwner");
    }

    public void test_validateLiveList() {
        ArrayList<TestNotification> events = new ArrayList<TestNotification>();
        XMIResourceImpl res = new XMIResourceImpl();
        Order order = OrderSystemFactory.eINSTANCE.createOrder();
        Address address = OrderSystemFactory.eINSTANCE.createAddress();
        res.getContents().add((Object)order);
        res.getContents().add((Object)address);
        events.add(new TestNotification(order, 1));
        events.add(new TestNotification(address, 1));
        IStatus[] status = this.getStatuses(this.liveValidator.validate(events));
        ArrayList<EObject> targets = new ArrayList<EObject>(events.size());
        for (Notification notification : events) {
            targets.add((EObject)notification.getNotifier());
        }
        this.assertAllTargetsPresent("live", status, targets);
    }

    public void test_validateConstraintsReturningMultipleResults_161558() {
        Order order = OrderSystemFactory.eINSTANCE.createOrder();
        order.getItem().add((Object)OrderSystemFactory.eINSTANCE.createLineItem());
        MultiConstraint.enabled = true;
        IStatus[] status = this.getStatuses(this.batchValidator.validate((EObject)order));
        MultiConstraint.enabled = false;
        this.assertAllConstraintsPresent("batch", status, "org.eclipse.emf.validation.tests.order.multiConstraint");
        status = this.getStatuses(status, "org.eclipse.emf.validation.tests.order.multiConstraint");
        ModelValidationServiceTest.assertEquals((int)3, (int)status.length);
        boolean foundDefault = false;
        boolean foundFun = false;
        boolean foundSilly = false;
        Set<Order> justOrder = Collections.singleton(order);
        HashSet<Object> orderAndItem = new HashSet<Object>();
        orderAndItem.add(order);
        orderAndItem.addAll((Collection<Object>)order.getItem());
        int i = 0;
        while (i < status.length) {
            IConstraintStatus cstat = (IConstraintStatus)status[i];
            switch (cstat.getCode()) {
                case 1: {
                    foundDefault = true;
                    ModelValidationServiceTest.assertEquals((String)"Nothing to say.", (String)cstat.getMessage());
                    ModelValidationServiceTest.assertEquals((int)4, (int)cstat.getSeverity());
                    ModelValidationServiceTest.assertEquals(justOrder, (Object)cstat.getResultLocus());
                    break;
                }
                case 7: {
                    foundSilly = true;
                    ModelValidationServiceTest.assertEquals((String)"This is silly.", (String)cstat.getMessage());
                    ModelValidationServiceTest.assertEquals((int)2, (int)cstat.getSeverity());
                    ModelValidationServiceTest.assertEquals(justOrder, (Object)cstat.getResultLocus());
                    break;
                }
                case 13: {
                    foundFun = true;
                    ModelValidationServiceTest.assertEquals((String)"This is fun.", (String)cstat.getMessage());
                    ModelValidationServiceTest.assertEquals((int)1, (int)cstat.getSeverity());
                    ModelValidationServiceTest.assertEquals(orderAndItem, (Object)cstat.getResultLocus());
                }
            }
            ++i;
        }
        ModelValidationServiceTest.assertTrue((String)"Didn't find the default status", (boolean)foundDefault);
        ModelValidationServiceTest.assertTrue((String)"Didn't find the fun status", (boolean)foundFun);
        ModelValidationServiceTest.assertTrue((String)"Didn't find the silly status", (boolean)foundSilly);
    }

    public void test_validateSetTargetOnStatus_178121() {
        Order order = OrderSystemFactory.eINSTANCE.createOrder();
        LineItem item = OrderSystemFactory.eINSTANCE.createLineItem();
        order.getItem().add((Object)item);
        SetTargetConstraint.enabled = true;
        IStatus[] status = this.getStatuses(this.batchValidator.validate((EObject)order));
        SetTargetConstraint.enabled = false;
        this.assertAllConstraintsPresent("batch", status, "org.eclipse.emf.validation.tests.order.setTargetConstraint");
        status = this.getStatuses(status, "org.eclipse.emf.validation.tests.order.setTargetConstraint");
        ModelValidationServiceTest.assertEquals((int)3, (int)status.length);
        boolean foundFun = false;
        boolean foundSilly = false;
        boolean foundSuccess = false;
        Set<LineItem> justItem = Collections.singleton(item);
        HashSet<Object> orderAndItem = new HashSet<Object>();
        orderAndItem.add(order);
        orderAndItem.addAll((Collection<Object>)order.getItem());
        int i = 0;
        while (i < status.length) {
            IConstraintStatus cstat = (IConstraintStatus)status[i];
            switch (cstat.getCode()) {
                case 0: {
                    foundSuccess = true;
                    ModelValidationServiceTest.assertEquals((String)EMFModelValidationStatusCodes.CONSTRAINT_SUCCESS_MSG, (String)cstat.getMessage());
                    ModelValidationServiceTest.assertEquals((int)0, (int)cstat.getSeverity());
                    ModelValidationServiceTest.assertEquals(orderAndItem, (Object)cstat.getResultLocus());
                    ModelValidationServiceTest.assertSame((Object)item, (Object)cstat.getTarget());
                    break;
                }
                case 7: {
                    foundSilly = true;
                    ModelValidationServiceTest.assertEquals((String)"This is silly.", (String)cstat.getMessage());
                    ModelValidationServiceTest.assertEquals((int)2, (int)cstat.getSeverity());
                    ModelValidationServiceTest.assertEquals(justItem, (Object)cstat.getResultLocus());
                    ModelValidationServiceTest.assertSame((Object)item, (Object)cstat.getTarget());
                    break;
                }
                case 13: {
                    foundFun = true;
                    ModelValidationServiceTest.assertEquals((String)"This is fun.", (String)cstat.getMessage());
                    ModelValidationServiceTest.assertEquals((int)1, (int)cstat.getSeverity());
                    ModelValidationServiceTest.assertEquals(justItem, (Object)cstat.getResultLocus());
                    ModelValidationServiceTest.assertSame((Object)item, (Object)cstat.getTarget());
                }
            }
            ++i;
        }
        ModelValidationServiceTest.assertTrue((String)"Didn't find the success status", (boolean)foundSuccess);
        ModelValidationServiceTest.assertTrue((String)"Didn't find the silly status", (boolean)foundSilly);
        ModelValidationServiceTest.assertTrue((String)"Didn't find the fun status", (boolean)foundFun);
    }

    public void test_validateLiveConstraintFilter_177644() {
        Order order1 = OrderSystemFactory.eINSTANCE.createOrder();
        order1.setCompleted(true);
        Order order2 = OrderSystemFactory.eINSTANCE.createOrder();
        order2.setCompleted(false);
        EList contents = new XMIResourceImpl().getContents();
        contents.add((Object)order1);
        contents.add((Object)order2);
        ArrayList<TestNotification> events = new ArrayList<TestNotification>();
        events.add(new TestNotification(order1, 1));
        events.add(new TestNotification(order2, 1));
        ILiveValidator validator = (ILiveValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.LIVE);
        IConstraintFilter filter = new IConstraintFilter(){

            public boolean accept(IConstraintDescriptor constraint, EObject object) {
                if (object instanceof Order) {
                    Order order = (Order)object;
                    return order.isCompleted() && constraint.getId().equals("org.eclipse.emf.validation.tests.order.hasName");
                }
                return false;
            }
        };
        validator.addConstraintFilter(filter);
        validator.setReportSuccesses(true);
        IStatus[] status = this.getStatuses(validator.validate(events));
        this.assertConstraintAndTargetPresent("live", status, "org.eclipse.emf.validation.tests.order.hasName", order1);
        this.assertConstraintAndTargetNotPresent("live", status, "org.eclipse.emf.validation.tests.order.hasOwner", order1);
        this.assertConstraintAndTargetNotPresent("live", status, "org.eclipse.emf.validation.tests.order.hasName", order2);
        this.assertConstraintAndTargetNotPresent("live", status, "org.eclipse.emf.validation.tests.order.hasOwner", order2);
        validator.removeConstraintFilter(filter);
        status = this.getStatuses(validator.validate(events));
        this.assertConstraintAndTargetPresent("live", status, "org.eclipse.emf.validation.tests.order.hasOwner", order1);
        this.assertConstraintAndTargetPresent("live", status, "org.eclipse.emf.validation.tests.order.hasName", order2);
        this.assertConstraintAndTargetPresent("live", status, "org.eclipse.emf.validation.tests.order.hasOwner", order2);
    }

    public void test_validateBatchConstraintFilter_177644() {
        Order order1 = OrderSystemFactory.eINSTANCE.createOrder();
        order1.setCompleted(true);
        Order order2 = OrderSystemFactory.eINSTANCE.createOrder();
        order2.setCompleted(false);
        EList contents = new XMIResourceImpl().getContents();
        contents.add((Object)order1);
        contents.add((Object)order2);
        ArrayList<Order> targets = new ArrayList<Order>();
        targets.add(order1);
        targets.add(order2);
        IBatchValidator validator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
        IConstraintFilter filter = new IConstraintFilter(){

            public boolean accept(IConstraintDescriptor constraint, EObject object) {
                if (object instanceof Order) {
                    Order order = (Order)object;
                    return order.isCompleted() && constraint.getId().equals("org.eclipse.emf.validation.tests.order.hasName");
                }
                return false;
            }
        };
        validator.addConstraintFilter(filter);
        validator.setReportSuccesses(true);
        validator.setIncludeLiveConstraints(true);
        IStatus[] status = this.getStatuses(validator.validate(targets));
        this.assertConstraintAndTargetPresent("batch", status, "org.eclipse.emf.validation.tests.order.hasName", order1);
        this.assertConstraintAndTargetNotPresent("batch", status, "org.eclipse.emf.validation.tests.order.hasOwner", order1);
        this.assertConstraintAndTargetNotPresent("batch", status, "org.eclipse.emf.validation.tests.order.hasName", order2);
        this.assertConstraintAndTargetNotPresent("batch", status, "org.eclipse.emf.validation.tests.order.hasOwner", order2);
        validator.removeConstraintFilter(filter);
        status = this.getStatuses(validator.validate(targets));
        this.assertConstraintAndTargetPresent("batch", status, "org.eclipse.emf.validation.tests.order.hasOwner", order1);
        this.assertConstraintAndTargetPresent("batch", status, "org.eclipse.emf.validation.tests.order.hasName", order2);
        this.assertConstraintAndTargetPresent("batch", status, "org.eclipse.emf.validation.tests.order.hasOwner", order2);
    }

    public void test_cancelSeverity_batch_bug179776() {
        CancelConstraint.enabled = true;
        Order object = OrderSystemFactory.eINSTANCE.createOrder();
        this.batchValidator.setIncludeLiveConstraints(true);
        IStatus[] status = this.getStatuses(this.batchValidator.validate((EObject)object));
        this.assertAllConstraintsPresent("batch", status, "org.eclipse.emf.validation.tests.order.cancelConstraint");
        IStatus particular = this.getStatus(status, "org.eclipse.emf.validation.tests.order.cancelConstraint");
        ModelValidationServiceTest.assertTrue((String)"Wrong kind of constraint", (boolean)(particular instanceof IConstraintStatus));
        IConstraintStatus cstat = (IConstraintStatus)particular;
        ModelValidationServiceTest.assertEquals((int)8, (int)cstat.getSeverity());
        ModelValidationServiceTest.assertFalse((boolean)cstat.getConstraint().getDescriptor().isError());
    }

    public void test_cancelSeverity_live_bug179776() {
        CancelConstraint.enabled = true;
        XMIResourceImpl res = new XMIResourceImpl();
        Order object = OrderSystemFactory.eINSTANCE.createOrder();
        res.getContents().add((Object)object);
        ArrayList<TestNotification> events = new ArrayList<TestNotification>();
        events.add(new TestNotification(object, 1));
        IStatus[] status = this.getStatuses(this.liveValidator.validate(events));
        this.assertAllConstraintsPresent("live", status, "org.eclipse.emf.validation.tests.order.cancelConstraint");
        IStatus particular = this.getStatus(status, "org.eclipse.emf.validation.tests.order.cancelConstraint");
        ModelValidationServiceTest.assertTrue((String)"Wrong kind of constraint", (boolean)(particular instanceof IConstraintStatus));
        IConstraintStatus cstat = (IConstraintStatus)particular;
        ModelValidationServiceTest.assertEquals((int)8, (int)cstat.getSeverity());
        ModelValidationServiceTest.assertFalse((boolean)cstat.getConstraint().getDescriptor().isError());
    }

    public void test_validateInstanceOfExtendingEClassInOtherPackage_183917() {
        EPackage epackage = EcoreFactory.eINSTANCE.createEPackage();
        epackage.setNsURI("http://test/extending/package");
        epackage.setNsPrefix("test");
        epackage.setName("testextendingpackage");
        EClass myOrderClass = EcoreFactory.eINSTANCE.createEClass();
        epackage.getEClassifiers().add((Object)myOrderClass);
        myOrderClass.setName("MyOrder");
        class MyOrderImpl
        extends OrderImpl {
            private final /* synthetic */ EClass val$myOrderClass;

            MyOrderImpl(EClass eClass) {
                this.val$myOrderClass = eClass;
            }

            public EClass eClass() {
                return this.val$myOrderClass;
            }
        }
        myOrderClass.setInstanceClass(MyOrderImpl.class);
        myOrderClass.getESuperTypes().add((Object)OrderSystemPackage.eINSTANCE.getOrder());
        MyOrderImpl order = new MyOrderImpl(myOrderClass);
        IStatus[] status = this.getStatuses(this.batchValidator.validate((EObject)order));
        this.assertAllConstraintsPresent("batch", status, "org.eclipse.emf.validation.tests.order.hasContents", "org.eclipse.emf.validation.tests.order.notFilledBeforePlacement");
    }

    public void test_recursiveTraversalStrategy_207990() {
        ArrayList<Object> objects = new ArrayList<Object>();
        Order order1 = OrderSystemFactory.eINSTANCE.createOrder();
        LineItem item1 = OrderSystemFactory.eINSTANCE.createLineItem();
        order1.getItem().add((Object)item1);
        objects.add(item1);
        objects.add(order1);
        HashSet<EObject> visited = new HashSet<EObject>();
        ITraversalStrategy traversal = this.batchValidator.getDefaultTraversalStrategy();
        traversal.startTraversal(objects, (IProgressMonitor)new NullProgressMonitor());
        while (traversal.hasNext()) {
            EObject next = traversal.next();
            ModelValidationServiceTest.assertTrue((String)"Already traversed this element", (boolean)visited.add(next));
            traversal.elementValidated(next, Status.OK_STATUS);
        }
    }

    public void test_traversalStrategiesNotShared_sameValidator_207992() {
        TestTraversalStrategy.reset();
        PreferredCustomer customer = SpecialFactory.eINSTANCE.createPreferredCustomer();
        IBatchValidator batchValidator1 = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
        IBatchValidator batchValidator2 = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
        batchValidator1.validate((EObject)customer);
        batchValidator2.validate((EObject)customer);
        ModelValidationServiceTest.assertTrue((boolean)TestTraversalStrategy.wasUsed());
        ModelValidationServiceTest.assertEquals((int)1, (int)TestTraversalStrategy.getInstanceCount());
    }

    public void test_traversalStrategiesNotShared_differentValidators_207992() {
        TestTraversalStrategy.reset();
        final PreferredCustomer customer = SpecialFactory.eINSTANCE.createPreferredCustomer();
        final IBatchValidator batchValidator1 = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
        final IBatchValidator batchValidator2 = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
        Thread t1 = new Thread(new Runnable(){

            public void run() {
                batchValidator1.validate((EObject)customer);
            }
        });
        Thread t2 = new Thread(new Runnable(){

            public void run() {
                batchValidator2.validate((EObject)customer);
            }
        });
        t1.start();
        t2.start();
        try {
            t1.join();
            t2.join();
        }
        catch (InterruptedException e) {
            ModelValidationServiceTest.fail((String)"Test was interrupted");
        }
        ModelValidationServiceTest.assertTrue((boolean)TestTraversalStrategy.wasUsed());
        ModelValidationServiceTest.assertEquals((int)2, (int)TestTraversalStrategy.getInstanceCount());
    }

    public void test_currentConstraintData_232572() {
        Method method;
        class MyContext
        extends AbstractValidationContext {
            MyContext() {
                super((IProviderOperation)new GetBatchConstraintsOperation(false));
            }
        }
        MyContext ctx;
        block8: {
            ctx = new MyContext();
            method = null;
            try {
                try {
                    method = AbstractValidationContext.class.getDeclaredMethod("setConstraint", IModelConstraint.class);
                    method.setAccessible(true);
                    ConstraintDescriptorTest.FixtureElement config = ConstraintDescriptorTest.newFixtureConfig();
                    config.putAttribute("id", "foo.232572");
                    method.invoke((Object)ctx, new ModelConstraint((IConstraintDescriptor)new XmlConstraintDescriptor((IConfigurationElement)config)){

                        public IStatus validate(IValidationContext ctx) {
                            return Status.OK_STATUS;
                        }
                    });
                }
                catch (Exception e) {
                    ModelValidationServiceTest.fail((String)("Failed to access setCurrentConstraint() method: " + e.getLocalizedMessage()));
                    if (method != null) {
                        method.setAccessible(false);
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (method != null) {
                    method.setAccessible(false);
                }
                throw throwable;
            }
            if (method != null) {
                method.setAccessible(false);
            }
        }
        ctx.putCurrentConstraintData(method);
        ModelValidationServiceTest.assertSame((Object)method, (Object)ctx.getCurrentConstraintData());
    }

    protected void tearDown() throws Exception {
        CancelConstraint.enabled = false;
        super.tearDown();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestTraversalStrategy
    implements ITraversalStrategy {
        static int instances = 0;
        static boolean used;
        private final ITraversalStrategy delegate = new ITraversalStrategy.Recursive();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TestTraversalStrategy() {
            Class<TestTraversalStrategy> clazz = TestTraversalStrategy.class;
            synchronized (TestTraversalStrategy.class) {
                ++instances;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        static synchronized int getInstanceCount() {
            return instances;
        }

        static synchronized void reset() {
            instances = 0;
            used = false;
        }

        static synchronized boolean wasUsed() {
            return used;
        }

        public void elementValidated(EObject element, IStatus status) {
            this.delegate.elementValidated(element, status);
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public boolean isClientContextChanged() {
            return this.delegate.isClientContextChanged();
        }

        public EObject next() {
            return this.delegate.next();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startTraversal(Collection<? extends EObject> traversalRoots, IProgressMonitor monitor) {
            Class<TestTraversalStrategy> clazz = TestTraversalStrategy.class;
            synchronized (TestTraversalStrategy.class) {
                used = true;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                this.delegate.startTraversal(traversalRoots, monitor);
                return;
            }
        }
    }
}

