/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.example.databinding.project.ui.rcp.views;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ObservablesManager;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditListProperty;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.example.databinding.project.ui.rcp.databinding.GenericMapCellLabelProvider;
import org.eclipse.emf.examples.databinding.project.core.model.project.CommitterShip;
import org.eclipse.emf.examples.databinding.project.core.model.project.ProjectPackage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;

public class ProjectCommittersPart {
    private static final String END_DATE_PROPERTY = "enddate";

    public ProjectCommittersPart(IViewSite site, CTabFolder folder, DataBindingContext ctx, EditingDomain editingDomain, ObservablesManager manager, IObservableValue master) {
        this.init(site, folder, ctx, editingDomain, master);
    }

    private void init(IViewSite site, CTabFolder folder, DataBindingContext ctx, EditingDomain editingDomain, IObservableValue master) {
        final TableViewer viewer = new TableViewer((Composite)folder, 65536);
        IEMFEditValueProperty prop = EMFEditProperties.value((EditingDomain)editingDomain, (EStructuralFeature)ProjectPackage.Literals.PROJECT__COMMITTERS);
        CTabItem item = new CTabItem(folder, 0);
        item.setControl(viewer.getControl());
        ctx.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)item), prop.observeDetail(master), (UpdateValueStrategy)new EMFUpdateValueStrategy(), new EMFUpdateValueStrategy().setConverter((IConverter)new LengthConverter()));
        folder.setSelection(0);
        viewer.getTable().setHeaderVisible(true);
        ObservableListContentProvider cp = new ObservableListContentProvider();
        IObservableMap attributeMap = new IObservableMap[]{EMFEditProperties.value((EditingDomain)editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ProjectPackage.Literals.COMMITTER_SHIP__PERSON, ProjectPackage.Literals.PERSON__LASTNAME})).observeDetail(cp.getKnownElements()), EMFEditProperties.value((EditingDomain)editingDomain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ProjectPackage.Literals.COMMITTER_SHIP__PERSON, ProjectPackage.Literals.PERSON__FIRSTNAME})).observeDetail(cp.getKnownElements())};
        TableViewerColumn column = new TableViewerColumn(viewer, 0);
        column.getColumn().setText("Name");
        column.getColumn().setWidth(150);
        column.setLabelProvider((CellLabelProvider)new GenericMapCellLabelProvider("{0}, {1}", (IObservableMap[])attributeMap));
        attributeMap = EMFEditProperties.value((EditingDomain)editingDomain, (EStructuralFeature)ProjectPackage.Literals.COMMITTER_SHIP__START).observeDetail(cp.getKnownElements());
        column = new TableViewerColumn(viewer, 0);
        column.getColumn().setText("Start");
        column.getColumn().setWidth(100);
        column.setLabelProvider((CellLabelProvider)new GenericMapCellLabelProvider("{0,date,short}", attributeMap));
        attributeMap = EMFEditProperties.value((EditingDomain)editingDomain, (EStructuralFeature)ProjectPackage.Literals.COMMITTER_SHIP__END).observeDetail(cp.getKnownElements());
        column = new TableViewerColumn(viewer, 0);
        column.getColumn().setText("End");
        column.getColumn().setWidth(100);
        column.setLabelProvider((CellLabelProvider)new GenericMapCellLabelProvider("{0,date,short}", attributeMap));
        IEMFEditListProperty prop2 = EMFEditProperties.list((EditingDomain)editingDomain, (EStructuralFeature)ProjectPackage.Literals.PROJECT__COMMITTERS);
        viewer.setContentProvider((IContentProvider)cp);
        viewer.setInput((Object)prop2.observeDetail(master));
        MenuManager mgr = new MenuManager();
        mgr.add((IAction)new Action("Hide historic committers", 2){

            public void run() {
                if (this.isChecked()) {
                    viewer.addFilter((ViewerFilter)new ViewerFilterImpl());
                } else {
                    viewer.setFilters(new ViewerFilter[0]);
                }
            }
        });
        viewer.getControl().setMenu(mgr.createContextMenu(viewer.getControl()));
        site.registerContextMenu("org.eclipse.emf.examples.databinding.project.ui.rcp.committers", mgr, (ISelectionProvider)viewer);
    }

    public void dispose() {
    }

    private class LengthConverter
    extends Converter {
        public LengthConverter() {
            super(Collection.class, String.class);
        }

        public Object convert(Object fromObject) {
            return "Committers (" + (fromObject != null ? Integer.valueOf(((Collection)fromObject).size()) : "0") + ")";
        }
    }

    private class ViewerFilterImpl
    extends ViewerFilter {
        private ViewerFilterImpl() {
        }

        public boolean isFilterProperty(Object element, String property) {
            if (property != null && property == ProjectCommittersPart.END_DATE_PROPERTY) {
                return true;
            }
            return super.isFilterProperty(element, property);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            Date enddate = ((CommitterShip)element).getEnd();
            return enddate == null || enddate.getTime() > Calendar.getInstance().getTimeInMillis();
        }
    }
}

