/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.model.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.emf.validation.internal.l10n.ValidationMessages;
import org.eclipse.emf.validation.model.EvaluationMode;

public class EvaluationModeTest
extends TestCase {
    public void test_getInstance() {
        EvaluationModeTest.assertSame((Object)EvaluationMode.BATCH, (Object)EvaluationMode.getInstance((String)EvaluationMode.BATCH.getName()));
        EvaluationModeTest.assertSame((Object)EvaluationMode.LIVE, (Object)EvaluationMode.getInstance((String)EvaluationMode.LIVE.getName()));
        EvaluationModeTest.assertSame((Object)EvaluationMode.NULL, (Object)EvaluationMode.getInstance((String)""));
    }

    public void test_getAllInstances() {
        List instances = EvaluationMode.getAllInstances();
        EvaluationModeTest.assertTrue((boolean)instances.contains(EvaluationMode.BATCH));
        EvaluationModeTest.assertTrue((boolean)instances.contains(EvaluationMode.LIVE));
        EvaluationModeTest.assertTrue((boolean)instances.contains(EvaluationMode.NULL));
    }

    public void test_getName() {
        EvaluationModeTest.assertEquals((String)"Batch", (String)EvaluationMode.BATCH.getName());
        EvaluationModeTest.assertEquals((String)"Live", (String)EvaluationMode.LIVE.getName());
        EvaluationModeTest.assertEquals((String)"none", (String)EvaluationMode.NULL.getName());
    }

    public void test_getLocalizedName() {
        EvaluationModeTest.assertEquals((String)ValidationMessages.mode_batch, (String)EvaluationMode.BATCH.getLocalizedName());
        EvaluationModeTest.assertEquals((String)ValidationMessages.mode_live, (String)EvaluationMode.LIVE.getLocalizedName());
        EvaluationModeTest.assertEquals((String)ValidationMessages.mode_unknown, (String)EvaluationMode.NULL.getLocalizedName());
    }

    public void test_isNull() {
        EvaluationModeTest.assertTrue((boolean)EvaluationMode.NULL.isNull());
        EvaluationModeTest.assertFalse((boolean)EvaluationMode.BATCH.isNull());
        EvaluationModeTest.assertFalse((boolean)EvaluationMode.LIVE.isNull());
    }

    public void test_isLive() {
        EvaluationModeTest.assertFalse((boolean)EvaluationMode.NULL.isLive());
        EvaluationModeTest.assertFalse((boolean)EvaluationMode.BATCH.isLive());
        EvaluationModeTest.assertTrue((boolean)EvaluationMode.LIVE.isLive());
    }

    public void test_isBatch() {
        EvaluationModeTest.assertFalse((boolean)EvaluationMode.NULL.isBatch());
        EvaluationModeTest.assertTrue((boolean)EvaluationMode.BATCH.isBatch());
        EvaluationModeTest.assertTrue((boolean)EvaluationMode.LIVE.isBatch());
    }

    public void test_isBatchOnly() {
        EvaluationModeTest.assertFalse((boolean)EvaluationMode.NULL.isBatchOnly());
        EvaluationModeTest.assertTrue((boolean)EvaluationMode.BATCH.isBatchOnly());
        EvaluationModeTest.assertFalse((boolean)EvaluationMode.LIVE.isBatchOnly());
    }

    public void test_readResolve() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ObjectOutput output = null;
        ObjectInput input = null;
        try {
            try {
                output = new ObjectOutputStream(stream);
                for (EvaluationMode next : EvaluationMode.getAllInstances()) {
                    output.writeObject(next);
                }
                output.flush();
                input = new ObjectInputStream(new ByteArrayInputStream(stream.toByteArray()));
                for (EvaluationMode next : EvaluationMode.getAllInstances()) {
                    EvaluationModeTest.assertSame((Object)next, (Object)input.readObject());
                }
            }
            catch (Exception e) {
                EvaluationModeTest.fail((String)e.getLocalizedMessage());
                try {
                    output.close();
                    input.close();
                }
                catch (Exception e2) {
                    EvaluationModeTest.fail((String)e2.getLocalizedMessage());
                }
            }
        }
        finally {
            try {
                output.close();
                input.close();
            }
            catch (Exception e) {
                EvaluationModeTest.fail((String)e.getLocalizedMessage());
            }
        }
    }
}

