/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.impl.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.eef.runtime.EEFRuntimePlugin;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EEFUtils {
    public static final String JDT_CORE_SYMBOLIC_NAME = "org.eclipse.jdt.core";

    public static Object choiceOfValues(AdapterFactory adapterFactory, EObject eObject, EStructuralFeature feature, ResourceSet allResources) {
        return EEFUtils.choiceOfValues(eObject, feature, allResources);
    }

    public static Object choiceOfValues(EObject eObject, EStructuralFeature feature, ResourceSet allResources) {
        return EEFUtils.choiceOfValues(eObject, feature);
    }

    public static Object choiceOfValues(EObject eObject, EStructuralFeature feature) {
        IItemPropertyDescriptor propertyDescriptor;
        Collection choiceOfValues = null;
        IItemPropertySource ps = (IItemPropertySource)EEFRuntimePlugin.getDefault().getAdapterFactory().adapt((Notifier)eObject, IItemPropertySource.class);
        if (ps != null && (propertyDescriptor = ps.getPropertyDescriptor((Object)eObject, (Object)feature)) != null) {
            choiceOfValues = propertyDescriptor.getChoiceOfValues((Object)eObject);
        }
        if (choiceOfValues == null && eObject.eResource() != null && eObject.eResource().getResourceSet() != null) {
            choiceOfValues = eObject.eResource().getResourceSet();
        }
        return choiceOfValues;
    }

    public static List<EClass> instanciableTypesInHierarchy(EClassifier eClassifier) {
        return EEFUtils.instanciableTypesInHierarchy(eClassifier, null);
    }

    public static List<EClass> instanciableTypesInHierarchy(EClassifier eClassifier, ResourceSet resourceSet) {
        ArrayList<EClass> result = new ArrayList<EClass>();
        if (eClassifier instanceof EClass) {
            EClass eClass = (EClass)eClassifier;
            if (!eClass.isAbstract()) {
                result.add(eClass);
            }
            result.addAll(EEFUtils.instanciableSubTypes(eClass, resourceSet));
        }
        return result;
    }

    private static List<EClass> instanciableSubTypes(EClass eClass, ResourceSet resourceSet) {
        ArrayList<EClass> result = new ArrayList<EClass>();
        for (EPackage ePackage : EEFUtils.allPackages(eClass, resourceSet)) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                EClass eClass2;
                if (!(eClassifier instanceof EClass) || (eClass2 = (EClass)eClassifier).equals(eClass) || !eClass.isSuperTypeOf(eClass2) || eClass2.isAbstract() || eClass2.isInterface()) continue;
                result.add(eClass2);
            }
        }
        return result;
    }

    private static List<EPackage> allPackages(EClass eClass, ResourceSet resourceSet) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        if (eClass.eResource() != null) {
            EcoreUtil.resolveAll((EObject)eClass);
            EList resourcesToProcess = null;
            if (eClass.eResource().getResourceSet() != null) {
                resourcesToProcess = eClass.eResource().getResourceSet().getResources();
            } else {
                resourcesToProcess = new ArrayList();
                resourcesToProcess.add(eClass.eResource());
            }
            for (Resource resource : resourcesToProcess) {
                result.addAll(EEFUtils.allPackageOfResource(resource));
            }
        } else {
            EPackage rootPackage = eClass.getEPackage();
            while (rootPackage.getESuperPackage() != null) {
                rootPackage = rootPackage.getESuperPackage();
            }
            result.addAll(EEFUtils.allSubPackages(rootPackage));
        }
        if (resourceSet != null) {
            for (EPackage ePackage : EEFUtils.getAllEPackagesFromResourceSet(resourceSet)) {
                if (result.contains(ePackage)) continue;
                result.add(ePackage);
            }
        }
        return result;
    }

    private static List<EPackage> getAllEPackagesFromResourceSet(ResourceSet resourceSet_p) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        for (Resource resource : resourceSet_p.getResources()) {
            for (EPackage pkg : EEFUtils.allPackageOfResource(resource)) {
                result.add(EEFUtils.getStaticPackage(pkg));
            }
        }
        return result;
    }

    private static EPackage getStaticPackage(EPackage ePackage_p) {
        Object staticPackage = EPackage.Registry.INSTANCE.get((Object)ePackage_p.getNsURI());
        if (staticPackage != null) {
            if (staticPackage instanceof EPackage) {
                return (EPackage)staticPackage;
            }
            if (staticPackage instanceof EPackage.Descriptor) {
                return ((EPackage.Descriptor)staticPackage).getEPackage();
            }
        }
        return null;
    }

    private static List<EPackage> allSubPackages(EPackage ePackage) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        for (EPackage subPackage : ePackage.getESubpackages()) {
            result.addAll(EEFUtils.allSubPackages(subPackage));
        }
        return result;
    }

    private static List<EPackage> allPackageOfResource(Resource resource) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            EObject type = (EObject)iterator.next();
            if (!(type instanceof EPackage)) continue;
            result.add((EPackage)type);
        }
        return result;
    }

    public static List<Object> asList(TreeIterator<Object> iter) {
        ArrayList<Object> result = new ArrayList<Object>();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    public static List<EObject> asEObjectList(TreeIterator<EObject> iter) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        while (iter.hasNext()) {
            result.add((EObject)iter.next());
        }
        return result;
    }

    public static boolean isBundleLoaded(String name) {
        Bundle bundle = Platform.getBundle((String)name);
        return bundle != null && bundle.getState() == 32;
    }

    public static boolean containsInstanceOfEClass(EObject element, EClass eClassToCheck) {
        if (EEFUtils.isInstanceOfEClass(element, eClassToCheck)) {
            return true;
        }
        for (EObject container : element.eContents()) {
            if (!EEFUtils.containsInstanceOfEClass(container, eClassToCheck)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstanceOfEClass(EObject element, EClass eClassToCheck) {
        EClass eClass = element.eClass();
        if (eClass.equals(eClassToCheck)) {
            return true;
        }
        for (EClass eSuperClass : eClass.getEAllSuperTypes()) {
            if (!eSuperClass.equals(eClassToCheck)) continue;
            return true;
        }
        return false;
    }
}

