/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.extended.flow;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.eef.EEFGen.EEFGenModel;
import org.eclipse.emf.eef.EEFGen.GenEditionContext;
import org.eclipse.emf.eef.codegen.core.launcher.AbstractPropertiesGeneratorLauncher;
import org.eclipse.emf.eef.codegen.core.services.PropertiesGeneratorLaunchersServices;
import org.eclipse.emf.eef.codegen.extended.launcher.EEFEditorLauncher;
import org.eclipse.emf.eef.codegen.flow.Step;
import org.eclipse.emf.eef.codegen.flow.var.WorkflowVariable;

public class OverrideEMFEditorCode
extends Step {
    private Object eefEditorGenModel;

    public OverrideEMFEditorCode(String name, Object eefEditorGenModel) {
        super(name);
        this.eefEditorGenModel = eefEditorGenModel;
    }

    public IStatus execute(IProgressMonitor monitor) {
        try {
            EEFGenModel eefEditorGenModel = this.getEEFEditorGenModel();
            IContainer target = this.getGenContainer(eefEditorGenModel);
            if (target != null) {
                monitor.beginTask("Generating EEF Editor", 1);
                this.clearExistingEditorCode(monitor);
                LinkedHashSet<IContainer> generationTargets = new LinkedHashSet<IContainer>();
                generationTargets.add(target);
                EEFEditorLauncher generator = new EEFEditorLauncher((EObject)eefEditorGenModel, target.getLocation().toFile(), new ArrayList());
                generator.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
                List launchers = PropertiesGeneratorLaunchersServices.getInstance().getlaunchers();
                for (AbstractPropertiesGeneratorLauncher abstractPropertiesGeneratorLauncher : launchers) {
                    EObject inputModel = generator.getModel();
                    if (!(inputModel instanceof EEFGenModel)) continue;
                    abstractPropertiesGeneratorLauncher.doGenerate(eefEditorGenModel, generator.getTargetFolder(), monitor);
                    if (abstractPropertiesGeneratorLauncher.getTargetContainer().isEmpty()) continue;
                    generationTargets.addAll(abstractPropertiesGeneratorLauncher.getTargetContainer());
                }
                for (IContainer nextContainer : generationTargets) {
                    nextContainer.refreshLocal(2, monitor);
                }
            }
            return Status.OK_STATUS;
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.emf.eef.codegen.extended", "An error occured during generation.", (Throwable)e);
        }
        catch (CoreException e) {
            return new Status(4, "org.eclipse.emf.eef.codegen.extended", "An error occured during generation.", (Throwable)e);
        }
    }

    public EEFGenModel getEEFEditorGenModel() {
        if (this.eefEditorGenModel instanceof EEFGenModel) {
            return (EEFGenModel)this.eefEditorGenModel;
        }
        if (this.eefEditorGenModel instanceof WorkflowVariable) {
            return (EEFGenModel)((WorkflowVariable)this.eefEditorGenModel).getValue();
        }
        return null;
    }

    public IContainer getGenContainer(EEFGenModel eefGenModel) throws IOException {
        if (eefGenModel != null && eefGenModel.getGenDirectory() != null) {
            IFolder target = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(eefGenModel.getGenDirectory()));
            return target;
        }
        return null;
    }

    private void clearExistingEditorCode(IProgressMonitor monitor) throws CoreException {
        for (GenEditionContext genEditionContext : this.getEEFEditorGenModel().getEditionContexts()) {
            if (genEditionContext.getPropertiesEditionContext() == null || genEditionContext.getPropertiesEditionContext().getModel() == null) continue;
            GenPackage genPackage = genEditionContext.getPropertiesEditionContext().getModel();
            StringBuilder builder = new StringBuilder();
            builder.append(genPackage.getGenModel().getEditorPluginDirectory());
            builder.append('/');
            builder.append(genPackage.getPresentationPackageName().replaceAll("\\.", "/"));
            builder.append('/');
            builder.append(genPackage.getEditorClassName());
            builder.append(".java");
            String qualifiedEditorClass = builder.toString();
            IFile editorClass = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(qualifiedEditorClass));
            if (!editorClass.isAccessible()) continue;
            editorClass.setContents((InputStream)new ByteArrayInputStream("".getBytes()), true, false, monitor);
        }
    }
}

