/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.eef.runtime.impl.utils.ModelViewerHelper;
import org.eclipse.emf.eef.runtime.ui.utils.EEFLabelProvider;
import org.eclipse.emf.eef.runtime.ui.utils.EEFRuntimeUIMessages;
import org.eclipse.emf.eef.runtime.ui.widgets.IPropertiesFilteredWidget;
import org.eclipse.emf.eef.runtime.ui.widgets.referencestable.ReferencesTableSettings;
import org.eclipse.emf.eef.runtime.ui.widgets.settings.AdvancedEEFEditorContentProvider;
import org.eclipse.emf.eef.runtime.ui.widgets.settings.EEFEditorSettings;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TabElementTreeSelectionDialog
extends Dialog
implements IPropertiesFilteredWidget {
    protected Label label;
    protected Tree tree;
    protected String title = EEFRuntimeUIMessages.TabElementTreeSelectionDialog_title;
    private List<ViewerFilter> viewerFilters;
    private List<ViewerFilter> brFilters;
    protected AdapterFactory adapterFactory;
    private Composite parent;
    private Object input;
    private IStructuredSelection selection;
    private Resource mainResource;

    public TabElementTreeSelectionDialog(Object input, List<ViewerFilter> filters, List<ViewerFilter> brFilters, String title, AdapterFactory adapterFactory, Resource mainResource) {
        super(Display.getDefault().getActiveShell());
        this.setShellStyle(0x10 | super.getShellStyle());
        this.input = input;
        this.viewerFilters = filters;
        this.brFilters = brFilters;
        this.title = title;
        this.adapterFactory = adapterFactory;
        this.mainResource = mainResource;
    }

    protected Control createDialogArea(Composite parent) {
        this.parent = parent;
        CTabFolder tabFolder = new CTabFolder(parent, 2048);
        tabFolder.setMaximized(true);
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(EEFRuntimeUIMessages.TabElementTreeSelectionDialog_model_resource_tab_title);
        tabItem.setControl(this.fillModelpage(tabFolder, false, new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                ResourceSet resourceSet = null;
                if (TabElementTreeSelectionDialog.this.input instanceof ResourceSet) {
                    resourceSet = (ResourceSet)TabElementTreeSelectionDialog.this.input;
                } else if (TabElementTreeSelectionDialog.this.input instanceof EEFEditorSettings && ((EEFEditorSettings)TabElementTreeSelectionDialog.this.input).getSource().eResource() != null) {
                    resourceSet = ((EEFEditorSettings)TabElementTreeSelectionDialog.this.input).getSource().eResource().getResourceSet();
                }
                if (resourceSet != null) {
                    Resource mainResource;
                    Resource resource = mainResource = TabElementTreeSelectionDialog.this.mainResource != null ? TabElementTreeSelectionDialog.this.mainResource : (Resource)resourceSet.getResources().get(0);
                    if (mainResource != null && mainResource == element) {
                        return true;
                    }
                    if (element instanceof EObject) {
                        EObject eObject = (EObject)element;
                        if (mainResource != null && mainResource == eObject.eResource()) {
                            return true;
                        }
                    }
                }
                return false;
            }
        }));
        tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(EEFRuntimeUIMessages.TabElementTreeSelectionDialog_all_resources_tab_title);
        tabItem.setControl(this.fillModelpage(tabFolder, true, null));
        return tabFolder;
    }

    public Control fillModelpage(CTabFolder tabFolder, boolean showResourceItem, ViewerFilter specificTabFilter) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        TreeSelectionPatternFilter patternFilter = new TreeSelectionPatternFilter();
        patternFilter.setIncludeLeadingWildcard(true);
        FilteredTree filteredTree = new FilteredTree(composite, 2580, (PatternFilter)patternFilter);
        TreeViewer treeViewer = filteredTree.getViewer();
        treeViewer.setFilters(new ViewerFilter[0]);
        treeViewer.setUseHashlookup(true);
        if (this.input instanceof EEFEditorSettings) {
            treeViewer.setContentProvider((IContentProvider)new AdvancedEEFEditorContentProvider(this.adapterFactory));
        } else {
            treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.adapterFactory));
        }
        ArrayList<Object> filters = new ArrayList<Object>();
        if (specificTabFilter != null) {
            filters.add(specificTabFilter);
        }
        if (this.viewerFilters != null && !this.viewerFilters.isEmpty()) {
            for (ViewerFilter filter : this.viewerFilters) {
                filters.add(filter);
            }
        }
        if (this.brFilters != null && !this.brFilters.isEmpty()) {
            for (ViewerFilter filter : this.brFilters) {
                filters.add(filter);
            }
        }
        filters.add((Object)patternFilter);
        ViewerFilter[] v = filters.toArray(new ViewerFilter[filters.size()]);
        treeViewer.setFilters(v);
        treeViewer.setLabelProvider((IBaseLabelProvider)new EEFLabelProvider(){

            public Color getForeground(Object element) {
                if (TabElementTreeSelectionDialog.this.input instanceof ReferencesTableSettings && element instanceof EObject && ((ReferencesTableSettings)TabElementTreeSelectionDialog.this.input).contains((EObject)element)) {
                    return TabElementTreeSelectionDialog.this.getShell().getDisplay().getSystemColor(18);
                }
                return super.getForeground(element);
            }
        });
        filteredTree.setLayoutData((Object)new GridData(550, 300));
        if (this.input instanceof EEFEditorSettings) {
            treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection structuredSelection;
                    if (event.getSelection() instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)event.getSelection()) != null && !structuredSelection.isEmpty()) {
                        Object o = structuredSelection.getFirstElement();
                        Button okButton = TabElementTreeSelectionDialog.this.getButton(0);
                        if (((List)((EEFEditorSettings)TabElementTreeSelectionDialog.this.input).choiceOfValues(TabElementTreeSelectionDialog.this.adapterFactory)).contains(o)) {
                            if (TabElementTreeSelectionDialog.this.input instanceof ReferencesTableSettings) {
                                if (o instanceof EObject && !((ReferencesTableSettings)TabElementTreeSelectionDialog.this.input).contains((EObject)o)) {
                                    TabElementTreeSelectionDialog.this.selection = structuredSelection;
                                    if (okButton != null) {
                                        okButton.setEnabled(true);
                                    }
                                } else if (okButton != null) {
                                    okButton.setEnabled(false);
                                }
                            } else {
                                TabElementTreeSelectionDialog.this.selection = structuredSelection;
                                if (okButton != null) {
                                    okButton.setEnabled(true);
                                }
                            }
                        } else if (okButton != null) {
                            okButton.setEnabled(false);
                        }
                    }
                }
            });
            treeViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (TabElementTreeSelectionDialog.this.selection != null && !TabElementTreeSelectionDialog.this.selection.isEmpty()) {
                        Object o = TabElementTreeSelectionDialog.this.selection.getFirstElement();
                        if (((List)((EEFEditorSettings)TabElementTreeSelectionDialog.this.input).choiceOfValues(TabElementTreeSelectionDialog.this.adapterFactory)).contains(o) && TabElementTreeSelectionDialog.this.input instanceof ReferencesTableSettings && o instanceof EObject && !((ReferencesTableSettings)TabElementTreeSelectionDialog.this.input).contains((EObject)o)) {
                            TabElementTreeSelectionDialog.this.okPressed();
                        }
                    }
                }
            });
        }
        treeViewer.setInput(this.input);
        if (this.selection != null) {
            treeViewer.setSelection((ISelection)this.selection);
        }
        return composite;
    }

    public void setInput(Object input) {
        this.input = input;
        this.refresh();
    }

    public void refresh() {
        this.parent.pack();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(String.valueOf(EEFRuntimeUIMessages.TabElementTreeSelectionDialog_shell_title) + this.title);
    }

    protected void okPressed() {
        if (this.selection != null && !this.selection.isEmpty()) {
            this.process(this.selection);
            ModelViewerHelper.setLastSelection(this.selection);
        }
        super.okPressed();
    }

    public void setSelection(IStructuredSelection selection) {
        this.selection = selection;
    }

    public abstract void process(IStructuredSelection var1);

    @Override
    public void addBusinessRuleFilter(ViewerFilter filter) {
        this.brFilters.add(filter);
    }

    @Override
    public void addFilter(ViewerFilter filter) {
        this.viewerFilters.add(filter);
    }

    @Override
    public void removeBusinessRuleFilter(ViewerFilter filter) {
        this.brFilters.remove(filter);
    }

    @Override
    public void removeFilter(ViewerFilter filter) {
        this.viewerFilters.remove(filter);
    }

    private class TreeSelectionPatternFilter
    extends PatternFilter {
        private TreeSelectionPatternFilter() {
        }

        protected boolean isParentMatch(Viewer viewer, Object element) {
            Object[] children = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren(element);
            if (TabElementTreeSelectionDialog.this.viewerFilters != null && !TabElementTreeSelectionDialog.this.viewerFilters.isEmpty() && children != null) {
                for (ViewerFilter viewerFilter : TabElementTreeSelectionDialog.this.viewerFilters) {
                    Object[] objectArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object child = objectArray[n2];
                        if (viewerFilter.select(viewer, null, child)) {
                            return super.isParentMatch(viewer, element);
                        }
                        ++n2;
                    }
                }
                return false;
            }
            return super.isParentMatch(viewer, element);
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            String labelText;
            if (element instanceof EObject && (labelText = ((EObject)element).toString()) != null) {
                return this.wordMatches(labelText);
            }
            return false;
        }
    }
}

