/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import java.util.HashMap;
import java.util.List;
import org.eclipse.eef.EEFRadioDescription;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EefPackage;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.EEFControllersFactory;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.eef.core.api.controllers.IEEFRadioController;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFWidgetLifecycleManager;
import org.eclipse.eef.ide.ui.internal.widgets.RadioGroup;
import org.eclipse.eef.ide.ui.internal.widgets.RadioGroupViewer;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EEFRadioLifecycleManager
extends AbstractEEFWidgetLifecycleManager {
    private EEFRadioDescription description;
    private RadioGroupViewer radioGroupViewer;
    private RadioGroup radioGroup;
    private IEEFRadioController controller;
    private SelectionListener selectionListener;

    public EEFRadioLifecycleManager(EEFRadioDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        super(variableManager, interpreter, contextAdapter);
        this.description = description;
    }

    @Override
    protected void createMainControl(Composite parent, IEEFFormContainer formContainer) {
        EEFWidgetFactory widgetFactory = formContainer.getWidgetFactory();
        this.radioGroupViewer = new RadioGroupViewer(parent, widgetFactory, this.description.getNumberOfColumns());
        this.radioGroup = this.radioGroupViewer.getRadioGroup();
        GridData gridData = new GridData();
        gridData.horizontalIndent = 5;
        this.radioGroup.setLayoutData(gridData);
        this.radioGroupViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.radioGroupViewer.setLabelProvider((IBaseLabelProvider)new EEFRadioLabelProvider());
        this.radioGroupViewer.setData("FormWidgetFactory.drawBorder", "textBorder");
        widgetFactory.paintBordersFor(parent);
        this.controller = new EEFControllersFactory().createRadioController(this.description, this.variableManager, this.interpreter, this.contextAdapter);
    }

    @Override
    protected IEEFWidgetController getController() {
        return this.controller;
    }

    @Override
    protected EEFWidgetDescription getWidgetDescription() {
        return this.description;
    }

    @Override
    protected Control getValidationControl() {
        return this.radioGroup;
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = EEFRadioLifecycleManager.this.getStructuredSelection((StructuredViewer)EEFRadioLifecycleManager.this.radioGroupViewer);
                Object newValue = selection.getFirstElement();
                EEFRadioLifecycleManager.this.controller.updateValue(newValue);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.radioGroup.addSelectionListener(this.selectionListener);
        this.controller.onNewValue((IConsumer)new IConsumer<Object>(){

            public void apply(Object value) {
                if (!EEFRadioLifecycleManager.this.radioGroup.isDisposed()) {
                    StructuredSelection selection = value != null ? new StructuredSelection(value) : null;
                    EEFRadioLifecycleManager.this.radioGroupViewer.setSelection((ISelection)selection);
                    if (!EEFRadioLifecycleManager.this.radioGroup.isEnabled()) {
                        EEFRadioLifecycleManager.this.radioGroup.setEnabled(true);
                    }
                }
            }
        });
        this.controller.onNewCandidates((IConsumer)new IConsumer<List<Object>>(){

            public void apply(List<Object> candidates) {
                if (!EEFRadioLifecycleManager.this.radioGroup.isDisposed()) {
                    if (candidates != null) {
                        EEFRadioLifecycleManager.this.radioGroupViewer.setInput(candidates.toArray());
                    } else {
                        EEFRadioLifecycleManager.this.radioGroupViewer.setInput(null);
                    }
                    if (!EEFRadioLifecycleManager.this.radioGroup.isEnabled()) {
                        EEFRadioLifecycleManager.this.radioGroup.setEnabled(true);
                    }
                    EEFRadioLifecycleManager.this.radioGroupViewer.refresh(true);
                }
            }
        });
    }

    @Override
    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (!this.radioGroup.isDisposed()) {
            this.radioGroup.removeSelectionListener(this.selectionListener);
        }
        this.controller.removeNewValueConsumer();
        this.controller.removeNewCandidatesConsumer();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.radioGroup.setEnabled(this.isEnabled());
    }

    private final class EEFRadioLabelProvider
    extends LabelProvider {
        private EEFRadioLabelProvider() {
        }

        public String getText(Object element) {
            String expression = EEFRadioLifecycleManager.this.description.getCandidateDisplayExpression();
            EAttribute eAttribute = EefPackage.Literals.EEF_RADIO_DESCRIPTION__CANDIDATE_DISPLAY_EXPRESSION;
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("self", EEFRadioLifecycleManager.this.variableManager.getVariables().get("self"));
            variables.put("candidate", element);
            return (String)EvalFactory.of((IInterpreter)EEFRadioLifecycleManager.this.interpreter, variables).logIfInvalidType(String.class).logIfBlank(eAttribute).evaluate(expression);
        }
    }
}

