/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.properties.ui.legacy.internal.extension.impl;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.eef.properties.ui.legacy.internal.EEFPropertiesUiLegacyPlugin;
import org.eclipse.eef.properties.ui.legacy.internal.Messages;
import org.eclipse.eef.properties.ui.legacy.internal.extension.AbstractRegistryEventListener;
import org.eclipse.eef.properties.ui.legacy.internal.extension.impl.LegacyPropertyTabItemDescriptor;
import org.eclipse.eef.properties.ui.legacy.internal.extension.impl.LegacyPropertyTabRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class LegacyPropertyTabsRegistryEventListener
extends AbstractRegistryEventListener {
    public static final String TAG_PROPERTY_TABS = "propertyTabs";
    public static final String CONTRIBUTOR_ID_ATTR = "contributorId";
    public static final String TAG_PROPERTY_TAB = "propertyTab";
    public static final String LABEL_ATTR = "label";
    public static final String CATEGORY_ATTR = "category";
    public static final String AFTER_TAB_ATTR = "afterTab";
    public static final String ID_ATTR = "id";
    public static final String INDENTED_ATTR = "indented";
    public static final String IMAGE_ATTR = "image";
    private LegacyPropertyTabRegistry propertyTabRegistry;

    public LegacyPropertyTabsRegistryEventListener(String namespace, String extensionPointID, LegacyPropertyTabRegistry itemRegistry) {
        super(namespace, extensionPointID);
        this.propertyTabRegistry = itemRegistry;
    }

    @Override
    protected boolean validateConfigurationElement(IConfigurationElement configurationElement) {
        boolean isValid = false;
        if (TAG_PROPERTY_TABS.equals(configurationElement.getName())) {
            if (!this.isValidAttribute(configurationElement, CONTRIBUTOR_ID_ATTR)) {
                String message = MessageFormat.format(Messages.RegistryEventListener_missingAttribute, configurationElement.getNamespaceIdentifier(), CONTRIBUTOR_ID_ATTR);
                EEFPropertiesUiLegacyPlugin.getImplementation().logError(message, null);
            } else {
                isValid = true;
            }
        } else if (TAG_PROPERTY_TAB.equals(configurationElement.getName())) {
            if (!this.isValidAttribute(configurationElement, LABEL_ATTR)) {
                String message = MessageFormat.format(Messages.RegistryEventListener_missingAttribute, configurationElement.getNamespaceIdentifier(), LABEL_ATTR);
                EEFPropertiesUiLegacyPlugin.getImplementation().logError(message, null);
            } else if (!this.isValidAttribute(configurationElement, CATEGORY_ATTR)) {
                String message = MessageFormat.format(Messages.RegistryEventListener_missingAttribute, configurationElement.getNamespaceIdentifier(), CATEGORY_ATTR);
                EEFPropertiesUiLegacyPlugin.getImplementation().logError(message, null);
            } else if (!this.isValidAttribute(configurationElement, ID_ATTR)) {
                String message = MessageFormat.format(Messages.RegistryEventListener_missingAttribute, configurationElement.getNamespaceIdentifier(), ID_ATTR);
                EEFPropertiesUiLegacyPlugin.getImplementation().logError(message, null);
            } else {
                isValid = true;
            }
        }
        return isValid;
    }

    private boolean isValidAttribute(IConfigurationElement configurationElement, String attributeName) {
        return configurationElement.getAttribute(attributeName) != null && !"".equals(configurationElement.getAttribute(attributeName));
    }

    @Override
    protected boolean processAddition(IConfigurationElement configurationElement) {
        if (TAG_PROPERTY_TAB.equals(configurationElement.getName())) {
            String category = configurationElement.getAttribute(CATEGORY_ATTR);
            String label = configurationElement.getAttribute(LABEL_ATTR);
            String id = configurationElement.getAttribute(ID_ATTR);
            String afterTab = configurationElement.getAttribute(AFTER_TAB_ATTR);
            String indentedString = configurationElement.getAttribute(INDENTED_ATTR);
            boolean indented = indentedString != null && "true".equals(indentedString);
            String imageString = configurationElement.getAttribute(IMAGE_ATTR);
            Image image = null;
            if (imageString != null) {
                image = AbstractUIPlugin.imageDescriptorFromPlugin((String)configurationElement.getDeclaringExtension().getNamespaceIdentifier(), (String)imageString).createImage();
            }
            LegacyPropertyTabItemDescriptor legacyPropertyTab = new LegacyPropertyTabItemDescriptor(label, category, afterTab, id, indented, image);
            this.propertyTabRegistry.add(legacyPropertyTab);
        }
        return true;
    }

    @Override
    protected boolean processRemoval(IConfigurationElement configurationElement) {
        return this.propertyTabRegistry.remove(configurationElement.getAttribute(ID_ATTR)) != null;
    }
}

