/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.properties.ui.legacy.internal.extension.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.eef.properties.ui.api.IEEFTabDescriptor;
import org.eclipse.eef.properties.ui.legacy.internal.EEFPropertiesUiLegacyPlugin;
import org.eclipse.eef.properties.ui.legacy.internal.extension.IItemDescriptor;
import org.eclipse.eef.properties.ui.legacy.internal.extension.IItemRegistry;
import org.eclipse.eef.properties.ui.legacy.internal.extension.impl.LegacyPropertyTabItemDescriptor;

public class LegacyPropertyTabRegistry
implements IItemRegistry {
    private static final String TOP = "top";
    private Multimap<String, IItemDescriptor> id2descriptors = ArrayListMultimap.create();

    public List<IEEFTabDescriptor> getPropertyTabs(String contributorId) {
        List<IEEFTabDescriptor> tabs = this.readTabDescriptors(contributorId);
        List<String> propertyCategories = this.readPropertyCategories();
        List<IEEFTabDescriptor> sortedTabs = this.sortTabDescriptorsByCategory(tabs, propertyCategories);
        sortedTabs = this.sortTabDescriptorsByAfterTab(sortedTabs, propertyCategories);
        return sortedTabs;
    }

    private List<IEEFTabDescriptor> sortTabDescriptorsByCategory(List<IEEFTabDescriptor> tabs, final List<String> propertyCategories) {
        ArrayList<IEEFTabDescriptor> sortedTabs = new ArrayList<IEEFTabDescriptor>(tabs);
        if (propertyCategories != null) {
            Collections.sort(sortedTabs, new Comparator<Object>(){

                @Override
                public int compare(Object arg0, Object arg1) {
                    IEEFTabDescriptor one = (IEEFTabDescriptor)arg0;
                    IEEFTabDescriptor two = (IEEFTabDescriptor)arg1;
                    String categoryOne = one.getCategory();
                    String categoryTwo = two.getCategory();
                    if (categoryOne != null && categoryTwo != null) {
                        int categoryOnePosition = LegacyPropertyTabRegistry.this.getIndex(propertyCategories.toArray(), categoryOne);
                        int categoryTwoPosition = LegacyPropertyTabRegistry.this.getIndex(propertyCategories.toArray(), categoryTwo);
                        return categoryOnePosition - categoryTwoPosition;
                    }
                    return 0;
                }
            });
        }
        return sortedTabs;
    }

    private List<IEEFTabDescriptor> sortTabDescriptorsByAfterTab(List<IEEFTabDescriptor> tabs, List<String> propertyCategories) {
        if (tabs.size() == 0 || propertyCategories == null) {
            return tabs;
        }
        ArrayList<IEEFTabDescriptor> sorted = new ArrayList<IEEFTabDescriptor>();
        int categoryIndex = 0;
        int i = 0;
        while (i < propertyCategories.size()) {
            ArrayList<IEEFTabDescriptor> categoryList = new ArrayList<IEEFTabDescriptor>();
            String category = propertyCategories.get(i);
            int topOfCategory = categoryIndex;
            int endOfCategory = categoryIndex;
            while (endOfCategory < tabs.size() && tabs.get(endOfCategory).getCategory().equals(category)) {
                ++endOfCategory;
            }
            int j = topOfCategory;
            while (j < endOfCategory) {
                IEEFTabDescriptor tab = tabs.get(j);
                if (tab.getAfterTab().equals(TOP)) {
                    categoryList.add(0, tabs.get(j));
                } else {
                    categoryList.add(tabs.get(j));
                }
                ++j;
            }
            List<IEEFTabDescriptor> sortedTabs = this.sortCategoryTabsByAfterTab(categoryList);
            int j2 = 0;
            while (j2 < sortedTabs.size()) {
                sorted.add(sortedTabs.get(j2));
                ++j2;
            }
            categoryIndex = endOfCategory;
            ++i;
        }
        return sorted;
    }

    private List<IEEFTabDescriptor> sortCategoryTabsByAfterTab(List<IEEFTabDescriptor> categoryList) {
        LinkedList<IEEFTabDescriptor> sorted = new LinkedList<IEEFTabDescriptor>();
        for (IEEFTabDescriptor tab : categoryList) {
            IEEFTabDescriptor afterTab;
            String afterTabId = tab.getAfterTab();
            int indexOfAfterTab = -1;
            if (afterTabId != null && !afterTabId.isEmpty() && (afterTab = this.getTab(categoryList, afterTabId)) != null) {
                indexOfAfterTab = sorted.indexOf(afterTab);
            }
            sorted.add(indexOfAfterTab + 1, tab);
        }
        return sorted;
    }

    private IEEFTabDescriptor getTab(List<IEEFTabDescriptor> tabs, String tabId) {
        for (IEEFTabDescriptor tab : tabs) {
            if (!tabId.equals(tab.getId())) continue;
            return tab;
        }
        return null;
    }

    private int getIndex(Object[] array, Object target) {
        int i = 0;
        while (i < array.length) {
            if (target != null && array[i] != null && array[i].equals(target)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private List<String> readPropertyCategories() {
        return EEFPropertiesUiLegacyPlugin.getImplementation().getTabbedPropertyContributorRegistry().getPropertyCategories();
    }

    private List<IEEFTabDescriptor> readTabDescriptors(String contributorId) {
        ArrayList<IEEFTabDescriptor> eefTabDescriptors = new ArrayList<IEEFTabDescriptor>();
        Collection values = this.id2descriptors.values();
        for (IItemDescriptor itemDescriptor : values) {
            LegacyPropertyTabItemDescriptor eefTabDescriptor;
            String eefTabContributorId;
            if (!(itemDescriptor instanceof LegacyPropertyTabItemDescriptor) || (eefTabContributorId = (eefTabDescriptor = (LegacyPropertyTabItemDescriptor)itemDescriptor).getContributorId()) == null || !eefTabContributorId.equals(contributorId)) continue;
            eefTabDescriptors.add((IEEFTabDescriptor)eefTabDescriptor);
        }
        return eefTabDescriptors;
    }

    @Override
    public IItemDescriptor add(IItemDescriptor descriptor) {
        boolean result = this.id2descriptors.put((Object)descriptor.getId(), (Object)descriptor);
        if (result) {
            return descriptor;
        }
        return null;
    }

    @Override
    public boolean remove(String id) {
        return !this.id2descriptors.removeAll((Object)id).isEmpty();
    }

    @Override
    public void clear() {
        this.id2descriptors.clear();
    }
}

