/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.EEFTextDescription;
import org.eclipse.eef.EEFTextStyle;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EEFWidgetStyle;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.EEFControllersFactory;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.eef.core.api.controllers.IEEFTextController;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.eef.ide.internal.EEFIdePlugin;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFWidgetLifecycleManager;
import org.eclipse.eef.ide.ui.api.widgets.EEFStyleHelper;
import org.eclipse.eef.ide.ui.internal.widgets.EEFStyledTextStyleCallback;
import org.eclipse.eef.ide.ui.internal.widgets.styles.EEFColor;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EEFTextLifecycleManager
extends AbstractEEFWidgetLifecycleManager {
    private static final int TEXT_AREA_WIDTH_HINT = 300;
    private EEFTextDescription description;
    private StyledText text;
    private IEEFTextController controller;
    private FocusListener focusListener;
    private KeyListener keyListener;
    private EEFWidgetFactory widgetFactory;
    private Color defaultBackgroundColor;
    private ModifyListener modifyListener;
    private AtomicBoolean updateInProgress = new AtomicBoolean(false);
    private String referenceValue = "";
    private boolean isDirty;

    public EEFTextLifecycleManager(EEFTextDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        super(variableManager, interpreter, contextAdapter);
        this.description = description;
    }

    @Override
    protected void createMainControl(Composite parent, IEEFFormContainer formContainer) {
        this.widgetFactory = formContainer.getWidgetFactory();
        this.defaultBackgroundColor = parent.getBackground();
        int lineCount = this.description.getLineCount();
        if (lineCount > 1) {
            this.text = this.widgetFactory.createStyledText(parent, 834);
            GridData gridData = new GridData(4, 1, true, false);
            gridData.heightHint = lineCount * this.text.getLineHeight();
            gridData.widthHint = 300;
            gridData.horizontalIndent = 5;
            this.text.setLayoutData((Object)gridData);
        } else {
            this.text = this.widgetFactory.createStyledText(parent, 4);
            GridData gridData = new GridData(4, 0x1000000, true, false);
            gridData.horizontalIndent = 5;
            this.text.setLayoutData((Object)gridData);
        }
        this.text.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.widgetFactory.paintBordersFor(parent);
        this.controller = new EEFControllersFactory().createTextController(this.description, this.variableManager, this.interpreter, this.contextAdapter);
    }

    @Override
    protected int getLabelVerticalAlignment() {
        if (this.description.getLineCount() > 1) {
            return 2;
        }
        return 4;
    }

    @Override
    protected IEEFWidgetController getController() {
        return this.controller;
    }

    @Override
    protected EEFWidgetDescription getWidgetDescription() {
        return this.description;
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!EEFTextLifecycleManager.this.container.isRenderingInProgress() && !EEFTextLifecycleManager.this.updateInProgress.get()) {
                    EEFTextLifecycleManager.this.isDirty = true;
                }
            }
        };
        this.text.addModifyListener(this.modifyListener);
        this.focusListener = new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (!EEFTextLifecycleManager.this.container.isRenderingInProgress() && EEFTextLifecycleManager.this.isDirty) {
                    EEFTextLifecycleManager.this.updateValue();
                }
            }

            public void focusGained(FocusEvent e) {
            }
        };
        this.text.addFocusListener(this.focusListener);
        if (this.description.getLineCount() <= 1) {
            this.keyListener = new KeyListener(){

                public void keyReleased(KeyEvent e) {
                    if (e.character == '\r' || e.character == '\n') {
                        EEFTextLifecycleManager.this.updateValue();
                    }
                }

                public void keyPressed(KeyEvent e) {
                }
            };
            this.text.addKeyListener(this.keyListener);
        }
        this.controller.onNewValue((IConsumer)new IConsumer<Object>(){

            public void apply(Object value) {
                if (!EEFTextLifecycleManager.this.text.isDisposed()) {
                    if (!(value == null || EEFTextLifecycleManager.this.text.getText() != null && EEFTextLifecycleManager.this.text.getText().equals(value.toString()))) {
                        EEFTextLifecycleManager.this.text.setText(Util.firstNonNull((String[])new String[]{value.toString(), ""}));
                        EEFTextLifecycleManager.this.referenceValue = EEFTextLifecycleManager.this.text.getText();
                    }
                    EEFTextLifecycleManager.this.setStyle();
                    if (!EEFTextLifecycleManager.this.text.isEnabled()) {
                        EEFTextLifecycleManager.this.text.setEnabled(true);
                    }
                }
            }
        });
    }

    private void updateValue() {
        if (!this.text.isDisposed() && this.isDirty && !this.container.isRenderingInProgress() && this.updateInProgress.compareAndSet(false, true)) {
            try {
                IStatus result = this.controller.updateValue(this.text.getText());
                if (result != null && result.getSeverity() == 4) {
                    EEFIdePlugin.INSTANCE.log((Object)result);
                    this.text.setText(this.referenceValue);
                } else {
                    this.referenceValue = this.text.getText();
                }
                this.isDirty = false;
                this.setStyle();
            }
            finally {
                this.updateInProgress.set(false);
            }
        }
    }

    private void setStyle() {
        EEFStyleHelper styleHelper = new EEFStyleHelper(this.interpreter, this.variableManager);
        EEFWidgetStyle widgetStyle = styleHelper.getWidgetStyle((EEFWidgetDescription)this.description);
        if (widgetStyle instanceof EEFTextStyle) {
            EEFTextStyle textStyle = (EEFTextStyle)widgetStyle;
            EEFStyledTextStyleCallback callback = new EEFStyledTextStyleCallback(this.text);
            styleHelper.applyTextStyle(textStyle.getFontNameExpression(), textStyle.getFontSizeExpression(), textStyle.getFontStyleExpression(), this.text.getFont(), textStyle.getBackgroundColorExpression(), textStyle.getForegroundColorExpression(), callback);
        }
    }

    @Override
    protected Control getValidationControl() {
        return this.text;
    }

    @Override
    public void aboutToBeHidden() {
        if (this.isDirty) {
            this.updateValue();
        }
        super.aboutToBeHidden();
        if (!this.text.isDisposed()) {
            this.text.removeFocusListener(this.focusListener);
        }
        this.controller.removeNewValueConsumer();
        if (!this.text.isDisposed()) {
            this.text.removeModifyListener(this.modifyListener);
        }
        if (!this.text.isDisposed() && this.description.getLineCount() <= 1) {
            this.text.removeKeyListener(this.keyListener);
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.text.setEnabled(this.isEnabled());
        this.text.setBackground(this.getBackgroundColor());
    }

    private Color getBackgroundColor() {
        Color color = this.defaultBackgroundColor;
        if (!this.isEnabled()) {
            color = this.widgetFactory.getColors().getInactiveBackground();
        } else {
            EEFTextStyle style;
            String backgroundColorCode;
            EEFWidgetStyle widgetStyle = new EEFStyleHelper(this.interpreter, this.variableManager).getWidgetStyle((EEFWidgetDescription)this.description);
            if (widgetStyle instanceof EEFTextStyle && !Util.isBlank((String)(backgroundColorCode = (style = (EEFTextStyle)widgetStyle).getBackgroundColorExpression()))) {
                EEFColor backgroundColor = new EEFColor(backgroundColorCode);
                color = backgroundColor.getColor();
            }
        }
        return color;
    }
}

