/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.properties.ui.legacy.internal.extension.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.eef.properties.ui.api.AbstractEEFSectionDescriptor;
import org.eclipse.eef.properties.ui.api.IEEFSection;
import org.eclipse.eef.properties.ui.api.IEEFTypeMapper;
import org.eclipse.eef.properties.ui.legacy.internal.EEFPropertiesUiLegacyPlugin;
import org.eclipse.eef.properties.ui.legacy.internal.Messages;
import org.eclipse.eef.properties.ui.legacy.internal.extension.IItemDescriptor;
import org.eclipse.eef.properties.ui.legacy.internal.legacy2eef.EEFLegacySection;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptor;

public class LegacyPropertySectionItemDescriptor
extends AbstractEEFSectionDescriptor
implements IItemDescriptor {
    private IConfigurationElement configurationElement;
    private ISectionDescriptor sectionDescriptor;

    public LegacyPropertySectionItemDescriptor(IConfigurationElement configurationElement, IEEFTypeMapper typeMapper) {
        super(typeMapper);
        this.configurationElement = configurationElement;
    }

    public LegacyPropertySectionItemDescriptor(ISectionDescriptor sectionDescriptor, IEEFTypeMapper typeMapper) {
        super(typeMapper);
        this.sectionDescriptor = sectionDescriptor;
    }

    @Override
    public String getId() {
        String id = null;
        if (this.configurationElement != null) {
            id = this.configurationElement.getAttribute("id");
        } else if (this.sectionDescriptor != null) {
            id = this.sectionDescriptor.getId();
        }
        return id;
    }

    public IEEFSection getSectionClass() {
        ISection section = null;
        if (this.configurationElement != null && this.configurationElement.getAttribute("class") != null) {
            try {
                section = (ISection)this.configurationElement.createExecutableExtension("class");
            }
            catch (CoreException e) {
                String message = MessageFormat.format(Messages.RegistryEventListener_cannotInstantiateExtension, this.getId());
                EEFPropertiesUiLegacyPlugin.getImplementation().logError(message, (Exception)((Object)e));
            }
        } else if (this.sectionDescriptor != null) {
            section = this.sectionDescriptor.getSectionClass();
        }
        if (section != null) {
            return new EEFLegacySection(section);
        }
        return null;
    }

    public String getTargetTab() {
        String tab = null;
        if (this.configurationElement != null) {
            tab = this.configurationElement.getAttribute("tab");
        } else if (this.sectionDescriptor != null) {
            tab = this.sectionDescriptor.getTargetTab();
        }
        return tab;
    }

    public IFilter getFilter() {
        IFilter filter = null;
        if (this.configurationElement != null && this.configurationElement.getAttribute("filter") != null) {
            try {
                filter = (IFilter)this.configurationElement.createExecutableExtension("filter");
            }
            catch (CoreException e) {
                String message = MessageFormat.format(Messages.RegistryEventListener_cannotInstantiateExtension, this.getId());
                EEFPropertiesUiLegacyPlugin.getImplementation().logError(message, (Exception)((Object)e));
            }
        } else if (this.sectionDescriptor != null) {
            filter = this.sectionDescriptor.getFilter();
        }
        return filter;
    }

    public String getAfterSection() {
        String section = null;
        if (this.configurationElement != null) {
            section = this.configurationElement.getAttribute("afterSection");
        } else if (this.sectionDescriptor != null) {
            section = this.sectionDescriptor.getAfterSection();
        }
        return section;
    }

    public int getEnablesFor() {
        int enablesFor = -1;
        if (this.configurationElement != null && this.configurationElement.getAttribute("enablesFor") != null) {
            String enablesForStr = this.configurationElement.getAttribute("enablesFor");
            int enablesForTest = Integer.parseInt(enablesForStr);
            if (enablesForTest > 0) {
                enablesFor = enablesForTest;
            }
        } else if (this.sectionDescriptor != null) {
            enablesFor = this.sectionDescriptor.getEnablesFor();
        }
        return enablesFor;
    }

    public List<String> getInputTypes() {
        List<String> inputTypes = new ArrayList<String>();
        if (this.configurationElement != null) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = this.configurationElement.getChildren("input");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                String type = element.getAttribute("type");
                if (type != null && !type.isEmpty()) {
                    inputTypes.add(type);
                }
                ++n2;
            }
        } else if (this.sectionDescriptor != null) {
            inputTypes = this.sectionDescriptor.getInputTypes();
        }
        return inputTypes;
    }
}

