/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.properties.ui.legacy.internal.extension.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.eef.properties.ui.legacy.internal.extension.IItemDescriptor;
import org.eclipse.eef.properties.ui.legacy.internal.extension.IItemRegistry;
import org.eclipse.eef.properties.ui.legacy.internal.extension.impl.LegacyPropertyContributorItemDescriptor;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptorProvider;
import org.eclipse.ui.views.properties.tabbed.ITypeMapper;

public class LegacyPropertyContributorRegistry
implements IItemRegistry {
    private Multimap<String, IItemDescriptor> id2descriptors = ArrayListMultimap.create();

    public List<String> getPropertyCategories() {
        ArrayList<String> legacyPropertyCategories = new ArrayList<String>();
        Collection values = this.id2descriptors.values();
        for (IItemDescriptor itemDescriptor : values) {
            if (!(itemDescriptor instanceof LegacyPropertyContributorItemDescriptor)) continue;
            legacyPropertyCategories.addAll(((LegacyPropertyContributorItemDescriptor)itemDescriptor).getCategories());
        }
        return legacyPropertyCategories;
    }

    public ITypeMapper getTypeMapper(String contributorId) {
        Collection values = this.id2descriptors.values();
        for (IItemDescriptor itemDescriptor : values) {
            ITypeMapper legacyPropertyTypeMapper;
            if (!(itemDescriptor instanceof LegacyPropertyContributorItemDescriptor) || contributorId == null || !contributorId.equals(itemDescriptor.getId()) || (legacyPropertyTypeMapper = ((LegacyPropertyContributorItemDescriptor)itemDescriptor).getTypeMapper()) == null) continue;
            return legacyPropertyTypeMapper;
        }
        return null;
    }

    public ISectionDescriptorProvider getSectionDescriptorProvider(String contributorId) {
        Collection values = this.id2descriptors.values();
        for (IItemDescriptor itemDescriptor : values) {
            ISectionDescriptorProvider legacyPropertySectionDescriptorProvider;
            if (!(itemDescriptor instanceof LegacyPropertyContributorItemDescriptor) || contributorId == null || !contributorId.equals(itemDescriptor.getId()) || (legacyPropertySectionDescriptorProvider = ((LegacyPropertyContributorItemDescriptor)itemDescriptor).getSectionDescriptorProvider()) == null) continue;
            return legacyPropertySectionDescriptorProvider;
        }
        return null;
    }

    @Override
    public IItemDescriptor add(IItemDescriptor itemDescriptor) {
        boolean result = this.id2descriptors.put((Object)itemDescriptor.getId(), (Object)itemDescriptor);
        if (result) {
            return itemDescriptor;
        }
        return null;
    }

    @Override
    public void clear() {
        this.id2descriptors.clear();
    }

    @Override
    public boolean remove(String id) {
        return !this.id2descriptors.removeAll((Object)id).isEmpty();
    }
}

