/*******************************************************************************
 * Copyright (c) 2009 itemis AG (http://www.itemis.eu) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package org.eclipse.emf.emfindex.query;

import java.util.Iterator;

import org.eclipse.emf.emfindex.ContainerDescriptor;
import org.eclipse.emf.emfindex.MemoryIndexImpl;
import org.eclipse.emf.emfindex.ResourceDescriptor;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;

/**
 * A strategy for executing the base queries.
 * 
 * @author koehnlein
 */
public class ResourceQueryExecutorStrategyImpl extends
		AbstractBaseQueryExecutorStrategy<ResourceDescriptor, ResourceDescriptorQuery, MemoryIndexImpl> {

	public boolean canExecute(ResourceDescriptorQuery query, MemoryIndexImpl index) {
		return true;
	}

	public QueryResult<ResourceDescriptor> execute(final ResourceDescriptorQuery query, final MemoryIndexImpl index) {
		return new LazyQueryResultImpl<ResourceDescriptor>(new Iterable<ResourceDescriptor>() {
			public Iterator<ResourceDescriptor> iterator() {
				return getResult(query, index);
			}
		});
	}

	public Iterator<ResourceDescriptor> getResult(final ResourceDescriptorQuery query, final MemoryIndexImpl index) {
		Iterator<? extends ContainerDescriptor> containerDescriptors;
		if (query.getContainerQuery() != null) {
			containerDescriptors = index.getQueryExecutor().execute(query.getContainerQuery()).iterator();
		} else {
			containerDescriptors = index.allContainerDescriptors();
		}
		Iterator<ResourceDescriptor> scope = null;
		if (!containerDescriptors.hasNext()) {
			scope = index.allResourceDescriptors();
		} else {
			do {
				ContainerDescriptor containerDescriptor = containerDescriptors.next();
				Iterator<ResourceDescriptor> resourcesInContainer = containerDescriptor.getResourceDescriptors().iterator();
				scope = (scope == null) ? resourcesInContainer : Iterators.concat(scope,
						resourcesInContainer);
			} while(containerDescriptors.hasNext());
		}
		if (scope == null) {
			return Iterators.<ResourceDescriptor> emptyIterator();
		}
		return Iterators.filter(scope, new Predicate<ResourceDescriptor>() {
			public boolean apply(ResourceDescriptor candidate) {
				return match(query, candidate);
			}
		});
	}

	@Override
	protected boolean internalMatch(ResourceDescriptorQuery query, ResourceDescriptor candidate) {
		return query.getIndexedVersionAfter() < candidate.getIndexedVersion()
		&& query.getIndexedVersionBefore() > candidate.getIndexedVersion()
		&& (query.getURI() == null || query.getURI().equals(candidate.getURI())) 
		&& (query.getURINotIn().isEmpty() || !query.getURINotIn().contains(candidate.getURI()));
	}
}
