/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Collections2;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImmutableSet<E>
extends ImmutableCollection<E>
implements Set<E> {
    private static final ImmutableSet<?> EMPTY_IMMUTABLE_SET = new EmptyImmutableSet();

    public static <E> ImmutableSet<E> of() {
        return EMPTY_IMMUTABLE_SET;
    }

    public static <E> ImmutableSet<E> of(E element) {
        return new SingletonImmutableSet<E>(element, element.hashCode());
    }

    public static <E> ImmutableSet<E> of(E ... elements) {
        switch (elements.length) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                return ImmutableSet.of(elements[0]);
            }
        }
        return ImmutableSet.create(Arrays.asList(elements), elements.length);
    }

    public static <E> ImmutableSet<E> copyOf(Iterable<? extends E> elements) {
        if (elements instanceof ImmutableSet) {
            ImmutableSet set = (ImmutableSet)elements;
            return set;
        }
        return ImmutableSet.copyOfInternal(Collections2.toCollection(elements));
    }

    public static <E> ImmutableSet<E> copyOf(Iterator<? extends E> elements) {
        ArrayList<? extends E> list = Lists.newArrayList(elements);
        return ImmutableSet.copyOfInternal(list);
    }

    private static <E> ImmutableSet<E> copyOfInternal(Collection<? extends E> collection) {
        switch (collection.size()) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                return ImmutableSet.of(collection.iterator().next());
            }
        }
        return ImmutableSet.create(collection, collection.size());
    }

    ImmutableSet() {
    }

    boolean isHashCodeFast() {
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableSet && this.isHashCodeFast() && ((ImmutableSet)object).isHashCodeFast() && this.hashCode() != object.hashCode()) {
            return false;
        }
        if (object instanceof Set) {
            Set that = (Set)object;
            return this.size() == that.size() && this.containsAll(that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        Iterator iterator = this.iterator();
        StringBuilder result = new StringBuilder(this.size() * 16);
        result.append('[').append(iterator.next().toString());
        int i = 1;
        while (i < this.size()) {
            result.append(", ").append(iterator.next().toString());
            ++i;
        }
        return result.append(']').toString();
    }

    private static <E> ImmutableSet<E> create(Iterable<? extends E> iterable, int count) {
        int tableSize = Hashing.chooseTableSize(count);
        Object[] table = new Object[tableSize];
        int mask = tableSize - 1;
        ArrayList<E> elements = new ArrayList<E>(count);
        int hashCode = 0;
        block0: for (E element : iterable) {
            int hash = element.hashCode();
            int i = Hashing.smear(hash);
            while (true) {
                int index;
                Object value;
                if ((value = table[index = i & mask]) == null) {
                    table[index] = element;
                    elements.add(element);
                    hashCode += hash;
                    continue block0;
                }
                if (value.equals(element)) continue block0;
                ++i;
            }
        }
        return elements.size() == 1 ? new SingletonImmutableSet(elements.get(0), hashCode) : new RegularImmutableSet(elements.toArray(), hashCode, table, mask);
    }

    @Override
    Object writeReplace() {
        return new SerializedForm(this.toArray());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ArrayImmutableSet<E>
    extends ImmutableSet<E> {
        final Object[] elements;

        ArrayImmutableSet(Object[] elements) {
            this.elements = elements;
        }

        @Override
        public int size() {
            return this.elements.length;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return Iterators.forArray(this.elements);
        }

        @Override
        public Object[] toArray() {
            Object[] array = new Object[this.size()];
            System.arraycopy(this.elements, 0, array, 0, this.size());
            return array;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            int size = this.size();
            if (array.length < size) {
                array = ObjectArrays.newArray(array, size);
            } else if (array.length > size) {
                array[size] = null;
            }
            System.arraycopy(this.elements, 0, array, 0, size);
            return array;
        }

        @Override
        public boolean containsAll(Collection<?> targets) {
            if (targets == this) {
                return true;
            }
            if (!(targets instanceof ArrayImmutableSet)) {
                return super.containsAll(targets);
            }
            if (targets.size() > this.size()) {
                return false;
            }
            Object[] objectArray = ((ArrayImmutableSet)targets).elements;
            int n = ((ArrayImmutableSet)targets).elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object target = objectArray[n2];
                if (!this.contains(target)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptyImmutableSet
    extends ImmutableSet<Object> {
        private EmptyImmutableSet() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object target) {
            return false;
        }

        @Override
        public Iterator<Object> iterator() {
            return Iterators.emptyIterator();
        }

        @Override
        public Object[] toArray() {
            return ObjectArrays.EMPTY_ARRAY;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        public boolean containsAll(Collection<?> targets) {
            return targets.isEmpty();
        }

        @Override
        public boolean equals(Object object) {
            return object == this || object instanceof Set && ((Set)object).isEmpty();
        }

        @Override
        public final int hashCode() {
            return 0;
        }

        @Override
        boolean isHashCodeFast() {
            return true;
        }

        @Override
        public String toString() {
            return "[]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RegularImmutableSet<E>
    extends ArrayImmutableSet<E> {
        final Object[] table;
        final int mask;
        final int hashCode;

        RegularImmutableSet(Object[] elements, int hashCode, Object[] table, int mask) {
            super(elements);
            this.table = table;
            this.mask = mask;
            this.hashCode = hashCode;
        }

        @Override
        public boolean contains(Object target) {
            if (target == null) {
                return false;
            }
            int i = Hashing.smear(target.hashCode());
            Object candidate;
            while ((candidate = this.table[i & this.mask]) != null) {
                if (candidate.equals(target)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        boolean isHashCodeFast() {
            return true;
        }
    }

    private static class SerializedForm
    implements Serializable {
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        SerializedForm(Object[] elements) {
            this.elements = elements;
        }

        Object readResolve() {
            return ImmutableSet.of(this.elements);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SingletonImmutableSet<E>
    extends ImmutableSet<E> {
        final E element;
        final int hashCode;

        SingletonImmutableSet(E element, int hashCode) {
            this.element = element;
            this.hashCode = hashCode;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object target) {
            return this.element.equals(target);
        }

        @Override
        public Iterator<E> iterator() {
            return Iterators.singletonIterator(this.element);
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.element};
        }

        @Override
        public <T> T[] toArray(T[] array) {
            if (array.length == 0) {
                array = ObjectArrays.newArray(array, 1);
            } else if (array.length > 1) {
                array[1] = null;
            }
            array[0] = this.element;
            return array;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Set) {
                Set set = (Set)object;
                return set.size() == 1 && this.contains(set.iterator().next());
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return this.hashCode;
        }

        @Override
        boolean isHashCodeFast() {
            return true;
        }

        @Override
        public String toString() {
            String elementToString = this.element.toString();
            return new StringBuilder(elementToString.length() + 2).append('[').append(elementToString).append(']').toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class TransformedImmutableSet<D, E>
    extends ImmutableSet<E> {
        final D[] source;
        final int hashCode;

        TransformedImmutableSet(D[] source, int hashCode) {
            this.source = source;
            this.hashCode = hashCode;
        }

        abstract E transform(D var1);

        @Override
        public int size() {
            return this.source.length;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return new AbstractIterator<E>(){
                int index = 0;

                @Override
                protected E computeNext() {
                    return this.index < TransformedImmutableSet.this.source.length ? TransformedImmutableSet.this.transform(TransformedImmutableSet.this.source[this.index++]) : this.endOfData();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.size()]);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            int size = this.size();
            if (array.length < size) {
                array = ObjectArrays.newArray(array, size);
            } else if (array.length > size) {
                array[size] = null;
            }
            int i = 0;
            while (i < this.source.length) {
                array[i] = this.transform(this.source[i]);
                ++i;
            }
            return array;
        }

        @Override
        public final int hashCode() {
            return this.hashCode;
        }

        @Override
        boolean isHashCodeFast() {
            return true;
        }
    }
}

