/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfindex;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.emfindex.IndexAdapter;
import org.eclipse.emf.emfindex.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeIndexAdapter
extends EContentAdapter {
    private List<IndexAdapter> indexAdapters = new ArrayList<IndexAdapter>();
    private boolean isActive = true;
    @Inject
    private Logger logger;

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (this.isActive) {
            for (IndexAdapter cachedScope : this.indexAdapters) {
                cachedScope.notifyChanged(notification);
            }
        }
    }

    public <T extends IndexAdapter> T indexAdapter(Class<T> adapterClass) {
        for (IndexAdapter registeredAdapters : this.indexAdapters) {
            if (!registeredAdapters.getClass().equals(adapterClass)) continue;
            return (T)registeredAdapters;
        }
        try {
            IndexAdapter newIndexAdapter = (IndexAdapter)adapterClass.newInstance();
            this.indexAdapters.add(newIndexAdapter);
            return (T)newIndexAdapter;
        }
        catch (Exception e) {
            this.logger.logError("Error instantiating IndexAdapter", e);
            return null;
        }
    }

    public void clear() {
        for (IndexAdapter indexCache : this.indexAdapters) {
            indexCache.clear();
        }
    }
}

