/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfindex;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.emfindex.CompositeIndexAdapter;
import org.eclipse.emf.emfindex.ContainerDescriptor;
import org.eclipse.emf.emfindex.ContainerDescriptorIterator;
import org.eclipse.emf.emfindex.EObjectDescriptor;
import org.eclipse.emf.emfindex.EObjectDescriptorIterator;
import org.eclipse.emf.emfindex.EReferenceDescriptor;
import org.eclipse.emf.emfindex.EReferenceDescriptorIterator;
import org.eclipse.emf.emfindex.EmfIndexPlugin;
import org.eclipse.emf.emfindex.IndexAdapter;
import org.eclipse.emf.emfindex.ResourceDescriptor;
import org.eclipse.emf.emfindex.ResourceDescriptorIterable;
import org.eclipse.emf.emfindex.ecore.BufferedBinaryResourceFactory;
import org.eclipse.emf.emfindex.query.QueryCommand;
import org.eclipse.emf.emfindex.query.QueryExecutor;
import org.eclipse.emf.emfindex.store.IndexUpdater;
import org.eclipse.emf.emfindex.store.UpdateCommand;
import org.eclipse.emf.emfindex.store.UpdateableIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class MemoryIndexImpl
implements UpdateableIndex {
    private static final String INDEX_RESOURCE_URI_EXTENSION = "idx";
    private QueryExecutor queryExecutor;
    private IndexUpdater indexUpdater;
    private ResourceSet resourceSet = new ResourceSetImpl();
    private CompositeIndexAdapter compositeAdapter;
    private ReadWriteLock lock;
    private List<URI> deletedResources = new ArrayList<URI>();
    private int resourceCount = 0;

    public MemoryIndexImpl() {
        this.compositeAdapter = new CompositeIndexAdapter();
        this.resourceSet.eAdapters().add((Object)this.compositeAdapter);
        this.lock = new ReentrantReadWriteLock();
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(INDEX_RESOURCE_URI_EXTENSION, new BufferedBinaryResourceFactory());
    }

    public <T> T executeUpdateCommand(UpdateCommand<T> updateCommand) {
        try {
            this.lock.writeLock().lock();
            Object object = updateCommand.execute(this.indexUpdater, this.queryExecutor);
            return (T)object;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public <T> T executeQueryCommand(QueryCommand<T> queryCommand) {
        try {
            this.lock.readLock().lock();
            Object object = queryCommand.execute(this.queryExecutor);
            return (T)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void load() throws IOException {
        this.lock.writeLock().lock();
        try {
            try {
                File[] indexFiles;
                this.compositeAdapter.setActive(false);
                this.resourceSet.getResources().clear();
                this.compositeAdapter.clear();
                this.compositeAdapter.setActive(true);
                File baseDirectory = EmfIndexPlugin.getBaseDirectory();
                final Pattern fileNamePattern = Pattern.compile("\\d*.idx");
                File[] fileArray = indexFiles = baseDirectory.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return fileNamePattern.matcher(name).matches();
                    }
                });
                int n = indexFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File indexFile = fileArray[n2];
                    URI fileURI = URI.createFileURI((String)indexFile.getAbsolutePath());
                    this.resourceSet.getResource(fileURI, true);
                    indexFile.delete();
                    ++n2;
                }
            }
            catch (RuntimeException e) {
                this.resourceSet.getResources().clear();
                throw e;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void save() throws IOException {
        this.lock.readLock().lock();
        try {
            for (Resource resource : this.resourceSet.getResources()) {
                if (!resource.isModified()) continue;
                resource.save(null);
            }
            for (URI deletedReosurceURI : this.deletedResources) {
                this.resourceSet.getURIConverter().delete(deletedReosurceURI, null);
            }
            this.deletedResources.clear();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public <T extends IndexAdapter> T indexAdapter(Class<T> adapterClass) {
        return this.compositeAdapter.indexAdapter(adapterClass);
    }

    public Iterator<ContainerDescriptor> allContainerDescriptors() {
        return new ContainerDescriptorIterator((Iterable<?>)this.resourceSet.getResources());
    }

    public Iterator<ResourceDescriptor> allResourceDescriptors() {
        return new ResourceDescriptorIterable((Iterable<?>)this.resourceSet.getResources());
    }

    public Iterator<EObjectDescriptor> allEObjectDescriptors() {
        return new EObjectDescriptorIterator((Iterable<?>)this.resourceSet.getResources());
    }

    public Iterator<EReferenceDescriptor> allEReferenceDescriptors() {
        return new EReferenceDescriptorIterator((Iterable<?>)this.resourceSet.getResources());
    }

    public QueryExecutor getQueryExecutor() {
        return this.queryExecutor;
    }

    public Resource createResource() {
        URI uri = this.createURI();
        Resource newResource = this.resourceSet.createResource(uri);
        newResource.setModified(true);
        return newResource;
    }

    public void deleteResource(Resource resource) {
        this.resourceSet.getResources().remove((Object)resource);
        this.deletedResources.add(resource.getURI());
    }

    private URI createURI() {
        return EmfIndexPlugin.getBaseDirectoryURI().appendSegment(this.resourceCount++ + "." + INDEX_RESOURCE_URI_EXTENSION);
    }

    @Inject
    public void setIndexUpdater(IndexUpdater indexUpdater) {
        this.indexUpdater = indexUpdater;
    }

    @Inject
    public void setQueryExecutor(QueryExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
    }
}

