/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfindex.store;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.emfindex.store.IndexUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceIndexer {
    public void resourceChanged(URI resourceURI, IndexUpdater updater) {
        Resource resource = this.loadResource(resourceURI);
        this.resourceChanged(resource, updater);
    }

    public void resourceChanged(Resource resource, IndexUpdater updater) {
        URIConverter uriConverter = this.getURIConverter(resource);
        URI normalizedURI = uriConverter.normalize(resource.getURI());
        this.createResourceDescriptor(resource, updater, normalizedURI, uriConverter);
        this.createEObjectDescriptors(resource, updater, normalizedURI, uriConverter);
        this.createEReferenceDescriptors(resource, updater, normalizedURI, uriConverter);
    }

    public void resourceDeleted(URI resourceURI, IndexUpdater updater) {
        updater.deleteResource(resourceURI);
    }

    public void createResourceDescriptor(Resource resource, IndexUpdater updater, URI resourceURI, URIConverter uriConverter) {
        updater.deleteResource(resourceURI);
        updater.createOrUpdateResource(null, resourceURI, System.currentTimeMillis(), this.userData(resource));
    }

    public void createEObjectDescriptors(Resource resource, IndexUpdater updater, URI resourceURI, URIConverter uriConverter) {
        this.recursivelyCreateEObjectDescriptors(resource, (EList<EObject>)resource.getContents(), updater, resourceURI);
    }

    public void createEReferenceDescriptors(Resource resource, IndexUpdater updater, URI resourceURI, URIConverter uriConverter) {
        this.recursivelyCreateEReferenceDescriptors(resource, (EList<EObject>)resource.getContents(), updater, uriConverter, resourceURI);
    }

    protected Resource loadResource(URI resourceURI) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        return resourceSet.getResource(resourceURI, true);
    }

    private void recursivelyCreateEObjectDescriptors(Resource resource, EList<EObject> contents, IndexUpdater updater, URI resourceURI) {
        for (EObject eObject : contents) {
            if (this.isIndexElement(eObject, resource)) {
                String fragment = resource.getURIFragment(eObject);
                String name = this.getEObjectName(eObject);
                EClass eClass = eObject.eClass();
                Map<String, String> userData = this.userData(eObject);
                updater.createOrUpdateEObject(resourceURI, fragment, name, eClass, userData);
            }
            if (!this.isIndexChildren(eObject, resource)) continue;
            this.recursivelyCreateEObjectDescriptors(resource, (EList<EObject>)eObject.eContents(), updater, resourceURI);
        }
    }

    private void recursivelyCreateEReferenceDescriptors(Resource resource, EList<EObject> contents, IndexUpdater updater, URIConverter uriConverter, URI resourceURI) {
        for (EObject eObject : contents) {
            String sourceFragment = resource.getURIFragment(eObject);
            if (this.isIndexReferences(eObject, resource)) {
                for (EReference eReference : eObject.eClass().getEAllReferences()) {
                    if (!this.isIndexReference(eReference, eObject)) continue;
                    if (eReference.isMany()) {
                        List targets = (List)eObject.eGet((EStructuralFeature)eReference, false);
                        int index = 0;
                        while (index < targets.size()) {
                            Object target = targets instanceof BasicEList ? ((BasicEList)targets).basicGet(index) : targets.get(index);
                            this.createEReferenceDescriptor(sourceFragment, eObject, eReference, target, updater, resourceURI);
                            ++index;
                        }
                        continue;
                    }
                    Object target = eObject.eGet((EStructuralFeature)eReference, false);
                    this.createEReferenceDescriptor(sourceFragment, eObject, eReference, target, updater, resourceURI);
                }
            }
            if (!this.isIndexChildren(eObject, resource)) continue;
            this.recursivelyCreateEReferenceDescriptors(resource, (EList<EObject>)eObject.eContents(), updater, uriConverter, resourceURI);
        }
    }

    private void createEReferenceDescriptor(String sourceFragment, EObject eObject, EReference eReference, Object target, IndexUpdater updater, URI resourceURI) {
        if (target instanceof EObject) {
            URI targetFragmentURI = EcoreUtil.getURI((EObject)((EObject)target));
            updater.createOrUpdateEReference(resourceURI, sourceFragment, targetFragmentURI, eReference, this.userData(eObject, eReference));
        }
    }

    protected URIConverter getURIConverter(Resource resource) {
        ResourceSet resourceSet = resource.getResourceSet();
        return resourceSet != null ? resourceSet.getURIConverter() : URIConverter.INSTANCE;
    }

    protected Map<String, String> userData(Resource resource) {
        return null;
    }

    protected Map<String, String> userData(EObject eObject) {
        return null;
    }

    protected Map<String, String> userData(EObject eObject, EReference eReference) {
        return null;
    }

    protected String getEObjectName(EObject eObject) {
        EStructuralFeature nameFeature = eObject.eClass().getEStructuralFeature("name");
        if (nameFeature != null && nameFeature.getEType() instanceof EDataType) {
            if (!nameFeature.isMany()) {
                Object nameFeatureValue = eObject.eGet(nameFeature);
                return nameFeatureValue == null ? null : nameFeatureValue.toString();
            }
            List names = (List)eObject.eGet(nameFeature);
            StringBuilder b = new StringBuilder();
            Iterator nameIter = names.iterator();
            while (nameIter.hasNext()) {
                b.append(nameIter.next().toString());
            }
            return b.toString();
        }
        return null;
    }

    protected boolean isIndexElement(EObject eObject, Resource resource) {
        return eObject.eResource() == resource;
    }

    protected boolean isIndexReferences(EObject eObject, Resource resource) {
        return true;
    }

    protected boolean isIndexReference(EReference eReference, EObject element) {
        return !eReference.isContainment() && !eReference.isDerived() && element.eIsSet((EStructuralFeature)eReference);
    }

    protected boolean isIndexChildren(EObject eObject, Resource resource) {
        return true;
    }
}

