/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.internal.change;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.internal.change.FeatureChange;
import org.eclipse.emf.henshin.internal.change.ManyFeatureChange;
import org.eclipse.emf.henshin.internal.change.SingleFeatureChange;

public class ObjectChange {
    EObject owner;
    Map<EStructuralFeature, FeatureChange> changedFeatures = new LinkedHashMap<EStructuralFeature, FeatureChange>();

    public ObjectChange(EObject eObject) {
        this.owner = eObject;
    }

    public void removeValue(EStructuralFeature feature, Object value) {
        FeatureChange featureChange = this.changedFeatures.get(feature);
        if (featureChange == null) {
            featureChange = feature.isMany() ? new ManyFeatureChange(this.owner, feature) : new SingleFeatureChange(this.owner, feature);
            this.changedFeatures.put(feature, featureChange);
        }
        featureChange.removeValue(value);
    }

    public void addValue(EStructuralFeature feature, Object value) {
        FeatureChange featureChange = this.changedFeatures.get(feature);
        if (featureChange == null) {
            featureChange = feature.isMany() ? new ManyFeatureChange(this.owner, feature) : new SingleFeatureChange(this.owner, feature);
            this.changedFeatures.put(feature, featureChange);
        }
        featureChange.addValue(value);
    }

    public void execute() {
        for (FeatureChange change : this.changedFeatures.values()) {
            change.execute();
        }
    }

    public void undo() {
        for (FeatureChange change : this.changedFeatures.values()) {
            change.undo();
        }
    }

    public EObject getOwner() {
        return this.owner;
    }
}

