/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.internal.matching;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.common.util.EmfGraph;
import org.eclipse.emf.henshin.internal.constraints.Constraint;

public class DanglingConstraint
implements Constraint {
    private Map<EReference, Integer> outgoingEdgeCount;

    public DanglingConstraint(Map<EReference, Integer> outgoingEdgeCount, Map<EReference, Integer> incomingEdgeCount) {
        this.outgoingEdgeCount = outgoingEdgeCount;
    }

    public boolean check(EObject sourceValue, EmfGraph graph) {
        for (EReference type : sourceValue.eClass().getEReferences()) {
            if (type.isDerived()) continue;
            Integer expectedCount = this.outgoingEdgeCount != null && this.outgoingEdgeCount.get(type) != null ? this.outgoingEdgeCount.get(type) : Integer.valueOf(0);
            if (type.isMany()) {
                List outgoingEdges = (List)sourceValue.eGet((EStructuralFeature)type);
                if (expectedCount == null || expectedCount.intValue() == outgoingEdges.size()) continue;
                return false;
            }
            if (sourceValue.eGet((EStructuralFeature)type) == null || expectedCount == 1) continue;
            return false;
        }
        return true;
    }
}

