/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.internal.matching;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.common.util.EmfGraph;
import org.eclipse.emf.henshin.common.util.TransformationOptions;
import org.eclipse.emf.henshin.internal.conditions.attribute.AttributeConditionHandler;
import org.eclipse.emf.henshin.internal.constraints.BinaryConstraint;
import org.eclipse.emf.henshin.internal.matching.AttributeConstraint;
import org.eclipse.emf.henshin.internal.matching.DanglingConstraint;
import org.eclipse.emf.henshin.internal.matching.DomainChange;
import org.eclipse.emf.henshin.internal.matching.ParameterConstraint;
import org.eclipse.emf.henshin.internal.matching.ReferenceConstraint;
import org.eclipse.emf.henshin.internal.matching.Variable;

public class DomainSlot {
    Variable owner;
    boolean initialized = false;
    boolean locked = false;
    EObject value;
    List<EObject> domain;
    Collection<EObject> temporaryDomain;
    Map<BinaryConstraint, DomainChange> remoteChangeMap;
    Collection<String> initializedParameters;
    AttributeConditionHandler conditionHandler;
    TransformationOptions options;
    Collection<Variable> checkedVariables;
    Collection<EObject> usedObjects;

    public DomainSlot(AttributeConditionHandler conditionHandler, Collection<EObject> usedObjects, TransformationOptions options) {
        this.conditionHandler = conditionHandler;
        this.usedObjects = usedObjects;
        this.remoteChangeMap = new HashMap<BinaryConstraint, DomainChange>();
        this.initializedParameters = new ArrayList<String>();
        this.checkedVariables = new HashSet<Variable>();
        this.options = options;
    }

    public boolean instanciate(Variable variable, Map<Variable, DomainSlot> domainMap, EmfGraph graph) {
        if (!this.initialized) {
            this.initialized = true;
            this.owner = variable;
            if (this.temporaryDomain != null) {
                this.domain = new ArrayList<EObject>(this.temporaryDomain);
            }
            variable.getTypeConstraint().initDomain(this, graph);
            if (this.domain.isEmpty()) {
                return false;
            }
            if (!this.options.isDeterministic()) {
                Collections.shuffle(this.domain);
            }
            if (this.options.isInjective()) {
                this.domain.removeAll(this.usedObjects);
            }
        }
        if (!this.locked) {
            if (this.domain.isEmpty()) {
                return false;
            }
            this.value = this.domain.get(this.domain.size() - 1);
            this.domain.remove(this.domain.size() - 1);
            this.usedObjects.add(this.value);
            this.locked = true;
        }
        if (!this.checkedVariables.contains(variable)) {
            if (!variable.getTypeConstraint().check(this)) {
                return false;
            }
            for (AttributeConstraint attributeConstraint : variable.getAttributeConstraints()) {
                if (attributeConstraint.check(this)) continue;
                return false;
            }
            if (this.options.isDangling()) {
                for (DanglingConstraint danglingConstraint : variable.getDanglingConstraints()) {
                    if (danglingConstraint.check(this.value, graph)) continue;
                    return false;
                }
            }
            for (ParameterConstraint parameterConstraint : variable.getParameterConstraints()) {
                if (!this.conditionHandler.isSet(parameterConstraint.parameterName)) {
                    this.initializedParameters.add(parameterConstraint.parameterName);
                }
                if (parameterConstraint.check(this)) continue;
                return false;
            }
            for (ReferenceConstraint referenceConstraint : variable.getReferenceConstraints()) {
                DomainSlot target;
                if (referenceConstraint.check(this, target = domainMap.get(referenceConstraint.getTarget()))) continue;
                return false;
            }
            this.checkedVariables.add(variable);
        }
        return true;
    }

    public boolean unlock(Variable sender) {
        for (ReferenceConstraint constraint : sender.getReferenceConstraints()) {
            DomainChange change = this.remoteChangeMap.get(constraint);
            if (change == null) continue;
            change.slot.temporaryDomain = change.originalValues;
            this.remoteChangeMap.remove(constraint);
        }
        if (this.locked && sender == this.owner) {
            this.locked = false;
            this.usedObjects.remove(this.value);
            for (String parameterName : this.initializedParameters) {
                this.conditionHandler.unsetParameter(parameterName);
            }
            this.initializedParameters.clear();
            this.checkedVariables.clear();
            return this.domain != null && !this.domain.isEmpty();
        }
        this.checkedVariables.remove(sender);
        return false;
    }

    public void clear(Variable sender) {
        this.unlock(sender);
        if (sender == this.owner) {
            this.initialized = false;
            this.owner = null;
            this.value = null;
            this.domain = null;
            this.remoteChangeMap = new HashMap<BinaryConstraint, DomainChange>();
        }
    }

    public boolean instanciationPossible() {
        if (this.domain == null) {
            return false;
        }
        if (!this.locked) {
            return this.domain.size() > 0;
        }
        return false;
    }

    public void fixInstanciation(EObject value) {
        this.locked = true;
        this.value = value;
        this.initialized = true;
        this.usedObjects.add(value);
        this.owner = null;
    }
}

