/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.parsers;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.henshin.diagram.edit.helpers.AmalgamationEditHelper;
import org.eclipse.emf.henshin.diagram.edit.helpers.RootObjectEditHelper;
import org.eclipse.emf.henshin.diagram.parsers.AbstractParser;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;

public class RuleNameParser
extends AbstractParser {
    private View ruleView;

    public RuleNameParser(View view) {
        super(new EAttribute[]{HenshinPackage.eINSTANCE.getNamedElement_Name()});
        if (!RootObjectEditHelper.isRuleView(view)) {
            throw new IllegalArgumentException();
        }
        this.ruleView = view;
    }

    public String getPrintString(IAdaptable element, int flags) {
        Rule rule = (Rule)this.ruleView.getElement();
        String name = rule.getName() != null ? rule.getName() : "";
        Node root = RootObjectEditHelper.getRootObject(this.ruleView);
        if (root != null) {
            String type = root.getType().getName();
            return String.valueOf(name) + ":" + type;
        }
        return name;
    }

    public String getEditString(IAdaptable element, int flags) {
        return this.getPrintString(element, flags);
    }

    public ICommand getParseCommand(IAdaptable element, final String value, int flags) {
        View view = (View)element.getAdapter(View.class);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)view.getElement());
        if (domain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(domain, "Parse Rule Name", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return RuleNameParser.this.doParsing(value);
            }
        };
        return command;
    }

    private CommandResult doParsing(String value) throws ExecutionException {
        String rootType;
        String name;
        Rule rule = (Rule)this.ruleView.getElement();
        int colon = value.indexOf(58);
        if (colon < 0) {
            name = value;
            rootType = null;
        } else {
            name = value.substring(0, colon).trim();
            rootType = value.substring(colon + 1).trim();
            if (rootType.length() == 0) {
                rootType = null;
            }
        }
        Node oldRoot = RootObjectEditHelper.getRootObject(this.ruleView);
        if (!(rootType == null || oldRoot != null && rootType.equals(oldRoot.getType().getName()))) {
            EClass rootClass = null;
            for (EPackage epackage : rule.getTransformationSystem().getImports()) {
                EClassifier classifier = epackage.getEClassifier(rootType);
                if (!(classifier instanceof EClass)) continue;
                rootClass = (EClass)classifier;
                break;
            }
            if (rootClass != null) {
                RootObjectEditHelper.setRootObjectType(this.ruleView, rootClass);
            }
        }
        if (rootType == null && oldRoot != null) {
            RootObjectEditHelper.setRootObject(this.ruleView, null);
        }
        AmalgamationEditHelper.renameKernelRule(rule, name);
        return CommandResult.newOKCommandResult();
    }

    @Override
    protected boolean isAffectingFeature(Object feature) {
        if (feature == HenshinPackage.eINSTANCE.getNamedElement_Name()) {
            return true;
        }
        if (feature == EcorePackage.eINSTANCE.getEModelElement_EAnnotations()) {
            return true;
        }
        return feature == EcorePackage.eINSTANCE.getEAnnotation_References();
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }
}

