/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.util;

import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.statespace.Model;

public class StateSpaceHashCodeHelper {
    private static int[] PRIMES = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29};
    private boolean graphEquality;
    private boolean ignoreNodeIDs;
    private boolean ignoreAttributes;
    private EPackage ePackage;
    private int nsURIHashCode;
    private Model model;

    public StateSpaceHashCodeHelper(boolean graphEquality, boolean ignoreNodeIDs, boolean ignoreAttributes) {
        this.graphEquality = graphEquality;
        this.ignoreNodeIDs = ignoreNodeIDs;
        this.ignoreAttributes = ignoreAttributes;
    }

    public int hashCode(Model model) {
        this.model = model;
        int result = this.totalHashCode((EList<EObject>)model.getResource().getContents(), new LocalHashCodes(), 0);
        this.model = null;
        return result;
    }

    private int totalHashCode(EList<EObject> nodes, LocalHashCodes localHashCodes, int depth) {
        int[] total = new int[nodes.size()];
        int i = 0;
        while (i < total.length) {
            total[i] = this.totalHashCode((EObject)nodes.get(i), localHashCodes, depth);
            ++i;
        }
        return this.listHashCode(total, depth);
    }

    private int totalHashCode(EObject object, LocalHashCodes localHashCodes, int depth) {
        int hash = this.contextHashCode(object, localHashCodes);
        for (EReference reference : object.eClass().getEAllContainments()) {
            int value;
            if (reference.isMany()) {
                EList list = (EList)object.eGet((EStructuralFeature)reference);
                value = this.totalHashCode((EList<EObject>)list, localHashCodes, depth + 1);
            } else {
                EObject child = (EObject)object.eGet((EStructuralFeature)reference);
                value = child == null ? 0 : this.totalHashCode(child, localHashCodes, depth + 1);
            }
            hash = hash * 31 + value;
        }
        return hash;
    }

    private int localHashCode(EObject object) {
        EClass eclass = object.eClass();
        EList features = eclass.getEAllStructuralFeatures();
        int hashCode = eclass.getClassifierID() + 1;
        if (!this.ignoreNodeIDs) {
            int id = (Integer)this.model.getNodeIDsMap().get((Object)object);
            hashCode = hashCode * PRIMES[0] + id;
        }
        int i = 0;
        while (i < features.size()) {
            EStructuralFeature feature = (EStructuralFeature)features.get(i);
            int value = 0;
            if (feature.isMany()) {
                List list = (List)object.eGet(feature);
                if (feature instanceof EReference) {
                    value = list.size();
                } else if (feature instanceof EAttribute) {
                    value = this.ignoreAttributes ? 0 : list.hashCode();
                }
            } else {
                Object single = object.eGet(feature);
                if (single == null) {
                    value = 0;
                } else if (feature instanceof EReference) {
                    value = 1;
                } else if (feature instanceof EAttribute) {
                    value = this.ignoreAttributes ? 0 : single.hashCode();
                }
            }
            hashCode = hashCode * PRIMES[(i + 1) % PRIMES.length] + value;
            ++i;
        }
        if (this.ePackage != eclass.getEPackage()) {
            this.ePackage = eclass.getEPackage();
            this.nsURIHashCode = this.ePackage.getNsURI() != null ? this.ePackage.getNsURI().hashCode() : 0;
        }
        return hashCode + this.nsURIHashCode;
    }

    private int contextHashCode(EObject node, LocalHashCodes localHashCodes) {
        int hashCode = localHashCodes.get(node);
        EList references = node.eClass().getEAllReferences();
        int i = 0;
        while (i < references.size()) {
            EReference reference = (EReference)references.get(i);
            int value = 0;
            if (reference.isMany()) {
                List list = (List)node.eGet((EStructuralFeature)reference);
                int[] local = new int[list.size()];
                int j = 0;
                while (j < local.length) {
                    local[j] = localHashCodes.get(list.get(j));
                    ++j;
                }
                value = this.listHashCode(local, i);
            } else {
                EObject object = (EObject)node.eGet((EStructuralFeature)reference);
                value = object == null ? 0 : localHashCodes.get(object);
            }
            hashCode = hashCode * PRIMES[i % PRIMES.length] + value;
            ++i;
        }
        return hashCode;
    }

    private int listHashCode(int[] hashCodes, int depth) {
        int hash = 0;
        int i = 0;
        while (i < hashCodes.length) {
            if (!this.graphEquality) {
                hash *= PRIMES[depth % PRIMES.length];
            }
            hash += hashCodes[i];
            ++i;
        }
        return hash;
    }

    private class LocalHashCodes
    extends HashMap<EObject, Integer> {
        private static final long serialVersionUID = 1L;

        private LocalHashCodes() {
        }

        @Override
        public Integer get(Object object) {
            Integer hash = (Integer)super.get(object);
            if (hash == null) {
                hash = StateSpaceHashCodeHelper.this.localHashCode((EObject)object);
                this.put((EObject)object, hash);
            }
            return hash;
        }
    }
}

