/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.explorer.commands.AbstractStateSpaceCommand;
import org.eclipse.emf.henshin.statespace.impl.MultiThreadedStateSpaceManager;

public class ExploreStatesCommand
extends AbstractStateSpaceCommand {
    private List<State> states;
    private boolean generateLocations = true;

    public ExploreStatesCommand(StateSpaceManager manager) {
        this(manager, (List<State>)manager.getStateSpace().getOpenStates());
    }

    public ExploreStatesCommand(StateSpaceManager manager, State state) {
        this(manager, Collections.singletonList(state));
    }

    public ExploreStatesCommand(StateSpaceManager manager, List<State> states) {
        super("explore states", manager);
        this.states = new ArrayList<State>(states);
    }

    @Override
    public void doExecute() throws StateSpaceException {
        StateSpaceManager manager = this.getStateSpaceManager();
        if (manager instanceof MultiThreadedStateSpaceManager) {
            ((MultiThreadedStateSpaceManager)manager).exploreStates(this.states, this.generateLocations);
        } else {
            for (State state : this.states) {
                manager.exploreState(state, this.generateLocations);
            }
        }
    }

    public boolean canUndo() {
        return false;
    }

    public List<State> getStatesToExplore() {
        return this.states;
    }

    public void setGenerateLocations(boolean generateLocations) {
        this.generateLocations = generateLocations;
    }
}

