/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.internal.change.ModelChange;
import org.eclipse.emf.henshin.interpreter.interfaces.InterpreterEngine;
import org.eclipse.emf.henshin.interpreter.util.Match;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;

public class RuleApplication {
    private InterpreterEngine interpreterEngine;
    private Rule rule;
    private Match match;
    private Match comatch;
    private ModelChange modelChange;
    private boolean isExecuted = false;
    private boolean isUndone = false;

    public RuleApplication(InterpreterEngine engine, Rule rule) {
        if (engine == null) {
            throw new IllegalArgumentException("engine can not be null");
        }
        if (rule == null) {
            throw new IllegalArgumentException("rule can not be null");
        }
        this.rule = rule;
        this.interpreterEngine = engine;
        this.match = new Match(rule, new HashMap<Parameter, Object>(), new HashMap<Node, EObject>());
    }

    public Match findMatch() {
        return this.interpreterEngine.findMatch(this);
    }

    public List<Match> findAllMatches() {
        return this.interpreterEngine.findAllMatches(this);
    }

    public boolean apply() {
        if (!this.isExecuted) {
            this.comatch = this.interpreterEngine.applyRule(this);
            this.isExecuted = this.comatch != null;
            return this.isExecuted;
        }
        return false;
    }

    public void undo() {
        if (this.isExecuted && !this.isUndone) {
            this.interpreterEngine.undoChanges(this);
            this.isUndone = true;
        }
    }

    public void redo() {
        if (this.isExecuted && this.isUndone) {
            this.interpreterEngine.redoChanges(this);
        }
    }

    public String getDescription() {
        return this.rule.getDescription();
    }

    public void setParameterValue(String name, Object value) {
        Parameter parameter = this.rule.getParameterByName(name);
        if (parameter != null) {
            this.match.getParameterValues().put(parameter, value);
        }
    }

    public void setParameterValues(Map<Parameter, Object> assignments) {
        this.match.getParameterValues().clear();
        this.match.getParameterValues().putAll(assignments);
    }

    public void setMatch(Match match) {
        this.match = match;
    }

    public void addMatch(Node node, EObject value) {
        this.match.getNodeMapping().put(node, value);
    }

    public Match getMatch() {
        return this.match;
    }

    public Match getComatch() {
        return this.comatch;
    }

    public void setComatch(Match comatch) {
        this.comatch = comatch;
    }

    public ModelChange getModelChange() {
        return this.modelChange;
    }

    public void setModelChange(ModelChange modelChange) {
        this.modelChange = modelChange;
    }

    public String toString() {
        return this.rule.getName();
    }

    public Rule getRule() {
        return this.rule;
    }

    public InterpreterEngine getInterpreterEngine() {
        return this.interpreterEngine;
    }
}

