/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.ParameterMapping;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.emf.henshin.provider.HenshinEditPlugin;
import org.eclipse.emf.henshin.provider.descriptors.ParameterMappingPropertyDescriptor;

public class ParameterMappingItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    ParameterListener parameterListener = new ParameterListener();

    public ParameterMappingItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addSourcePropertyDescriptor(object);
            this.addTargetPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addSourcePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ParameterMappingPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ParameterMapping_source_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ParameterMapping_source_feature", "_UI_ParameterMapping_type"), (EStructuralFeature)HenshinPackage.Literals.PARAMETER_MAPPING__SOURCE));
    }

    protected void addTargetPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ParameterMappingPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ParameterMapping_target_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ParameterMapping_target_feature", "_UI_ParameterMapping_type"), (EStructuralFeature)HenshinPackage.Literals.PARAMETER_MAPPING__TARGET));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/ParameterMapping"));
    }

    public String getText(Object object) {
        ParameterMapping pmapping = (ParameterMapping)object;
        TransformationUnit unit = (TransformationUnit)pmapping.eContainer();
        StringBuffer result = new StringBuffer(this.getString("_UI_ParameterMapping_type"));
        String src = this.calculateParameterString(pmapping.getSource(), unit);
        String trg = this.calculateParameterString(pmapping.getTarget(), unit);
        result.append(" ").append(src).append(" -> ").append(trg);
        return result.toString();
    }

    private String calculateParameterString(Parameter p, TransformationUnit owningUnit) {
        if (p != null) {
            String n2;
            StringBuffer buf = new StringBuffer();
            if (!p.getUnit().equals(owningUnit)) {
                String n1 = p.getUnit().getName();
                buf.append(n1 == null || n1.trim().isEmpty() ? "_" : n1);
                buf.append(".");
            }
            buf.append((n2 = p.getName()) == null || n2.trim().isEmpty() ? "_" : n2);
            return buf.toString();
        }
        return "?";
    }

    public void notifyChanged(Notification notification) {
        if (notification.getEventType() == 1) {
            ParameterMapping parmap = (ParameterMapping)notification.getNotifier();
            ItemProviderAdapter adapter = (ItemProviderAdapter)this.adapterFactory.adapt((Notifier)parmap, null);
            ViewerNotification notif = new ViewerNotification(notification, (Object)parmap, false, true);
            adapter.fireNotifyChanged((Notification)notif);
            Parameter p_new = (Parameter)notification.getNewValue();
            Parameter p_old = (Parameter)notification.getOldValue();
            this.removeParameterListener(p_old);
            this.addParameterListener(p_new);
        }
        this.updateChildren(notification);
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return HenshinEditPlugin.INSTANCE;
    }

    public void setTarget(Notifier target) {
        super.setTarget(target);
        ParameterMapping mapping = (ParameterMapping)target;
        this.addParameterListener(mapping.getSource());
        this.addParameterListener(mapping.getTarget());
    }

    public void unsetTarget(Notifier target) {
        super.unsetTarget(target);
        ParameterMapping mapping = (ParameterMapping)target;
        this.removeParameterListener(mapping.getSource());
        this.removeParameterListener(mapping.getTarget());
    }

    private void addParameterListener(Parameter parameter) {
        if (parameter != null) {
            ItemProviderAdapter parameterAdapter = (ItemProviderAdapter)this.adapterFactory.adapt((Notifier)parameter, Parameter.class);
            parameterAdapter.addListener((INotifyChangedListener)this.parameterListener);
            ItemProviderAdapter ruleAdapter = (ItemProviderAdapter)this.adapterFactory.adapt((Notifier)parameter.getUnit(), TransformationUnit.class);
            ruleAdapter.addListener((INotifyChangedListener)this.parameterListener);
        }
    }

    private void removeParameterListener(Parameter parameter) {
        if (parameter != null) {
            ItemProviderAdapter parameterAdapter = (ItemProviderAdapter)this.adapterFactory.adapt((Notifier)parameter, Parameter.class);
            parameterAdapter.removeListener((INotifyChangedListener)this.parameterListener);
            if (parameter.getUnit() != null) {
                ItemProviderAdapter ruleAdapter = (ItemProviderAdapter)this.adapterFactory.adapt((Notifier)parameter.getUnit(), TransformationUnit.class);
                ruleAdapter.removeListener((INotifyChangedListener)this.parameterListener);
            }
        }
    }

    private class ParameterListener
    implements INotifyChangedListener {
        private ParameterListener() {
        }

        public void notifyChanged(Notification notification) {
            if (notification.getFeature() == HenshinPackage.Literals.NAMED_ELEMENT__NAME) {
                if (notification.getNotifier() instanceof Parameter) {
                    List<ParameterMapping> pms = this.findParameterMappings((Parameter)notification.getNotifier());
                    this.notifyParameterMappingItemProvider(notification, pms);
                }
                if (notification.getNotifier() instanceof TransformationUnit) {
                    TransformationUnit tu = (TransformationUnit)notification.getNotifier();
                    for (Parameter param : tu.getParameters()) {
                        List<ParameterMapping> pms = ParameterMappingItemProvider.this.parameterListener.findParameterMappings(param);
                        this.notifyParameterMappingItemProvider(notification, pms);
                    }
                }
            }
        }

        private void notifyParameterMappingItemProvider(Notification notification, List<ParameterMapping> pms) {
            AdapterFactory fac = ParameterMappingItemProvider.this.adapterFactory;
            for (ParameterMapping pm : pms) {
                ViewerNotification notif = new ViewerNotification(notification, (Object)pm, false, true);
                ItemProviderAdapter adapter = (ItemProviderAdapter)fac.adapt((Notifier)pm, ParameterMapping.class);
                adapter.fireNotifyChanged((Notification)notif);
            }
        }

        private final List<ParameterMapping> findParameterMappings(Parameter para) {
            ArrayList<ParameterMapping> result = new ArrayList<ParameterMapping>();
            TransformationUnit tu = (TransformationUnit)para.eContainer();
            this.collectRelatedParameterMappings(tu, para, result);
            TransformationSystem ts = (TransformationSystem)tu.eContainer();
            for (TransformationUnit parent : ts.getTransformationUnits()) {
                if (!parent.getSubUnits(false).contains((Object)tu)) continue;
                this.collectRelatedParameterMappings(parent, para, result);
            }
            return result;
        }

        private void collectRelatedParameterMappings(TransformationUnit tu, Parameter para, List<ParameterMapping> result) {
            for (ParameterMapping pm : tu.getParameterMappings()) {
                if (pm.getSource() != para && pm.getTarget() != para) continue;
                result.add(pm);
            }
        }
    }
}

