/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.matching.constraints;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.matching.EmfGraph;
import org.eclipse.emf.henshin.matching.constraints.Constraint;

public class DanglingConstraint
implements Constraint {
    private Map<EReference, Integer> outgoingEdgeCount;
    private Map<EReference, Integer> incomingEdgeCount;

    public DanglingConstraint(Map<EReference, Integer> outgoingEdgeCount, Map<EReference, Integer> incomingEdgeCount) {
        this.outgoingEdgeCount = outgoingEdgeCount;
        this.incomingEdgeCount = incomingEdgeCount;
    }

    public boolean check(EObject sourceValue, EmfGraph graph) {
        Collection settings = graph.getCrossReferenceAdapter().getInverseReferences(sourceValue);
        Map<EReference, Integer> actualIncomingEdges = this.createMapFromSettings(settings);
        if (this.incomingEdgeCount != null) {
            for (EReference ref : actualIncomingEdges.keySet()) {
                if (actualIncomingEdges.get(ref) <= actualIncomingEdges.get(ref)) continue;
                return false;
            }
        } else if (!actualIncomingEdges.isEmpty()) {
            return false;
        }
        for (EReference type : sourceValue.eClass().getEReferences()) {
            if (type.isDerived()) continue;
            Integer expectedCount = this.outgoingEdgeCount != null && this.outgoingEdgeCount.get(type) != null ? this.outgoingEdgeCount.get(type) : Integer.valueOf(0);
            if (type.isMany()) {
                List outgoingEdges = (List)sourceValue.eGet((EStructuralFeature)type);
                outgoingEdges.retainAll(graph.geteObjects());
                if (expectedCount == null || expectedCount.intValue() == outgoingEdges.size()) continue;
                return false;
            }
            if (sourceValue.eGet((EStructuralFeature)type) == null || expectedCount == 1 || !graph.geteObjects().contains(sourceValue.eGet((EStructuralFeature)type))) continue;
            return false;
        }
        return true;
    }

    private Map<EReference, Integer> createMapFromSettings(Collection<EStructuralFeature.Setting> settings) {
        HashMap<EReference, Integer> result = new HashMap<EReference, Integer>();
        for (EStructuralFeature.Setting setting : settings) {
            Integer count = (Integer)result.get(setting.getEStructuralFeature());
            if (count == null) {
                count = 1;
                result.put((EReference)setting.getEStructuralFeature(), count);
                continue;
            }
            count = count + 1;
        }
        return result;
    }
}

