/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.henshin.diagram.edit.actions.Action;
import org.eclipse.emf.henshin.diagram.edit.actions.ActionType;
import org.eclipse.emf.henshin.diagram.edit.actions.NodeActionHelper;
import org.eclipse.emf.henshin.diagram.edit.helpers.RootObjectEditHelper;
import org.eclipse.emf.henshin.diagram.edit.maps.NodeMapEditor;
import org.eclipse.emf.henshin.diagram.edit.policies.HenshinBaseItemSemanticEditPolicy;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.util.HenshinMappingUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;

public class EdgeCreateCommand
extends EditElementCommand {
    public static final String TYPE_PARAMETER_KEY = "henshin_edge_type";
    private final EObject source;
    private final EObject target;
    private final Graph container;

    public EdgeCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.source = source;
        this.target = target;
        this.container = EdgeCreateCommand.deduceContainer(source, target);
    }

    public boolean canExecuteGen() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof Node)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof Node)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        if (this.getContainer() == null) {
            return false;
        }
        return HenshinBaseItemSemanticEditPolicy.getLinkConstraints().canCreateEdge_4001(this.getContainer(), this.getSource(), this.getTarget());
    }

    public boolean canExecute() {
        if (!this.canExecuteGen()) {
            return false;
        }
        if (this.source != null && this.target != null) {
            EReference type = (EReference)this.getRequest().getParameter(TYPE_PARAMETER_KEY);
            return EdgeCreateCommand.canCreateEdge(this.getSource(), this.getTarget(), type);
        }
        return true;
    }

    public static boolean canCreateEdge(Node source, Node target, EReference edgeType) {
        EClass targetType = target.getType();
        EClass sourceType = source.getType();
        if (source == null || target == null || sourceType == null || targetType == null || edgeType == null) {
            return false;
        }
        if (!sourceType.getEAllReferences().contains((Object)edgeType)) {
            return false;
        }
        if (!edgeType.getEReferenceType().isSuperTypeOf(targetType) && edgeType.getEReferenceType() != EcorePackage.eINSTANCE.getEObject()) {
            return false;
        }
        Graph sourceGraph = source.getGraph();
        Graph targetGraph = target.getGraph();
        if (sourceGraph.getContainerRule() == null || sourceGraph.getContainerRule() != targetGraph.getContainerRule()) {
            return false;
        }
        Action action1 = NodeActionHelper.INSTANCE.getAction(source);
        Action action2 = NodeActionHelper.INSTANCE.getAction(target);
        if (action1 == null || action2 == null) {
            return false;
        }
        return action1.equals(action2) || action1.getType() == ActionType.PRESERVE || action2.getType() == ActionType.PRESERVE;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Action trgAction;
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        EReference type = (EReference)this.getRequest().getParameter(TYPE_PARAMETER_KEY);
        Rule rule = this.getSource().getGraph().getContainerRule();
        Node source = this.getSource();
        Node target = this.getTarget();
        Edge edge = null;
        Action srcAction = NodeActionHelper.INSTANCE.getAction(source);
        if (srcAction.equals(trgAction = NodeActionHelper.INSTANCE.getAction(target))) {
            edge = HenshinFactory.eINSTANCE.createEdge(source, target, type);
            if (srcAction.getType() == ActionType.PRESERVE) {
                Node srcImage = HenshinMappingUtil.getNodeImage((Node)this.getSource(), (Graph)rule.getRhs(), (List)rule.getMappings());
                Node trgImage = HenshinMappingUtil.getNodeImage((Node)this.getTarget(), (Graph)rule.getRhs(), (List)rule.getMappings());
                HenshinFactory.eINSTANCE.createEdge(srcImage, trgImage, type);
            }
        } else {
            if (srcAction.getType() == ActionType.PRESERVE) {
                if (trgAction.getType() == ActionType.CREATE || trgAction.getType() == ActionType.FORBID) {
                    source = new NodeMapEditor(target.getGraph()).copy(source);
                }
            } else if (srcAction.getType() == ActionType.CREATE || srcAction.getType() == ActionType.FORBID) {
                target = new NodeMapEditor(source.getGraph()).copy(target);
            }
            edge = HenshinFactory.eINSTANCE.createEdge(source, target, type);
        }
        if (type.isContainment() || type.isContainer()) {
            View ruleView = RootObjectEditHelper.findRuleView(rule);
            RootObjectEditHelper.updateRootContainment(ruleView, source);
            RootObjectEditHelper.updateRootContainment(ruleView, target);
        }
        this.doConfigure(edge, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)edge);
        return CommandResult.newOKCommandResult((Object)edge);
    }

    protected void doConfigure(Edge newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        configureRequest.setParameter("CreateRelationshipRequest.source", (Object)this.getSource());
        configureRequest.setParameter("CreateRelationshipRequest.target", (Object)this.getTarget());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }

    protected void setElementToEdit(EObject element) {
        throw new UnsupportedOperationException();
    }

    protected Node getSource() {
        return (Node)this.source;
    }

    protected Node getTarget() {
        return (Node)this.target;
    }

    public Graph getContainer() {
        return this.container;
    }

    private static Graph deduceContainer(EObject source, EObject target) {
        EObject element = source;
        while (element != null) {
            if (element instanceof Graph) {
                return (Graph)element;
            }
            element = element.eContainer();
        }
        return null;
    }
}

