/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.maps;

import java.util.List;
import org.eclipse.emf.henshin.diagram.edit.maps.AbstractMapEditor;
import org.eclipse.emf.henshin.diagram.edit.maps.NodeMapEditor;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;

public class EdgeMapEditor
extends AbstractMapEditor<Edge> {
    private NodeMapEditor nodeMapEditor;

    public EdgeMapEditor(Graph source, Graph target, List<Mapping> mappings) {
        super(source, target, mappings);
        this.nodeMapEditor = new NodeMapEditor(this);
    }

    public EdgeMapEditor(Graph target) {
        super(target);
        this.nodeMapEditor = new NodeMapEditor(this);
    }

    public EdgeMapEditor(NodeMapEditor nodeMapEditor) {
        super(nodeMapEditor);
        this.nodeMapEditor = nodeMapEditor;
    }

    @Override
    protected Edge doCopy(Edge edge) {
        Edge opposite = this.getOpposite(edge);
        if (opposite == null) {
            opposite = HenshinFactory.eINSTANCE.createEdge();
            opposite.setType(edge.getType());
            opposite.setSource(this.nodeMapEditor.performCopy(edge.getSource()));
            opposite.setTarget(this.nodeMapEditor.performCopy(edge.getTarget()));
            opposite.setGraph(this.getOpposite(edge.getGraph()));
        }
        return opposite;
    }

    @Override
    protected void doMove(Edge edge) {
        Node newSource = this.nodeMapEditor.performCopy(edge.getSource());
        Node newTarget = this.nodeMapEditor.performCopy(edge.getTarget());
        if (newSource != null && newTarget != null) {
            edge.setSource(newSource);
            edge.setTarget(newTarget);
            edge.setGraph(this.getOpposite(edge.getGraph()));
        }
    }

    @Override
    protected void doRemove(Edge edge) {
        edge.setSource(null);
        edge.setTarget(null);
        edge.setGraph(null);
    }

    @Override
    protected Edge doReplace(Edge edge) {
        Edge opposite = this.getOpposite(edge);
        opposite.setSource(edge.getSource());
        opposite.setTarget(edge.getTarget());
        opposite.setGraph(edge.getGraph());
        edge.getGraph().removeEdge(edge);
        return opposite;
    }
}

