/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.parsers;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.henshin.diagram.parsers.AbstractParser;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.SequentialUnit;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;

public class InvocationNameParser
extends AbstractParser {
    public InvocationNameParser() {
        super(new EAttribute[]{HenshinPackage.eINSTANCE.getNamedElement_Name()});
    }

    public String getPrintString(IAdaptable element, int flags) {
        TransformationUnit invocation = (TransformationUnit)element.getAdapter(EObject.class);
        if (invocation == null || invocation.getName() == null) {
            return "null";
        }
        return invocation.getName();
    }

    public String getEditString(IAdaptable element, int flags) {
        return this.getPrintString(element, flags);
    }

    public ICommand getParseCommand(IAdaptable element, final String value, int flags) {
        final View view = (View)element.getAdapter(View.class);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)view.getElement());
        if (domain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(domain, "Parse Invocation Name", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return InvocationNameParser.this.doParsing(view, value);
            }
        };
        return command;
    }

    protected CommandResult doParsing(View view, String value) throws ExecutionException {
        TransformationUnit parent = (TransformationUnit)((View)view.eContainer().eContainer()).getElement();
        TransformationUnit invocation = (TransformationUnit)view.getElement();
        TransformationSystem system = (TransformationSystem)view.getDiagram().getElement();
        ArrayList candidates = new ArrayList();
        candidates.addAll(system.getRules());
        candidates.addAll(system.getTransformationUnits());
        value = value.trim();
        for (TransformationUnit unit : candidates) {
            if (!value.equals(unit.getName())) continue;
            if (!(parent instanceof SequentialUnit)) {
                return CommandResult.newErrorCommandResult((String)("Unknown transformation unit type: " + parent.eClass().getName()));
            }
            SequentialUnit sequential = (SequentialUnit)parent;
            int index = sequential.getSubUnits().indexOf((Object)invocation);
            sequential.getSubUnits().set(index, (Object)unit);
            view.setElement((EObject)unit);
            return CommandResult.newOKCommandResult();
        }
        return CommandResult.newErrorCommandResult((String)("Unknown transformation unit: " + value));
    }

    @Override
    protected boolean isAffectingFeature(Object feature) {
        if (feature == HenshinPackage.eINSTANCE.getNamedElement_Name()) {
            return true;
        }
        if (feature == HenshinPackage.eINSTANCE.getTransformationUnit_Parameters()) {
            return true;
        }
        if (feature == EcorePackage.eINSTANCE.getEModelElement_EAnnotations()) {
            return true;
        }
        return feature == EcorePackage.eINSTANCE.getEAnnotation_References();
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }
}

