/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.oo2rdb;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EcorePackageImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.henshin.model.impl.HenshinPackageImpl;
import org.eclipse.emf.henshin.model.resource.HenshinResourceFactory;
import org.eclipse.emf.henshin.trace.impl.TracePackageImpl;

public abstract class ATrafo {
    protected final ResourceSet resourceSet = new ResourceSetImpl();

    public void start() {
        this.initializeFactories();
    }

    protected EObject loadModel(String modelFilePath) {
        URI modelUri = URI.createFileURI((String)new File(modelFilePath).getAbsolutePath());
        Resource modelResource = this.resourceSet.getResource(modelUri, true);
        if (modelResource.isLoaded()) {
            modelResource.unload();
            try {
                modelResource.load(null);
            }
            catch (IOException iOException) {}
        }
        return (EObject)modelResource.getContents().get(0);
    }

    protected void saveModel(String filename, EObject root) {
        URI modelUri = URI.createFileURI((String)new File(filename).getAbsolutePath());
        Resource res = this.resourceSet.createResource(modelUri);
        HashMap<String, Boolean> opts = new HashMap<String, Boolean>();
        opts.put("SCHEMA_LOCATION", true);
        try {
            res.getContents().add((Object)root);
            res.save(opts);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void initializeFactories() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("henshin", new HenshinResourceFactory());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
        HenshinPackageImpl.init();
        EcorePackageImpl.init();
        TracePackageImpl.init();
    }
}

