/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.matching.constraints;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.matching.constraints.BinaryConstraint;
import org.eclipse.emf.henshin.matching.constraints.DomainChange;
import org.eclipse.emf.henshin.matching.constraints.DomainSlot;
import org.eclipse.emf.henshin.matching.constraints.Variable;

public class ContainmentConstraint
implements BinaryConstraint {
    private Variable target;

    public ContainmentConstraint(Variable target) {
        this.target = target;
    }

    @Override
    public boolean check(DomainSlot containedSlot, DomainSlot containerSlot) {
        boolean result;
        if (!containedSlot.locked) {
            return false;
        }
        if (containerSlot.locked) {
            return true;
        }
        EObject container = containedSlot.value.eContainer();
        if (container == null) {
            return false;
        }
        boolean bl = result = containerSlot.temporaryDomain == null || containerSlot.temporaryDomain.contains(container);
        if (result) {
            DomainChange change = new DomainChange(containerSlot, containerSlot.temporaryDomain);
            containedSlot.remoteChangeMap.put(this, change);
            containerSlot.temporaryDomain = new ArrayList<EObject>(1);
            containerSlot.temporaryDomain.add(container);
        }
        return result;
    }

    public Variable getTargetVariable() {
        return this.target;
    }
}

