/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.hashcodes;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.statespace.EqualityHelper;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.hashcodes.ContextHashCodeHelper;

class TotalHashCodeHelper {
    private static final int[] PRIMES = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29};
    private EqualityHelper equalityHelper;
    private ContextHashCodeHelper contextHashCodes;

    TotalHashCodeHelper(EqualityHelper helper) {
        this.equalityHelper = helper;
    }

    public int hashCode(Model model) {
        this.contextHashCodes = new ContextHashCodeHelper(model, this.equalityHelper);
        int result = this.totalHashCode(null, (EList<EObject>)model.getResource().getContents(), 0);
        this.contextHashCodes = null;
        return result;
    }

    protected int totalHashCode(EObject container, EList<EObject> nodes, int depth) {
        int[] hashcodes = new int[nodes.size()];
        int i = 0;
        while (i < hashcodes.length) {
            hashcodes[i] = this.totalHashCode((EObject)nodes.get(i), depth);
            ++i;
        }
        return this.listHashCode(hashcodes, depth);
    }

    protected int totalHashCode(EObject object, int depth) {
        int hash = (Integer)this.contextHashCodes.get(object);
        for (EReference reference : object.eClass().getEAllContainments()) {
            EList children;
            if (reference.isMany()) {
                children = (EList)object.eGet((EStructuralFeature)reference);
            } else {
                EObject child = (EObject)object.eGet((EStructuralFeature)reference);
                children = new BasicEList();
                if (child != null) {
                    children.add((Object)child);
                }
            }
            hash = hash * 31 + this.totalHashCode(object, (EList<EObject>)children, depth + 1);
        }
        return hash;
    }

    protected int listHashCode(int[] hashCodes, int depth) {
        int hash = 0;
        int i = 0;
        while (i < hashCodes.length) {
            if (this.equalityHelper.isCheckLinkOrder()) {
                hash *= PRIMES[depth % PRIMES.length];
            }
            hash += hashCodes[i];
            ++i;
        }
        return hash;
    }
}

