/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.EmfEngine;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.interpreter.interfaces.InterpreterEngine;
import org.eclipse.emf.henshin.interpreter.util.Match;
import org.eclipse.emf.henshin.matching.util.TransformationOptions;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpaceFactory;
import org.eclipse.emf.henshin.statespace.Trace;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.impl.AbstractStateSpaceManager;
import org.eclipse.emf.henshin.statespace.util.ObjectKeyHelper;
import org.eclipse.emf.henshin.statespace.util.ParameterUtil;
import org.eclipse.emf.henshin.statespace.util.StateSpaceMonitor;

public class StateSpaceManagerImpl
extends AbstractStateSpaceManager {
    private final Map<State, Model> stateModelCache = Collections.synchronizedMap(new Cache());
    private final Stack<EmfEngine> engines = new Stack();
    private final Object explorerLock = new Object();
    private PostProcessor postProcessor = new PostProcessor();

    public StateSpaceManagerImpl(StateSpace stateSpace) {
        super(stateSpace);
    }

    @Override
    protected boolean isOpen(State state) throws StateSpaceException {
        List<Transition> transitions = this.doExplore(state);
        HashSet<Transition> matched = new HashSet<Transition>();
        for (Transition current : transitions) {
            State generated = current.getTarget();
            State target = this.getState(generated.getModel(), generated.getHashCode());
            if (target == null) {
                return true;
            }
            Transition transition = StateSpaceManagerImpl.findTransition(state, target, current.getRule(), current.getMatch(), current.getParameterKeys());
            if (transition == null) {
                return true;
            }
            matched.add(transition);
        }
        if (!matched.containsAll((Collection<?>)state.getOutgoing())) {
            throw new StateSpaceException("Illegal transition in state " + state.getIndex());
        }
        return false;
    }

    @Override
    public Model getModel(State state) throws StateSpaceException {
        Model model = this.getCachedModel(state);
        if (model == null) {
            model = this.deriveModel(state, false);
            this.storeModel(state, model);
        }
        return model;
    }

    private Model getCachedModel(State state) {
        Model model = state.getModel();
        if (model != null) {
            return model;
        }
        return this.stateModelCache.get(state);
    }

    private void storeModel(State state, Model model) throws StateSpaceException {
        if (state.isInitial()) {
            return;
        }
        this.stateModelCache.put(state, model);
        int states = this.getStateSpace().getStates().size();
        states = states - states % 1000 + 1000;
        int stored = (int)(Math.log10(states) * 1.5);
        int index = state.getIndex() + 1;
        if (index % stored != 0) {
            model = null;
        }
        state.setModel(model);
    }

    private Model deriveModel(State state, boolean startFromInitial) throws StateSpaceException {
        Trace trace = new Trace();
        State source = state;
        Model start = null;
        EList<State> states = this.getStateSpace().getStates();
        try {
            while (start == null) {
                State target = source;
                source = (State)states.get(target.getDerivedFrom());
                trace.addFirst(StateSpaceManagerImpl.findTransition(source, target, null, -1, null));
                start = this.getCachedModel(source);
                if (!startFromInitial || source.isInitial()) continue;
                start = null;
            }
        }
        catch (Throwable t) {
            throw new StateSpaceException("Error deriving model for " + state, t);
        }
        Model model = start.getCopy(null);
        EmfEngine engine = this.acquireEngine();
        engine.setEmfGraph(model.getEmfGraph());
        for (Transition transition : trace) {
            RuleApplication application = new RuleApplication((InterpreterEngine)engine, transition.getRule());
            List matches = application.findAllMatches();
            if (matches.size() <= transition.getMatch()) {
                throw new StateSpaceException("Illegal transition in state " + transition.getSource());
            }
            Match match = (Match)matches.get(transition.getMatch());
            application.setMatch(match);
            application.apply();
            this.postProcessor.process(model);
            model.collectMissingRootObjects();
        }
        if (!this.getStateSpace().getEqualityHelper().getIdentityTypes().isEmpty()) {
            model.setObjectKeys(trace.getTarget().getObjectKeys());
        }
        this.releaseEngine(engine);
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<State> exploreState(State state, boolean generateLocation) throws StateSpaceException {
        int maxStateDistance = this.getStateSpace().getMaxStateDistance();
        if (maxStateDistance >= 0 && this.getStateDistance(state) >= maxStateDistance) {
            return Collections.emptyList();
        }
        List<Transition> transitions = this.doExplore(state);
        int newStates = 0;
        ArrayList<State> result = new ArrayList<State>(transitions.size());
        StateSpaceMonitor monitor = new StateSpaceMonitor(this.getStateSpace());
        Object object = this.explorerLock;
        synchronized (object) {
            monitor.setActive(true);
        }
        for (Transition transition : transitions) {
            Rule rule = transition.getRule();
            int match = transition.getMatch();
            int[] parameters = transition.getParameterKeys();
            int hashCode = transition.getTarget().getHashCode();
            Model transformed = transition.getTarget().getModel();
            boolean newState = false;
            int[] location = generateLocation ? StateSpaceManagerImpl.shiftedLocation(state, newStates++) : null;
            State target = this.getState(transformed, hashCode);
            Object object2 = this.explorerLock;
            synchronized (object2) {
                if (target == null) {
                    target = this.findState(transformed, hashCode, monitor.getAddedStates());
                } else if (monitor.getRemovedStates().contains(target)) {
                    target = null;
                }
                if (target == null) {
                    target = this.createOpenState(transformed, hashCode, state, location);
                    monitor.getAddedStates().remove(target);
                    newState = true;
                }
                if (newState || StateSpaceManagerImpl.findTransition(state, target, rule, match, parameters) == null) {
                    this.createTransition(state, target, rule, match, parameters);
                }
            }
            if (!newState) continue;
            this.storeModel(target, transformed);
            result.add(target);
        }
        object = this.explorerLock;
        synchronized (object) {
            monitor.setActive(false);
        }
        this.setOpen(state, false);
        return result;
    }

    protected List<Transition> doExplore(State state) throws StateSpaceException {
        Model model = this.getModel(state);
        EmfEngine matchEngine = this.acquireEngine();
        EmfEngine transformEngine = this.acquireEngine();
        matchEngine.setEmfGraph(model.getEmfGraph());
        boolean useObjectKeys = !this.getStateSpace().getEqualityHelper().getIdentityTypes().isEmpty();
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        for (Rule rule : this.getStateSpace().getRules()) {
            RuleApplication matchApp = new RuleApplication((InterpreterEngine)matchEngine, rule);
            List matches = matchApp.findAllMatches();
            List<Node> parameters = useObjectKeys ? ParameterUtil.getParameters(this.getStateSpace(), rule) : null;
            int matchIndex = 0;
            while (matchIndex < matches.size()) {
                Match match = (Match)matches.get(matchIndex);
                Model transformed = model.getCopy(match);
                transformEngine.setEmfGraph(transformed.getEmfGraph());
                RuleApplication transformApp = new RuleApplication((InterpreterEngine)transformEngine, rule);
                transformApp.setMatch(match);
                transformApp.apply();
                this.postProcessor.process(transformed);
                transformed.collectMissingRootObjects();
                State newState = StateSpaceFactory.eINSTANCE.createState();
                newState.setModel(transformed);
                if (useObjectKeys) {
                    transformed.updateObjectKeys(this.getStateSpace().getEqualityHelper().getIdentityTypes());
                    int[] objectKeys = transformed.getObjectKeys();
                    newState.setObjectKeys(objectKeys);
                    newState.setObjectCount(objectKeys.length);
                }
                int newHashCode = this.getStateSpace().getEqualityHelper().hashCode(transformed);
                newState.setHashCode(newHashCode);
                newState.setDerivedFrom(state.getIndex());
                Transition newTransition = StateSpaceFactory.eINSTANCE.createTransition();
                newTransition.setRule(rule);
                newTransition.setMatch(matchIndex);
                newTransition.setTarget(newState);
                if (useObjectKeys) {
                    int[] params = new int[parameters.size()];
                    int p = 0;
                    while (p < params.length) {
                        Node node = parameters.get(p);
                        EObject matched = (EObject)match.getNodeMapping().get(node);
                        if (matched == null) {
                            matched = (EObject)matchApp.getComatch().getNodeMapping().get(node);
                        }
                        int objectKey = (Integer)transformed.getObjectKeysMap().get((Object)matched);
                        params[p] = ObjectKeyHelper.createObjectKey(matched.eClass(), objectKey, this.getStateSpace().getEqualityHelper().getIdentityTypes());
                        ++p;
                    }
                    newTransition.setParameterKeys(params);
                    newTransition.setParameterCount(params.length);
                }
                transitions.add(newTransition);
                ++matchIndex;
            }
        }
        this.releaseEngine(matchEngine);
        this.releaseEngine(transformEngine);
        return transitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EmfEngine acquireEngine() {
        Stack<EmfEngine> stack = this.engines;
        synchronized (stack) {
            if (!this.engines.isEmpty()) {
                return this.engines.pop();
            }
            EmfEngine engine = new EmfEngine();
            TransformationOptions options = new TransformationOptions();
            options.setDeterministic(true);
            engine.setOptions(options);
            return engine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseEngine(EmfEngine engine) {
        Stack<EmfEngine> stack = this.engines;
        synchronized (stack) {
            this.engines.push(engine);
        }
    }

    private static int[] shiftedLocation(State base, int index) {
        int[] location = base.getLocation();
        double angle = Math.PI * (double)index * 0.17;
        location[0] = (int)((double)location[0] + 60.0 * Math.cos(angle));
        location[1] = (int)((double)location[1] + 60.0 * Math.sin(angle));
        return location;
    }

    @Override
    public void clearCache() {
        for (State state : this.getStateSpace().getStates()) {
            if (state.isInitial()) continue;
            state.setModel(null);
        }
        this.stateModelCache.clear();
        this.getStateSpace().getEqualityHelper().clearCache();
        this.postProcessor = new PostProcessor();
        System.gc();
    }

    protected void checkEngineDeterminism(State state) throws StateSpaceException {
        List<Transition> transitions = this.doExplore(state);
        int i = 0;
        while (i < 25) {
            List<Transition> transitions2 = this.doExplore(state);
            if (transitions.size() != transitions2.size()) {
                this.markTainted();
                throw new StateSpaceException("Sanity check 1 failed!");
            }
            int j = 0;
            while (j < transitions.size()) {
                Transition t1 = transitions.get(j);
                Transition t2 = transitions2.get(j);
                if (t1.getRule() != t2.getRule() || t1.getMatch() != t2.getMatch()) {
                    this.markTainted();
                    throw new StateSpaceException("Sanity check 2 failed!");
                }
                State s1 = t1.getTarget();
                State s2 = t2.getTarget();
                if (s1.getHashCode() != s2.getHashCode()) {
                    this.markTainted();
                    throw new StateSpaceException("Sanity check 3 failed!");
                }
                if (!this.getStateSpace().getEqualityHelper().equals(s1.getModel(), s2.getModel())) {
                    this.markTainted();
                    throw new StateSpaceException("Sanity check 4 failed!");
                }
                ++j;
            }
            ++i;
        }
    }

    static class Cache<K, V>
    extends LinkedHashMap<K, V> {
        public static final int CACHE_SIZE = 1024;
        private static final long serialVersionUID = 1L;

        Cache() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > 1024;
        }
    }

    class PostProcessor {
        private ScriptEngine engine;
        private String script;

        PostProcessor() {
            ScriptEngineManager manager = new ScriptEngineManager();
            this.engine = manager.getEngineByName("JavaScript");
            this.script = (String)StateSpaceManagerImpl.this.getStateSpace().getProperties().get((Object)"postProcessor");
            if (this.script != null && this.script.trim().length() == 0) {
                this.script = null;
            }
            if (this.script != null) {
                String imports = "importPackage(java.lang);\nimportPackage(java.util);\nimportPackage(org.eclipse.emf.ecore);\n";
                this.script = String.valueOf(imports) + this.script;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(Model model) throws StateSpaceException {
            if (this.script != null) {
                EObject root = (EObject)model.getResource().getContents().get(0);
                ScriptEngine scriptEngine = this.engine;
                synchronized (scriptEngine) {
                    this.engine.put("model", root);
                    try {
                        this.engine.eval(this.script);
                    }
                    catch (ScriptException e) {
                        throw new StateSpaceException(e);
                    }
                }
            }
        }
    }
}

