/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.tuples;

import java.util.Arrays;

public class Tuple
implements Cloneable {
    int[] data;

    public Tuple(int width) {
        this.data = new int[width];
    }

    public int[] data() {
        return this.data;
    }

    public int width() {
        return this.data.length;
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public boolean equals(Object o) {
        if (o instanceof Tuple) {
            return Arrays.equals(this.data, ((Tuple)o).data);
        }
        return false;
    }

    public String toString() {
        String t = "(";
        int i = 0;
        while (i < this.data.length) {
            t = String.valueOf(t) + this.data[i];
            if (i < this.data.length - 1) {
                t = String.valueOf(t) + ",";
            }
            ++i;
        }
        return String.valueOf(t) + ")";
    }

    public Object clone() {
        Tuple clone = new Tuple(this.data.length);
        System.arraycopy(this.data, 0, clone.data, 0, this.data.length);
        return clone;
    }

    public void revert() {
        int half = this.data.length / 2;
        int i = 0;
        while (i < half) {
            int d = this.data[i];
            this.data[i] = this.data[this.data.length - i - 1];
            this.data[this.data.length - i - 1] = d;
            ++i;
        }
    }
}

