/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.testframework;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.henshin.interpreter.EmfEngine;
import org.eclipse.emf.henshin.interpreter.HenshinGraph;
import org.eclipse.emf.henshin.interpreter.util.ModelHelper;
import org.eclipse.emf.henshin.matching.EmfGraph;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.TransformationSystem;

public class HenshinLoaders {
    public static final String HENSHIN_FILE_EXTENSION = "henshin";

    public static TransformationSystem loadHenshin(String fileName) {
        ModelHelper.registerFileExtension((String)HENSHIN_FILE_EXTENSION);
        return (TransformationSystem)ModelHelper.loadFile((String)fileName);
    }

    public static EmfEngine loadEngine(String modelFileName, String modelFileExt) {
        return new EmfEngine(HenshinLoaders.loadGraph(modelFileName, modelFileExt));
    }

    public static EmfGraph loadGraph(String modelFileName, String modelFileExt) {
        ModelHelper.registerFileExtension((String)modelFileExt);
        EObject graphRoot = ModelHelper.loadFile((String)modelFileName);
        EmfGraph graph = new EmfGraph();
        graph.addRoot(graphRoot);
        return graph;
    }

    public static EmfGraph loadEmbeddedGraph(String embeddedGraphName, TransformationSystem ts) throws NullPointerException {
        HenshinGraph hgr = null;
        for (Graph g : ts.getInstances()) {
            if (!g.getName().equals(embeddedGraphName)) continue;
            hgr = new HenshinGraph(g);
            break;
        }
        if (hgr == null) {
            throw new NullPointerException("couldn't find embedded graph " + embeddedGraphName);
        }
        return hgr;
    }

    public static EmfGraph loadGraph(String embeddedGraphName, TransformationSystem ts) {
        return HenshinLoaders.loadEmbeddedGraph(embeddedGraphName, ts);
    }

    public static EmfGraph loadGraph(URI graphUri) {
        Resource resourceModel = new ResourceSetImpl().getResource(graphUri, true);
        EmfGraph egr = new EmfGraph();
        egr.addRoot((EObject)resourceModel.getContents().get(0));
        return egr;
    }
}

