/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.impl.AttributeImpl;
import org.eclipse.emf.henshin.model.impl.FormulaImpl;
import org.eclipse.emf.henshin.model.impl.NamedElementImpl;

public class GraphImpl
extends NamedElementImpl
implements Graph {
    protected EList<Node> nodes;
    protected EList<Edge> edges;
    protected Formula formula;

    protected GraphImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return HenshinPackage.Literals.GRAPH;
    }

    @Override
    public EList<Node> getNodes() {
        if (this.nodes == null) {
            this.nodes = new EObjectContainmentWithInverseEList(Node.class, (InternalEObject)this, 1, 3);
        }
        return this.nodes;
    }

    @Override
    public EList<Edge> getEdges() {
        if (this.edges == null) {
            this.edges = new EObjectContainmentWithInverseEList(Edge.class, (InternalEObject)this, 2, 3);
        }
        return this.edges;
    }

    @Override
    public Formula getFormula() {
        return this.formula;
    }

    public NotificationChain basicSetFormula(Formula newFormula, NotificationChain msgs) {
        Formula oldFormula = this.formula;
        this.formula = newFormula;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldFormula, (Object)newFormula);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setFormula(Formula newFormula) {
        if (newFormula != this.formula) {
            NotificationChain msgs = null;
            if (this.formula != null) {
                msgs = ((InternalEObject)this.formula).eInverseRemove((InternalEObject)this, -4, null, msgs);
            }
            if (newFormula != null) {
                msgs = ((InternalEObject)newFormula).eInverseAdd((InternalEObject)this, -4, null, msgs);
            }
            if ((msgs = this.basicSetFormula(newFormula, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newFormula, (Object)newFormula));
        }
    }

    @Override
    public void removeEdge(Edge edge) {
        edge.setSource(null);
        edge.setTarget(null);
        edge.setGraph(null);
    }

    @Override
    public void removeNode(Node node) {
        EList<Edge> edges = node.getAllEdges();
        for (Edge edge : edges) {
            this.removeEdge(edge);
        }
        node.setGraph(null);
    }

    @Override
    public Rule getContainerRule() {
        EObject container = this.eContainer();
        while (container != null) {
            if (container instanceof Rule) {
                return (Rule)container;
            }
            container = container.eContainer();
        }
        return null;
    }

    @Override
    public EList<Node> findNodesByType(EClass nodeType) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node node : this.getNodes()) {
            if (!nodeType.equals(node.getType())) continue;
            result.add(node);
        }
        return new BasicEList(result);
    }

    @Override
    public EList<Edge> findEdgesByType(EReference edgeType) {
        ArrayList<Edge> result = new ArrayList<Edge>();
        for (Edge edge : this.getEdges()) {
            if (!edgeType.equals(edge.getType())) continue;
            result.add(edge);
        }
        return new BasicEList(result);
    }

    @Override
    public boolean isLhs() {
        return this.eContainer() instanceof Rule && ((Rule)this.eContainer()).getLhs() == this;
    }

    @Override
    public boolean isRhs() {
        return this.eContainer() instanceof Rule && ((Rule)this.eContainer()).getRhs() == this;
    }

    @Override
    public boolean isHost() {
        return this.eContainer() instanceof TransformationSystem;
    }

    @Override
    public boolean isNestedCondition() {
        return this.eContainer() instanceof NestedCondition;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getNodes()).basicAdd((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getEdges()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getNodes()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getEdges()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return this.basicSetFormula(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getNodes();
            }
            case 2: {
                return this.getEdges();
            }
            case 3: {
                return this.getFormula();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getNodes().clear();
                this.getNodes().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getEdges().clear();
                this.getEdges().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setFormula((Formula)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getNodes().clear();
                return;
            }
            case 2: {
                this.getEdges().clear();
                return;
            }
            case 3: {
                this.setFormula(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.nodes != null && !this.nodes.isEmpty();
            }
            case 2: {
                return this.edges != null && !this.edges.isEmpty();
            }
            case 3: {
                return this.formula != null;
            }
        }
        return super.eIsSet(featureID);
    }

    protected void updateVariableName(String oldVariableName, String newVariableName) {
        for (Node node : this.getNodes()) {
            for (Attribute attribute : node.getAttributes()) {
                ((AttributeImpl)attribute).updateVariableName(oldVariableName, newVariableName);
            }
        }
        if (this.getFormula() != null) {
            ((FormulaImpl)this.getFormula()).updateVariableName(oldVariableName, newVariableName);
        }
    }
}

