/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.parts;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.henshin.diagram.edit.parts.AttributeEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.EdgeActionEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.EdgeEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.EdgeTypeEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.InvocationEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.InvocationNameEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.LinkEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.NodeActionEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.NodeCompartmentEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.NodeEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.NodeTypeEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.RuleCompartmentEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.RuleEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.RuleNameEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.SymbolEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.TransformationSystemEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.UnitCompartmentEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.UnitEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.UnitNameEditPart;
import org.eclipse.emf.henshin.diagram.part.HenshinVisualIDRegistry;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Text;

public class HenshinEditPartFactory
implements EditPartFactory {
    public EditPart createEditPart(EditPart context, Object model) {
        if (model instanceof View) {
            View view = (View)model;
            switch (HenshinVisualIDRegistry.getVisualID(view)) {
                case 1000: {
                    return new TransformationSystemEditPart(view);
                }
                case 2001: {
                    return new RuleEditPart(view);
                }
                case 5001: {
                    return new RuleNameEditPart(view);
                }
                case 2002: {
                    return new UnitEditPart(view);
                }
                case 5004: {
                    return new UnitNameEditPart(view);
                }
                case 3001: {
                    return new NodeEditPart(view);
                }
                case 5002: {
                    return new NodeTypeEditPart(view);
                }
                case 5003: {
                    return new NodeActionEditPart(view);
                }
                case 3002: {
                    return new AttributeEditPart(view);
                }
                case 3004: {
                    return new SymbolEditPart(view);
                }
                case 3003: {
                    return new InvocationEditPart(view);
                }
                case 5005: {
                    return new InvocationNameEditPart(view);
                }
                case 7001: {
                    return new RuleCompartmentEditPart(view);
                }
                case 7002: {
                    return new NodeCompartmentEditPart(view);
                }
                case 7003: {
                    return new UnitCompartmentEditPart(view);
                }
                case 4001: {
                    return new EdgeEditPart(view);
                }
                case 6001: {
                    return new EdgeTypeEditPart(view);
                }
                case 6002: {
                    return new EdgeActionEditPart(view);
                }
                case 4002: {
                    return new LinkEditPart(view);
                }
            }
        }
        return this.createUnrecognizedEditPart(context, model);
    }

    private EditPart createUnrecognizedEditPart(EditPart context, Object model) {
        return null;
    }

    public static CellEditorLocator getTextCellEditorLocator(ITextAwareEditPart source) {
        if (source.getFigure() instanceof WrappingLabel) {
            return new TextCellEditorLocator((WrappingLabel)source.getFigure());
        }
        return new LabelCellEditorLocator((Label)source.getFigure());
    }

    private static class LabelCellEditorLocator
    implements CellEditorLocator {
        private Label label;

        public LabelCellEditorLocator(Label label) {
            this.label = label;
        }

        public Label getLabel() {
            return this.label;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getLabel().getTextBounds().getCopy();
            this.getLabel().translateToAbsolute((Translatable)rect);
            if (!text.getFont().isDisposed()) {
                int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
                rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
            }
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    private static class TextCellEditorLocator
    implements CellEditorLocator {
        private WrappingLabel wrapLabel;

        public TextCellEditorLocator(WrappingLabel wrapLabel) {
            this.wrapLabel = wrapLabel;
        }

        public WrappingLabel getWrapLabel() {
            return this.wrapLabel;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            if (!text.isDisposed() && !text.getFont().isDisposed()) {
                this.relocateGen(celleditor);
            }
        }

        public void relocateGen(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getWrapLabel().getTextBounds().getCopy();
            this.getWrapLabel().translateToAbsolute((Translatable)rect);
            if (!text.getFont().isDisposed()) {
                if (this.getWrapLabel().isTextWrapOn() && this.getWrapLabel().getText().length() > 0) {
                    rect.setSize(new Dimension(text.computeSize(rect.width, -1)));
                } else {
                    int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
                    rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
                }
            }
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }
}

