/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.parsers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.henshin.diagram.parsers.AbstractParser;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;

public class UnitNameParser
extends AbstractParser {
    private static final Pattern UNIT_NAME_PATTERN = Pattern.compile("^\\s*(\\w*?)\\s*(?:\\s*\\(([\\w,\\s]*)\\s*\\))?$");
    private static final String PARAMETER_SEPARATOR = ",";
    protected View unitView;

    public UnitNameParser(View view) {
        super(new EAttribute[]{HenshinPackage.eINSTANCE.getNamedElement_Name()});
        this.unitView = view;
    }

    protected boolean isUnitEmpty(TransformationUnit unit) {
        return unit.getSubUnits(false).isEmpty() && unit.getParameters().isEmpty();
    }

    public String getEditString(IAdaptable element, int flags) {
        TransformationUnit unit = (TransformationUnit)this.unitView.getElement();
        StringBuilder sb = new StringBuilder();
        String name = unit.getName();
        sb.append(name == null ? "" : name);
        EList pList = unit.getParameters();
        int paramCount = pList.size();
        if (paramCount > 0) {
            sb.append("(").append(((Parameter)pList.get(0)).getName());
            int i = 1;
            while (i < paramCount) {
                sb.append(", ").append(((Parameter)pList.get(i)).getName());
                ++i;
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public String getPrintString(IAdaptable element, int flags) {
        TransformationUnit unit = (TransformationUnit)this.unitView.getElement();
        return String.valueOf(unit.eClass().getName()) + " " + this.getEditString(element, flags);
    }

    public ICommand getParseCommand(IAdaptable element, final String value, int flags) {
        View view = (View)element.getAdapter(View.class);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)view.getElement());
        if (domain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(domain, "Parse Unit Name", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return UnitNameParser.this.doParsing(value);
            }
        };
        return command;
    }

    protected CommandResult doParsing(String value) throws ExecutionException {
        TransformationUnit unit = (TransformationUnit)this.unitView.getElement();
        Matcher matcher = UNIT_NAME_PATTERN.matcher(value);
        if (!matcher.matches()) {
            return CommandResult.newErrorCommandResult((String)"Error parsing unit name");
        }
        String name = matcher.group(1).trim();
        String paraString = matcher.group(2);
        if (paraString != null && !paraString.trim().isEmpty()) {
            int n;
            String[] paraStrings = paraString.split(PARAMETER_SEPARATOR);
            List<Object> paramStringList = new ArrayList<String>(paraStrings.length);
            String[] stringArray = paraStrings;
            int n2 = paraStrings.length;
            int n3 = 0;
            while (n3 < n2) {
                String s = stringArray[n3];
                String st = s.trim();
                if (!paramStringList.contains(st)) {
                    paramStringList.add(st);
                }
                ++n3;
            }
            paraStrings = paramStringList.toArray(new String[paramStringList.size()]);
            EList currentParameters = unit.getParameters();
            for (Parameter p : currentParameters) {
                if (p.getName() == null) continue;
                p.setName(p.getName().trim());
            }
            Iterator it = currentParameters.iterator();
            while (it.hasNext()) {
                Parameter parameter = (Parameter)it.next();
                if (!paramStringList.contains(parameter.getName())) {
                    it.remove();
                    continue;
                }
                paramStringList.remove(parameter.getName());
            }
            for (String string : paramStringList) {
                Parameter p = HenshinFactory.eINSTANCE.createParameter();
                p.setName(string);
                currentParameters.add(p);
            }
            paramStringList = Arrays.asList(paraStrings);
            boolean bl = false;
            while (n < paraStrings.length) {
                Parameter p = (Parameter)currentParameters.get(n);
                int correctIndex = paramStringList.indexOf(p.getName());
                if (correctIndex != n) {
                    currentParameters.remove(p);
                    currentParameters.add(correctIndex, p);
                    n = 0;
                }
                n += 1;
            }
        } else {
            unit.getParameters().clear();
        }
        unit.setName(name);
        return CommandResult.newOKCommandResult();
    }

    @Override
    protected boolean isAffectingFeature(Object feature) {
        if (feature == HenshinPackage.eINSTANCE.getNamedElement_Name()) {
            return true;
        }
        if (feature == HenshinPackage.eINSTANCE.getTransformationUnit_Parameters()) {
            return true;
        }
        if (feature == EcorePackage.eINSTANCE.getEModelElement_EAnnotations()) {
            return true;
        }
        return feature == EcorePackage.eINSTANCE.getEAnnotation_References();
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }
}

