/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.internal.interpreter.ChangeInfo;
import org.eclipse.emf.henshin.internal.interpreter.ConditionInfo;
import org.eclipse.emf.henshin.internal.interpreter.RuleInfo;
import org.eclipse.emf.henshin.internal.interpreter.VariableInfo;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.interpreter.interfaces.InterpreterEngine;
import org.eclipse.emf.henshin.interpreter.util.Match;
import org.eclipse.emf.henshin.interpreter.util.ModelChange;
import org.eclipse.emf.henshin.matching.EmfGraph;
import org.eclipse.emf.henshin.matching.conditions.attribute.AttributeConditionHandler;
import org.eclipse.emf.henshin.matching.conditions.nested.AndFormula;
import org.eclipse.emf.henshin.matching.conditions.nested.ApplicationCondition;
import org.eclipse.emf.henshin.matching.conditions.nested.IFormula;
import org.eclipse.emf.henshin.matching.conditions.nested.NotFormula;
import org.eclipse.emf.henshin.matching.conditions.nested.OrFormula;
import org.eclipse.emf.henshin.matching.conditions.nested.TrueFormula;
import org.eclipse.emf.henshin.matching.conditions.nested.XorFormula;
import org.eclipse.emf.henshin.matching.constraints.DomainSlot;
import org.eclipse.emf.henshin.matching.constraints.Matchfinder;
import org.eclipse.emf.henshin.matching.constraints.Solution;
import org.eclipse.emf.henshin.matching.constraints.Variable;
import org.eclipse.emf.henshin.matching.util.TransformationOptions;
import org.eclipse.emf.henshin.model.And;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Not;
import org.eclipse.emf.henshin.model.Or;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.emf.henshin.model.Xor;
import org.eclipse.emf.henshin.model.util.HenshinMappingUtil;

public class EmfEngine
implements InterpreterEngine {
    EmfGraph emfGraph;
    ScriptEngine scriptEngine;
    Map<Rule, RuleInfo> ruleInformation = new HashMap<Rule, RuleInfo>();
    TransformationOptions options;

    public EmfEngine() {
        ScriptEngineManager mgr = new ScriptEngineManager();
        this.scriptEngine = mgr.getEngineByName("JavaScript");
        this.options = new TransformationOptions();
    }

    public EmfEngine(EmfGraph emfGraph) {
        this();
        this.emfGraph = emfGraph;
    }

    private Matchfinder prepareMatchfinder(Rule rule, Map<Parameter, Object> parameterValues, Map<Node, EObject> rulePrematch, Collection<EObject> usedObjects) {
        RuleInfo ruleInfo = this.getRuleInformation(rule);
        ConditionInfo conditionInfo = ruleInfo.getConditionInfo();
        VariableInfo variableInfo = ruleInfo.getVariableInfo();
        Map<Node, EObject> prematch = EmfEngine.createPrematch((TransformationUnit)rule, parameterValues);
        prematch.putAll(rulePrematch);
        AttributeConditionHandler conditionHandler = new AttributeConditionHandler(conditionInfo.getConditionParameters(), this.scriptEngine);
        HashMap<Variable, DomainSlot> domainMap = new HashMap<Variable, DomainSlot>();
        for (Variable mainVariable : variableInfo.getMainVariables()) {
            Node node = variableInfo.getVariableForNode(mainVariable);
            TransformationOptions options = this.getOptions().copy();
            if (options.getOption("injective") == null) {
                options.setInjective(ruleInfo.getRule().isInjectiveMatching());
            }
            if (options.getOption("dangling") == null) {
                options.setDangling(ruleInfo.getRule().isCheckDangling());
            }
            if (node.getGraph() != ruleInfo.getRule().getLhs()) {
                options.setDeterministic(true);
                options.setInjective(true);
                options.setDangling(false);
            }
            DomainSlot domainSlot = new DomainSlot(conditionHandler, usedObjects, options);
            if (prematch.get(node) != null) {
                domainSlot.fixInstantiation(prematch.get(node));
            }
            for (Variable dependendVariable : variableInfo.getDependendVariables(mainVariable)) {
                domainMap.put(dependendVariable, domainSlot);
            }
        }
        boolean conditionFailed = false;
        if (parameterValues != null) {
            for (Parameter parameter : parameterValues.keySet()) {
                conditionFailed |= !conditionHandler.setParameter(parameter.getName(), parameterValues.get(parameter));
            }
        }
        if (conditionFailed) {
            return null;
        }
        Map<Graph, List<Variable>> graphMap = variableInfo.getGraph2variables();
        Matchfinder matchfinder = new Matchfinder(this.emfGraph, domainMap, conditionHandler);
        matchfinder.setVariables(graphMap.get(rule.getLhs()));
        matchfinder.setFormula(this.initFormula(rule.getLhs().getFormula(), domainMap, graphMap, conditionHandler));
        return matchfinder;
    }

    private IFormula initFormula(Formula formula, Map<Variable, DomainSlot> domainMap, Map<Graph, List<Variable>> graphMap, AttributeConditionHandler conditionHandler) {
        if (formula instanceof And) {
            And and = (And)formula;
            IFormula left = this.initFormula(and.getLeft(), domainMap, graphMap, conditionHandler);
            IFormula right = this.initFormula(and.getRight(), domainMap, graphMap, conditionHandler);
            AndFormula andFormula = new AndFormula(left, right);
            return andFormula;
        }
        if (formula instanceof Or) {
            Or or = (Or)formula;
            IFormula left = this.initFormula(or.getLeft(), domainMap, graphMap, conditionHandler);
            IFormula right = this.initFormula(or.getRight(), domainMap, graphMap, conditionHandler);
            OrFormula orFormula = new OrFormula(left, right);
            return orFormula;
        }
        if (formula instanceof Xor) {
            Xor xor = (Xor)formula;
            IFormula left = this.initFormula(xor.getLeft(), domainMap, graphMap, conditionHandler);
            IFormula right = this.initFormula(xor.getRight(), domainMap, graphMap, conditionHandler);
            XorFormula xorFormula = new XorFormula(left, right);
            return xorFormula;
        }
        if (formula instanceof Not) {
            Not not = (Not)formula;
            IFormula child = this.initFormula(not.getChild(), domainMap, graphMap, conditionHandler);
            NotFormula notFormula = new NotFormula(child);
            return notFormula;
        }
        if (formula instanceof NestedCondition) {
            NestedCondition nc = (NestedCondition)formula;
            ApplicationCondition ac = this.initApplicationCondition(nc, domainMap, graphMap, conditionHandler);
            return ac;
        }
        return new TrueFormula();
    }

    private ApplicationCondition initApplicationCondition(NestedCondition nc, Map<Variable, DomainSlot> domainMap, Map<Graph, List<Variable>> graphMap, AttributeConditionHandler conditionHandler) {
        ApplicationCondition ac = new ApplicationCondition(this.emfGraph, domainMap, false);
        ac.setVariables(graphMap.get(nc.getConclusion()));
        ac.setFormula(this.initFormula(nc.getConclusion().getFormula(), domainMap, graphMap, conditionHandler));
        return ac;
    }

    private RuleInfo getRuleInformation(Rule rule) {
        RuleInfo ruleInfo = this.ruleInformation.get(rule);
        if (ruleInfo == null) {
            ruleInfo = new RuleInfo(rule, this.scriptEngine);
            this.ruleInformation.put(rule, ruleInfo);
        }
        return ruleInfo;
    }

    @Override
    public List<Match> findAllMatches(RuleApplication ruleApplication) {
        Rule rule = ruleApplication.getRule();
        HashSet<EObject> usedObjects = new HashSet<EObject>();
        Map<Node, EObject> prematch = ruleApplication.getMatch().getNodeMapping();
        Map<Parameter, Object> parameterValues = ruleApplication.getMatch().getParameterValues();
        return this.findAllMultiMatches(rule, usedObjects, parameterValues, prematch);
    }

    @Override
    public Match findMatch(RuleApplication ruleApplication) {
        Rule rule = ruleApplication.getRule();
        HashSet<EObject> usedObjects = new HashSet<EObject>();
        Map<Node, EObject> prematch = ruleApplication.getMatch().getNodeMapping();
        Map<Parameter, Object> parameterValues = ruleApplication.getMatch().getParameterValues();
        return this.findMatch(rule, usedObjects, parameterValues, prematch);
    }

    private Match findMatch(Rule rule, Collection<EObject> usedObjects, Map<Parameter, Object> parameterValues, Map<Node, EObject> prematch) {
        if (this.emfGraph == null) {
            throw new IllegalArgumentException("no target graph was specified for the engine");
        }
        Matchfinder matchfinder = this.prepareMatchfinder(rule, parameterValues, prematch, usedObjects);
        if (matchfinder == null) {
            return null;
        }
        Solution solution = matchfinder.getNextMatch();
        if (solution == null) {
            return null;
        }
        Match match = new Match(rule, solution, this.getRuleInformation(rule).getVariableInfo().getNode2variable());
        for (Rule mRule : rule.getMultiRules()) {
            HashSet<EObject> usedKernelObjects = new HashSet<EObject>(usedObjects);
            usedKernelObjects.addAll(match.getNodeMapping().values());
            HashMap<Node, EObject> multiPrematch = new HashMap<Node, EObject>();
            for (Mapping multiMapping : mRule.getMultiMappings()) {
                multiPrematch.put(multiMapping.getImage(), match.getNodeMapping().get(multiMapping.getOrigin()));
            }
            List<Match> multiMatches = this.findAllMultiMatches(mRule, usedKernelObjects, parameterValues, multiPrematch);
            match.getNestedMatchesFor(mRule).addAll(multiMatches);
        }
        return match;
    }

    private List<Match> findAllMultiMatches(Rule rule, Collection<EObject> usedObjects, Map<Parameter, Object> parameterValues, Map<Node, EObject> prematch) {
        if (this.emfGraph == null) {
            throw new IllegalArgumentException("no target graph was specified for the engine");
        }
        Matchfinder matchfinder = this.prepareMatchfinder(rule, parameterValues, prematch, usedObjects);
        if (matchfinder == null) {
            return new ArrayList<Match>();
        }
        List solutions = matchfinder.getAllMatches();
        ArrayList<Match> matches = new ArrayList<Match>();
        for (Solution solution : solutions) {
            Match match = new Match(rule, solution, this.getRuleInformation(rule).getVariableInfo().getNode2variable());
            for (Rule mRule : rule.getMultiRules()) {
                HashSet<EObject> usedKernelObjects = new HashSet<EObject>(usedObjects);
                usedKernelObjects.addAll(match.getNodeMapping().values());
                HashMap<Node, EObject> multiPrematch = new HashMap<Node, EObject>();
                for (Mapping multiMapping : mRule.getMultiMappings()) {
                    multiPrematch.put(multiMapping.getImage(), match.getNodeMapping().get(multiMapping.getOrigin()));
                }
                List<Match> multiMatches = this.findAllMultiMatches(mRule, usedKernelObjects, parameterValues, multiPrematch);
                match.getNestedMatchesFor(mRule).addAll(multiMatches);
            }
            matches.add(match);
        }
        return matches;
    }

    @Override
    public Match applyRule(RuleApplication ruleApplication) {
        Match match = this.findMatch(ruleApplication);
        if (match != null) {
            ruleApplication.setMatch(match);
            Match comatch = this.executeModelChanges(ruleApplication);
            ruleApplication.setComatch(comatch);
            return comatch;
        }
        return null;
    }

    public void purgeCache() {
        this.ruleInformation.clear();
    }

    private Match executeModelChanges(RuleApplication ruleApplication) {
        Rule rule = ruleApplication.getRule();
        Match match = ruleApplication.getMatch();
        if (!match.isComplete()) {
            return null;
        }
        ModelChange modelChange = new ModelChange();
        HashMap<Node, EObject> comatchNodeMapping = new HashMap<Node, EObject>();
        Match comatch = this.accumulateModelChange(rule, match, modelChange, comatchNodeMapping);
        modelChange.applyChanges();
        ruleApplication.setModelChange(modelChange);
        return comatch;
    }

    private Match accumulateModelChange(Rule rule, Match match, ModelChange modelChange, Map<Node, EObject> comatchNodeMapping) {
        Match comatch = this.createModelChange(rule, match, modelChange, comatchNodeMapping);
        for (Rule mRule : rule.getMultiRules()) {
            for (Match multiMatch : match.getNestedMatchesFor(mRule)) {
                HashMap<Node, EObject> multiComatchNodeMapping = new HashMap<Node, EObject>();
                for (Mapping comatchMapping : mRule.getMultiMappings()) {
                    if (!comatchMapping.getImage().getGraph().isRhs()) continue;
                    multiComatchNodeMapping.put(comatchMapping.getImage(), comatch.getNodeMapping().get(comatchMapping.getOrigin()));
                }
                Match multiComatch = this.accumulateModelChange(mRule, multiMatch, modelChange, multiComatchNodeMapping);
                comatch.addNestedMatch(mRule, multiComatch);
            }
        }
        return comatch;
    }

    protected Match createModelChange(Rule rule, Match match, ModelChange modelChange, Map<Node, EObject> comatchNodeMapping) {
        ChangeInfo changeInfo = this.getRuleInformation(rule).getChangeInfo();
        if (!match.isComplete()) {
            return null;
        }
        Map<Node, EObject> matchNodeMapping = match.getNodeMapping();
        HashMap<Parameter, Object> comatchParameterValues = new HashMap<Parameter, Object>();
        comatchParameterValues.putAll(match.getParameterValues());
        for (Parameter parameter : match.getParameterValues().keySet()) {
            this.scriptEngine.put(parameter.getName(), match.getParameterValues().get(parameter));
        }
        for (Node node : changeInfo.getCreatedNodes()) {
            Parameter parameter;
            EClass type = node.getType();
            EPackage ePackage = type.getEPackage();
            EObject newObject = ePackage.getEFactoryInstance().create(type);
            modelChange.addCreatedObject(newObject);
            this.emfGraph.addEObject(newObject);
            comatchNodeMapping.put(node, newObject);
            if (node.getName() == null || node.getName().isEmpty() || (parameter = rule.getParameterByName(node.getName())) == null) continue;
            comatchParameterValues.put(parameter, newObject);
        }
        for (Node node : changeInfo.getDeletedNodes()) {
            modelChange.addDeletedObject(match.getNodeMapping().get(node));
            EObject removedNode = match.getNodeMapping().get(node);
            this.emfGraph.removeEObject(removedNode);
            if (rule.isCheckDangling()) continue;
            Collection removedEdges = this.emfGraph.getCrossReferenceAdapter().getInverseReferences(removedNode);
            for (EStructuralFeature.Setting edge : removedEdges) {
                modelChange.addReferenceChange(edge.getEObject(), (EReference)edge.getEStructuralFeature(), removedNode, true);
            }
        }
        for (Node node : changeInfo.getPreservedNodes()) {
            Parameter parameter;
            Node lhsNode = HenshinMappingUtil.getRemoteNode((Collection)rule.getMappings(), (Node)node);
            EObject targetObject = matchNodeMapping.get(lhsNode);
            comatchNodeMapping.put(node, targetObject);
            if (node.getName() == null || node.getName().isEmpty() || (parameter = rule.getParameterByName(node.getName())) == null) continue;
            comatchParameterValues.put(parameter, targetObject);
        }
        for (Edge edge : changeInfo.getDeletedEdges()) {
            modelChange.addReferenceChange(matchNodeMapping.get(edge.getSource()), edge.getType(), matchNodeMapping.get(edge.getTarget()), true);
        }
        for (Edge edge : changeInfo.getCreatedEdges()) {
            modelChange.addReferenceChange(comatchNodeMapping.get(edge.getSource()), edge.getType(), comatchNodeMapping.get(edge.getTarget()), false);
        }
        for (Attribute attribute : changeInfo.getAttributeChanges()) {
            EObject targetObject = comatchNodeMapping.get(attribute.getNode());
            Object value = this.evalAttributeExpression(attribute);
            String valueString = null;
            if (value != null && (valueString = value.toString()).endsWith(".0") && attribute.getType().getEAttributeType().getClassifierID() != 50) {
                valueString = valueString.substring(0, valueString.length() - 2);
            }
            modelChange.addAttributeChange(targetObject, attribute.getType(), valueString, false);
            value = EcoreUtil.createFromString((EDataType)attribute.getType().getEAttributeType(), (String)valueString);
        }
        return new Match(rule, comatchParameterValues, comatchNodeMapping);
    }

    private Object evalAttributeExpression(Attribute attribute) {
        EEnum eenum;
        EEnumLiteral eelit;
        if (attribute.getType() != null && attribute.getType().getEType() instanceof EEnum && (eelit = (eenum = (EEnum)attribute.getType().getEType()).getEEnumLiteral(attribute.getValue())) != null) {
            return eelit;
        }
        try {
            return this.scriptEngine.eval(attribute.getValue());
        }
        catch (ScriptException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void redoChanges(RuleApplication ruleApplication) {
        ModelChange modelChange = ruleApplication.getModelChange();
        for (EObject createdObject : modelChange.getCreatedObjects()) {
            this.emfGraph.addEObject(createdObject);
        }
        for (EObject deletedObject : modelChange.getDeletedObjects()) {
            this.emfGraph.removeEObject(deletedObject);
        }
        modelChange.redoChanges();
    }

    @Override
    public void undoChanges(RuleApplication ruleApplication) {
        ModelChange modelChange = ruleApplication.getModelChange();
        modelChange.undoChanges();
        for (EObject deletedObject : modelChange.getDeletedObjects()) {
            this.emfGraph.addEObject(deletedObject);
        }
        for (EObject createdObject : modelChange.getCreatedObjects()) {
            this.emfGraph.removeEObject(createdObject);
        }
    }

    public EmfGraph getEmfGraph() {
        return this.emfGraph;
    }

    public void setEmfGraph(EmfGraph emfGraph) {
        this.emfGraph = emfGraph;
    }

    public TransformationOptions getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(TransformationOptions options) {
        this.options = options;
    }

    public static Map<Node, EObject> createPrematch(TransformationUnit unit, Map<Parameter, Object> parameterValues) {
        HashMap<Node, EObject> prematch = new HashMap<Node, EObject>();
        Rule rule = null;
        if (unit instanceof Rule) {
            rule = (Rule)unit;
        }
        if (rule != null) {
            for (Parameter parameter : unit.getParameters()) {
                Node node = rule.getNodeByName(parameter.getName(), true);
                if (node == null) continue;
                prematch.put(node, (EObject)parameterValues.get(parameter));
            }
        }
        return prematch;
    }
}

